/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.util;

import com.ericsson.ere.annotations.jcip.Immutable;
import com.ericsson.ere.selectiontree.conditions.string.IPVersion;
import com.ericsson.ere.selectiontree.util.SubNet;
import java.math.BigInteger;

@Immutable
public class SubNetIPv4
extends SubNet {
    private SubNetIPv4(BigInteger ipAddress, BigInteger netMask) {
        super(ipAddress, netMask);
    }

    public static SubNetIPv4 parseIPv4SubNetFromString(String subNetString) {
        String[] subNetParts;
        BigInteger netMaskValue = null;
        BigInteger ipValue = null;
        if (subNetString != null && (subNetParts = subNetString.split("/", -1)).length < 3) {
            try {
                netMaskValue = subNetParts.length > 1 ? SubNetIPv4.generateNetMask(Integer.parseInt(subNetParts[1]), IPVersion.IPv4) : SubNetIPv4.generateNetMask(32, IPVersion.IPv4);
                ipValue = SubNetIPv4.parseIPv4FromString(subNetParts[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return ipValue != null && netMaskValue != null ? new SubNetIPv4(ipValue, netMaskValue) : null;
    }

    public static boolean isValidIPv4Subnet(String subNetString) {
        return SubNetIPv4.parseIPv4SubNetFromString(subNetString) != null;
    }

    private static BigInteger parseIPv4FromString(String theIPv4Addr) {
        boolean isValidIPAddr = false;
        BigInteger ipAddrValue = null;
        String[] ipAddrParts = theIPv4Addr.split("\\.", -1);
        if (ipAddrParts.length == 4) {
            int currentPos = 3;
            ipAddrValue = BigInteger.ZERO;
            isValidIPAddr = true;
            for (int index = 0; index < ipAddrParts.length; ++index) {
                int ipAddrPartIntValue;
                try {
                    ipAddrPartIntValue = Integer.parseInt(ipAddrParts[index]);
                }
                catch (NumberFormatException e) {
                    isValidIPAddr = false;
                    break;
                }
                if (!SubNetIPv4.isIPAddrPartValid(ipAddrPartIntValue) || ipAddrParts[index].length() > 3) {
                    isValidIPAddr = false;
                    break;
                }
                ipAddrValue = ipAddrValue.add(BigInteger.valueOf(ipAddrPartIntValue).shiftLeft(8 * currentPos--));
            }
        }
        return isValidIPAddr ? ipAddrValue : null;
    }

    private static boolean isIPAddrPartValid(int partValue) {
        return partValue >= 0 && partValue <= 255;
    }

    @Override
    protected BigInteger parseIPFromString(String theIPv4Addr) {
        return SubNetIPv4.parseIPv4FromString(theIPv4Addr);
    }

    @Override
    protected BigInteger parseIPFromOctetString(String theIPAddr) {
        BigInteger octetIp = null;
        try {
            octetIp = theIPAddr.length() == 8 ? new BigInteger(theIPAddr, 16) : null;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return octetIp;
    }
}

