/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.util;

import com.ericsson.ere.defs.RMAClassRepository;
import com.ericsson.ere.selectiontree.interfaces.TariffStructure;
import com.ericsson.ere.selectiontree.util.SelectionTreeUtil;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.gui.ratingrules.nodes.TSCondition;
import ericsson.ere.gui.ratingrules.nodes.TSElement;
import ericsson.ere.gui.ratingrules.nodes.TSModifier;
import ericsson.ere.gui.ratingrules.nodes.TSNode;
import ericsson.ere.gui.ratingrules.nodes.TSTariffStructure;
import ericsson.ere.gui.ratingrules.nodes.TariffDAGModel;
import ericsson.ere.interfaces.DAGNode;
import ericsson.ere.interfaces.TariffStructureNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class SelectionTreeGUIUtil {
    private SelectionTreeGUIUtil() {
    }

    public static TSElement getTSElement(TariffStructureNode elem) throws Exception {
        TSElement ts = SelectionTreeUtil.getElementData(elem, TSElement.class);
        if (ts == null) {
            TariffStructureNode root = SelectionTreeUtil.getTreeRoot(elem);
            ClassRepository repository = ((TariffStructure)((Object)root)).getClassRepository();
            if (!(repository instanceof RMAClassRepository)) {
                throw new IllegalArgumentException("Requires an RMAClassRepository instance for constraints to work.");
            }
            Element config = SelectionTreeUtil.getElementConfiguration(elem);
            ts = SelectionTreeGUIUtil.createTSElementInstance(repository, root, elem, config);
            SelectionTreeUtil.setElementData(elem, TSElement.class, ts);
        }
        return ts;
    }

    private static TSElement createTSElementInstance(ClassRepository rep, TariffStructureNode root, TariffStructureNode elem, Node config) throws Exception {
        TSElement ts;
        TariffDAGModel model = null;
        switch (elem.getNodeType()) {
            case 2: {
                ts = new TSCondition(rep);
                break;
            }
            case 3: {
                ts = new TSModifier(rep);
                break;
            }
            case 1: {
                ts = new TSNode(rep);
                break;
            }
            case 0: {
                ts = new TSTariffStructure(rep);
                model = new TariffDAGModel(null, ts){

                    @Override
                    protected void nodeChanged(DAGNode node, boolean fireChangeToRoot) {
                        this.fireTreeNodesChanged(node, new Object[]{node}, new int[0], new Object[0]);
                    }
                };
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown node type: " + elem.getNodeType()));
            }
        }
        if (model == null) {
            TSElement tsroot = SelectionTreeGUIUtil.getTSElement(root);
            model = tsroot.getTreeModel();
        }
        ts.init(config);
        ts.setTreeModel(model);
        return ts;
    }
}

