/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.util;

import com.ericsson.ere.annotations.jcip.Immutable;
import com.ericsson.ere.selectiontree.util.FieldOrientedPluginUtil;
import com.ericsson.ere.selectiontree.util.ValueFieldCompositeObject;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Immutable
public class MultipleValueFieldCompositeObject
extends ValueFieldCompositeObject {
    private final List<ValueFieldCompositeObject> myVFCOs;

    public MultipleValueFieldCompositeObject(Element element) {
        super(element);
        NodeList nodeList = element.getElementsByTagName("Value");
        this.myVFCOs = new ArrayList<ValueFieldCompositeObject>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node child = nodeList.item(i);
            this.myVFCOs.add(new ValueFieldCompositeObject((Element)child));
        }
    }

    public MultipleValueFieldCompositeObject(List<FieldDefinition> fieldDefinitions, ClassRepository repository) {
        super(ValueFieldCompositeObject.Mode.Field, "");
        this.myVFCOs = new ArrayList<ValueFieldCompositeObject>();
        for (FieldDefinition fd : fieldDefinitions) {
            ValueFieldCompositeObject vfco = FieldOrientedPluginUtil.createDefaultValueForField(fd);
            this.myVFCOs.add(vfco);
        }
    }

    public MultipleValueFieldCompositeObject(List<ValueFieldCompositeObject> vfcos) {
        super(ValueFieldCompositeObject.Mode.Field, "");
        this.myVFCOs = new ArrayList<ValueFieldCompositeObject>(vfcos);
    }

    @Override
    public void appendXML(Node parent) {
        Document owner = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = owner.createElement("Complex");
        parent.appendChild(element);
        for (ValueFieldCompositeObject vfco : this.myVFCOs) {
            vfco.appendXML(element);
        }
    }

    @Override
    public String getFieldOrValueAsString() {
        StringBuilder builder = new StringBuilder();
        for (ValueFieldCompositeObject vfco : this.myVFCOs) {
            if (vfco.getMode() == ValueFieldCompositeObject.Mode.Value) {
                builder.append("'");
            }
            builder.append(vfco.getFieldOrValueAsString());
            if (vfco.getMode() == ValueFieldCompositeObject.Mode.Value) {
                builder.append("'");
            }
            if (this.myVFCOs.indexOf(vfco) >= this.myVFCOs.size() - 1) continue;
            builder.append(";");
        }
        return builder.toString();
    }

    @Override
    public Object getValueAsObject() {
        ArrayList<ValueFieldCompositeObject> objects = new ArrayList<ValueFieldCompositeObject>();
        for (ValueFieldCompositeObject vfco : this.myVFCOs) {
            objects.add(vfco);
        }
        return objects;
    }

    @Override
    public ValueFieldCompositeObject.Mode getMode() {
        return ValueFieldCompositeObject.Mode.Value;
    }

    @Override
    public DataType getValueDataType() {
        throw new UnsupportedOperationException("Not available for MultipleValueFieldCompositeObject");
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.myVFCOs == null ? 0 : this.myVFCOs.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MultipleValueFieldCompositeObject other = (MultipleValueFieldCompositeObject)obj;
        return !(this.myVFCOs == null ? other.myVFCOs != null : !this.myVFCOs.equals(other.myVFCOs));
    }
}

