/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.util;

import com.ericsson.ere.interfaces.XMLAppendable;
import com.ericsson.ere.selectiontree.util.FieldOrientedPluginUtil;
import com.ericsson.ere.selectiontree.util.ValueFieldCompositeObject;
import ericsson.ere.util.StringUtil;
import ericsson.ere.xml.XMLUtil;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class HierarchicalFieldCompositeObject
implements XMLAppendable {
    private static final String INDEX = "Index";
    private static final String FIELD = "Field";
    private String myFieldName;
    private List<HierarchicalFieldCompositeObject> myChildren = new ArrayList<HierarchicalFieldCompositeObject>();
    private ValueFieldCompositeObject myIndex;

    public HierarchicalFieldCompositeObject(Element element) {
        this.init(element);
    }

    public HierarchicalFieldCompositeObject(String name) {
        this.myFieldName = name;
    }

    public ValueFieldCompositeObject getIndexObject() {
        return this.myIndex;
    }

    public void setIndexObject(ValueFieldCompositeObject index) {
        this.myIndex = index;
    }

    public void setFieldName(String name) {
        this.myFieldName = name;
    }

    public String getFieldName() {
        return this.myFieldName;
    }

    @Override
    public void appendXML(Node parent) {
        Document owner = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element valueElement = owner.createElement(FIELD);
        parent.appendChild(valueElement);
        valueElement.setTextContent(this.myFieldName);
        if (this.myIndex != null) {
            Element keyElement = owner.createElement(INDEX);
            this.myIndex.appendXML(keyElement);
            valueElement.appendChild(keyElement);
        }
        for (HierarchicalFieldCompositeObject child : this.getChildren()) {
            child.appendXML(valueElement);
        }
    }

    private void init(Node node) {
        if (node != null) {
            if (FIELD.equals(node.getNodeName())) {
                this.myFieldName = XMLUtil.getFirstTextContent(node);
                this.myIndex = FieldOrientedPluginUtil.createValueFieldCompositeObjectFromIndexElement(XMLUtil.getNamedElement(INDEX, node.getChildNodes()));
                List<Element> children = XMLUtil.getElementNodesNamed(FIELD, node.getChildNodes());
                this.setChildren(new ArrayList<HierarchicalFieldCompositeObject>());
                for (Element child : children) {
                    this.getChildren().add(new HierarchicalFieldCompositeObject(child));
                }
            } else {
                throw new IllegalArgumentException("Tag name in XML (" + node.getNodeName() + ") is not " + FIELD + ".");
            }
        }
    }

    public List<HierarchicalFieldCompositeObject> getChildren() {
        return this.myChildren;
    }

    public void setChildren(List<HierarchicalFieldCompositeObject> children) {
        this.myChildren = children;
    }

    public List<String> getReservedFields() {
        ArrayList<String> reservedFields = new ArrayList<String>();
        if (this.myFieldName != null) {
            reservedFields.add(this.myFieldName);
        }
        for (HierarchicalFieldCompositeObject child : this.getChildren()) {
            reservedFields.addAll(child.getReservedFields());
        }
        if (this.myIndex != null && !StringUtil.isEmptyString(this.myIndex.getFieldOrValueAsString()) && this.myIndex.getMode() == ValueFieldCompositeObject.Mode.Field) {
            reservedFields.add(this.myIndex.getFieldOrValueAsString());
        }
        return reservedFields;
    }
}

