/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.util;

import com.ericsson.ere.dataset.DefaultDataDescriber;
import com.ericsson.ere.datatype.EREDateUtil;
import com.ericsson.ere.selectiontree.FieldFilter;
import com.ericsson.ere.selectiontree.HierarchicalFieldFilter;
import com.ericsson.ere.selectiontree.util.FieldIndexFormatter;
import com.ericsson.ere.selectiontree.util.FieldOrientedPluginUtil;
import com.ericsson.ere.selectiontree.util.MultipleValueFieldCompositeObject;
import com.ericsson.ere.selectiontree.util.ValueFieldCompositeObject;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.defs.FieldDefinitionHelper;
import ericsson.ere.gui.util.VariableFactory;
import ericsson.ere.interfaces.FieldHierarchyNode;
import ericsson.ere.util.StringUtil;
import ericsson.vareditor.variable.CompositeValueVariable;
import ericsson.vareditor.variable.DropDownVariable;
import ericsson.vareditor.variable.FieldUser;
import ericsson.vareditor.variable.FilterableTypedDropDownVariable;
import ericsson.vareditor.variable.InfoVariable;
import ericsson.vareditor.variable.TypedDropDownVariable;
import ericsson.vareditor.variable.ValueFieldVariable;
import ericsson.vareditor.variable.Variable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;

public final class FieldOrientedPluginProfileUtil {
    private static final String VALIDATION = "VALIDATION";
    private static final String SEPARATOR = " ; ";

    private FieldOrientedPluginProfileUtil() {
    }

    public static VariableFactory.IndexType getIndexTypeForFieldSingleIndex(FieldDefinition fieldDefinition) {
        FieldOrientedPluginProfileUtil.checkParameterThrowIfNull(fieldDefinition);
        if (fieldDefinition.isArray()) {
            return VariableFactory.IndexType.Pos_Integer_Numeric;
        }
        return FieldOrientedPluginProfileUtil.getAlphanumericTypeIfFieldDefinitionIsMap(fieldDefinition);
    }

    public static VariableFactory.IndexType getIndexTypeForFieldMultipleIndicies(FieldDefinition fieldDefinition) {
        FieldOrientedPluginProfileUtil.checkParameterThrowIfNull(fieldDefinition);
        if (fieldDefinition.isArray()) {
            return VariableFactory.IndexType.Numeric_Range;
        }
        return FieldOrientedPluginProfileUtil.getAlphanumericTypeIfFieldDefinitionIsMap(fieldDefinition);
    }

    @Deprecated
    public static ValueFieldCompositeObject createValueFieldCompositeObjectFromIndexElement(Element indexElement) {
        return FieldOrientedPluginUtil.createValueFieldCompositeObjectFromIndexElement(indexElement);
    }

    private static void checkParameterThrowIfNull(Object obj) {
        if (obj == null) {
            throw new IllegalArgumentException("Parameter cannot be null");
        }
    }

    private static VariableFactory.IndexType getAlphanumericTypeIfFieldDefinitionIsMap(FieldDefinition fieldDefinition) {
        if (fieldDefinition.isMap()) {
            return VariableFactory.IndexType.Alphanumeric;
        }
        return null;
    }

    public static String formatFieldNameStringWithIndexOrKeyIfPresent(FieldDefinition fieldDefinition, ValueFieldCompositeObject vfco, ClassRepository aRep) {
        if (fieldDefinition == null) {
            throw new IllegalArgumentException("Parameter cannot be null");
        }
        FieldIndexFormatter formatter = new FieldIndexFormatter(fieldDefinition);
        formatter.setSeparator(SEPARATOR);
        return formatter.format(aRep, vfco);
    }

    public static String formatFieldNameStringWithIndexOrKeyIfPresent(FieldHierarchyNode fieldNode, ValueFieldCompositeObject vfco, ClassRepository aRep) {
        if (fieldNode == null) {
            throw new IllegalArgumentException("Parameter cannot be null");
        }
        FieldIndexFormatter formatter = new FieldIndexFormatter(fieldNode);
        formatter.setSeparator(SEPARATOR);
        return formatter.format(aRep, vfco);
    }

    @Deprecated
    public static String formatFieldNameStringWithIndexOrKeyIfPresent(FieldDefinition fieldDefinition, ValueFieldCompositeObject vfco) {
        return FieldOrientedPluginProfileUtil.formatFieldNameStringWithIndexOrKeyIfPresent(fieldDefinition, vfco, null);
    }

    public static String[] includeFieldIfValidation(ClassRepository repository, String[] fields, String currentField) {
        List<String> list = Arrays.asList(fields);
        List<String> ret = FieldOrientedPluginProfileUtil.includeFieldIfValidation(repository, list, currentField);
        return ret == list ? fields : ret.toArray(new String[ret.size()]);
    }

    public static List<String> includeFieldIfValidation(ClassRepository repository, List<String> fields, String currentField) {
        return FieldOrientedPluginProfileUtil.includeFieldIfOfParameterType(repository, fields, currentField, VALIDATION);
    }

    public static List<FieldDefinition> includeFieldIfValidation(List<FieldDefinition> fields, FieldDefinition currentField) {
        if (currentField != null && VALIDATION.equals(currentField.getParameterType())) {
            boolean found = false;
            for (FieldDefinition field : fields) {
                if (!field.equals(currentField)) continue;
                found = true;
                break;
            }
            if (!found) {
                fields.add(currentField);
            }
        }
        return fields;
    }

    public static String[] includeFieldIfTDF(ClassRepository repository, String[] fields, String currentField) {
        List<String> list = Arrays.asList(fields);
        List<String> ret = FieldOrientedPluginProfileUtil.includeFieldIfTDF(repository, list, currentField);
        return ret == list ? fields : ret.toArray(new String[ret.size()]);
    }

    public static List<String> includeFieldIfTDF(ClassRepository repository, List<String> fields, String currentField) {
        return FieldOrientedPluginProfileUtil.includeFieldIfOfParameterType(repository, fields, currentField, "INTERNAL");
    }

    public static String[] includeFieldIfTDFOrValidation(ClassRepository repository, String[] fields, String currentField) {
        List<String> list = Arrays.asList(fields);
        List<String> ret = FieldOrientedPluginProfileUtil.includeFieldIfTDFOrValidation(repository, list, currentField);
        return ret == list ? fields : ret.toArray(new String[ret.size()]);
    }

    public static List<String> includeFieldIfTDFOrValidation(ClassRepository repository, List<String> fields, String currentField) {
        return FieldOrientedPluginProfileUtil.includeFieldIfOfParameterType(repository, fields, currentField, VALIDATION, "INTERNAL");
    }

    private static List<String> includeFieldIfOfParameterType(ClassRepository repository, List<String> fields, String currentField, String ... parameterTypes) {
        List<String> ret = fields;
        FieldDefinition field = repository.getFieldDefinitionByName(currentField);
        if (field != null) {
            for (String parameterType : parameterTypes) {
                if (!parameterType.equals(field.getParameterType())) continue;
                ret = new ArrayList<String>(fields);
                ret.add(currentField);
                break;
            }
        }
        return ret;
    }

    public static boolean fieldIsTDF(FieldDefinition fieldDefinition) {
        if (fieldDefinition == null) {
            throw new IllegalArgumentException("The field definition cannot be null");
        }
        return "INTERNAL".equals(fieldDefinition.getParameterType());
    }

    public static boolean fieldIsTDF(String fieldName, ClassRepository repository) {
        if (fieldName == null || repository == null) {
            throw new IllegalArgumentException("Parameter cannot be null");
        }
        FieldDefinition fieldDefinition = repository.getFieldDefinitionByName(fieldName);
        return fieldDefinition != null && FieldOrientedPluginProfileUtil.fieldIsTDF(fieldDefinition);
    }

    public static boolean fieldIsVirtual(FieldDefinition fieldDefinition) {
        if (fieldDefinition == null) {
            throw new IllegalArgumentException("The field definition cannot be null");
        }
        return "VIRTUAL".equals(fieldDefinition.getParameterType());
    }

    public static boolean fieldIsParameterTypeIn(FieldDefinition fieldDefinition) {
        if (fieldDefinition == null) {
            throw new IllegalArgumentException("The field definition cannot be null");
        }
        return "IN".equals(fieldDefinition.getParameterType());
    }

    public static boolean fieldIsParameterTypeOut(FieldDefinition fieldDefinition) {
        if (fieldDefinition == null) {
            throw new IllegalArgumentException("The field definition cannot be null");
        }
        return "OUT".equals(fieldDefinition.getParameterType());
    }

    public static boolean fieldIsParameterTypeVariable(FieldDefinition fieldDefinition) {
        if (fieldDefinition == null) {
            throw new IllegalArgumentException("The field definition cannot be null");
        }
        return "VARIABLE".equals(fieldDefinition.getParameterType());
    }

    public static ValueFieldCompositeObject createValueFieldCompositeObjectForVariable(Variable variable) {
        if (variable == null) {
            return null;
        }
        if (variable instanceof ValueFieldVariable) {
            return (ValueFieldCompositeObject)((ValueFieldVariable)variable).getValueObject();
        }
        if (variable instanceof CompositeValueVariable) {
            return (ValueFieldCompositeObject)((CompositeValueVariable)variable).getValueObject();
        }
        DataType dataType = DataType.fromClass(variable.getValueClass());
        return new ValueFieldCompositeObject(ValueFieldCompositeObject.Mode.Value, variable.getValueString(), dataType);
    }

    public static Variable createIndexVariable(String label, String key, FieldDefinition field, ClassRepository repository, Element configuration, boolean allowMultipleIndices) {
        ValueFieldCompositeObject vfco = FieldOrientedPluginUtil.createValueFieldCompositeObjectFromIndexElement(configuration);
        return FieldOrientedPluginProfileUtil.createIndexVariable(label, key, field, repository, vfco, allowMultipleIndices);
    }

    public static Variable createIndexVariable(String label, String key, FieldDefinition field, ClassRepository repository, ValueFieldCompositeObject configObject, boolean allowMultipleIndices) {
        FieldOrientedPluginProfileUtil.checkParameterThrowIfNull(label);
        FieldOrientedPluginProfileUtil.checkParameterThrowIfNull(repository);
        Variable indexVariable = null;
        if (field != null && (field.isMap() || field.isArray())) {
            if (FieldOrientedPluginProfileUtil.fieldHasComplexKey(field)) {
                indexVariable = FieldOrientedPluginProfileUtil.createComplexIndexVariable(label, key, field, repository, configObject);
            } else {
                VariableFactory.IndexType indexType = FieldOrientedPluginProfileUtil.extractIndexTypeForField(field, allowMultipleIndices);
                indexVariable = VariableFactory.createIndexVariableForField(field, indexType, repository, configObject, label);
                FieldOrientedPluginProfileUtil.updateVariableWithKeyIfNotNull(indexVariable, key);
            }
            if (indexVariable == null) {
                indexVariable = new InfoVariable(label, "Error when creating index variable");
            }
        }
        return indexVariable;
    }

    public static Variable createFieldListVariable(String label, String key, List<String> fields, String defaultChoice) {
        TypedDropDownVariable<String> variable = new TypedDropDownVariable<String>(label, (T[])fields.toArray(new String[fields.size()]));
        if (key != null) {
            variable.setKey(key);
        }
        if (defaultChoice != null) {
            variable.setSelectedItem(defaultChoice);
        }
        return variable;
    }

    public static <T extends FieldHierarchyNode> FilterableTypedDropDownVariable<T> createFilterableFieldListVariable(String label, String key, List<T> fields, T defaultChoice) {
        FilterableTypedDropDownVariable.FilterableTypedDropDownVariableBuilder<T> builder = FilterableTypedDropDownVariable.builder(label, fields).withItemDisplayer(new FieldDisplayer());
        if (defaultChoice != null) {
            builder.withSelectedItem(defaultChoice);
        }
        FilterableTypedDropDownVariable<T> variable = builder.build();
        if (key != null) {
            variable.setKey(key);
        }
        return variable;
    }

    public static Collection<String> extractReservedFieldsFromVariable(Variable variable, boolean variableIsKnownFieldUser) {
        if (variable instanceof FieldUser) {
            return new HashSet<String>(((FieldUser)((Object)variable)).getReservedFields());
        }
        if (variableIsKnownFieldUser && (variable instanceof FilterableTypedDropDownVariable || variable instanceof TypedDropDownVariable || variable instanceof DropDownVariable)) {
            return Collections.singleton(variable.getValueString());
        }
        return Collections.emptySet();
    }

    public static Collection<String> extractReservedTreeDefinedFieldFromVariable(Variable variable, ClassRepository repository, boolean variableIsKnownFieldUser) {
        Collection<String> usedFields = FieldOrientedPluginProfileUtil.extractReservedFieldsFromVariable(variable, variableIsKnownFieldUser);
        HashSet<String> tdfNames = new HashSet<String>();
        for (String fieldName : usedFields) {
            if (!FieldOrientedPluginProfileUtil.fieldIsTDF(fieldName, repository)) continue;
            tdfNames.add(fieldName);
        }
        return tdfNames;
    }

    private static Variable createComplexIndexVariable(String label, String key, FieldDefinition field, ClassRepository repository, ValueFieldCompositeObject configObject) {
        CompositeValueVariable indexVariable = null;
        List<FieldDefinition> keyFields = FieldOrientedPluginUtil.extractKeyFields(field, repository);
        if (configObject == null) {
            indexVariable = new CompositeValueVariable(keyFields, repository, label);
        } else if (configObject instanceof MultipleValueFieldCompositeObject) {
            List list = (List)configObject.getValueAsObject();
            indexVariable = new CompositeValueVariable(keyFields, repository, list, label);
        }
        return indexVariable;
    }

    private static VariableFactory.IndexType extractIndexTypeForField(FieldDefinition field, boolean allowMultipleIndices) {
        if (allowMultipleIndices) {
            return FieldOrientedPluginProfileUtil.getIndexTypeForFieldMultipleIndicies(field);
        }
        return FieldOrientedPluginProfileUtil.getIndexTypeForFieldSingleIndex(field);
    }

    private static void updateVariableWithKeyIfNotNull(Variable variable, String key) {
        if (key != null) {
            variable.setKey(key);
        }
    }

    private static boolean fieldHasComplexKey(FieldDefinition field) {
        String[] keys = field.getKeyFields();
        return keys.length > 1;
    }

    public static List<FieldDefinition> getSupportedFields(List<FieldDefinition> candidateFields, FieldFilter filter) {
        ArrayList<FieldDefinition> supportedFields = new ArrayList<FieldDefinition>();
        for (FieldDefinition field : candidateFields) {
            if (!filter.isAllowed(field)) continue;
            supportedFields.add(field);
        }
        FieldDefinitionHelper.sortFieldsOnName(supportedFields);
        return supportedFields;
    }

    public static List<FieldHierarchyNode> getSupportedFields(List<FieldHierarchyNode> candidateFields, HierarchicalFieldFilter ... filters) {
        ArrayList<FieldHierarchyNode> supportedFields = new ArrayList<FieldHierarchyNode>();
        for (FieldHierarchyNode field : candidateFields) {
            boolean isAllowed = true;
            Iterator<HierarchicalFieldFilter> iterator = Arrays.asList(filters).iterator();
            while (iterator.hasNext() && isAllowed) {
                isAllowed = iterator.next().isAllowed(field);
            }
            if (!isAllowed) continue;
            supportedFields.add(field);
        }
        FieldDefinitionHelper.sortFieldsOnName(supportedFields);
        return supportedFields;
    }

    public static String describeValueForField(Variable valueVar, ClassRepository repository, FieldDefinition referenceField, boolean quoteStrings) {
        String displayString = valueVar.toString();
        Object vo = valueVar.getValueObject();
        if (EREDateUtil.isBoundaryDate(vo)) {
            DefaultDataDescriber describer = new DefaultDataDescriber();
            if (referenceField != null) {
                displayString = describer.describeObject(vo, referenceField);
            } else {
                DataType dt = DataType.lookup(valueVar.getTypename());
                if (dt != null) {
                    displayString = describer.describeObject(vo, dt);
                }
            }
        }
        if (quoteStrings && FieldOrientedPluginProfileUtil.shouldBeQuoted(valueVar)) {
            displayString = StringUtil.quote(displayString);
        }
        return displayString;
    }

    private static boolean shouldBeQuoted(Variable var) {
        String type = var.getTypename();
        boolean isString = "String".equals(type) || "BcdString".equals(type);
        return isString && !(var instanceof DropDownVariable);
    }

    public static <U extends FieldHierarchyNode> FilterableTypedDropDownVariable<U> createFilterableFieldListVariable(String label, String key, List<U> fields, String defaultChoice) {
        FieldHierarchyNode defaultField = null;
        for (FieldHierarchyNode field : fields) {
            if (!field.getCanonicalName().equals(defaultChoice)) continue;
            defaultField = field;
            break;
        }
        FilterableTypedDropDownVariable<Object> var = FieldOrientedPluginProfileUtil.createFilterableFieldListVariable(label, key, fields, defaultField);
        if (defaultField == null) {
            var.setEditorText(defaultChoice);
        }
        return var;
    }

    public static class FieldDisplayer<G extends FieldHierarchyNode>
    implements FilterableTypedDropDownVariable.ItemDisplayer<G> {
        @Override
        public String getTooltipFor(G field) {
            return field.getTooltip();
        }

        @Override
        public String getDisplayStringFor(G field) {
            return field.getCanonicalName();
        }
    }
}

