/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.util;

import com.ericsson.ere.selectiontree.util.AvailableFieldListBuilder;
import com.ericsson.ere.selectiontree.util.FieldOrientedPluginProfileUtil;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.interfaces.FieldHierarchyNode;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class FieldListBuilderWithLegacySupport
extends AvailableFieldListBuilder {
    private FieldDefinition myLegacyField;
    private Set<FieldHierarchyNode> myAdditionalFields = new HashSet<FieldHierarchyNode>();

    public FieldListBuilderWithLegacySupport(ClassRepository rep) {
        super(rep);
    }

    public FieldListBuilderWithLegacySupport withLegacyField(FieldHierarchyNode legacyField) {
        this.myLegacyField = legacyField != null && legacyField.isLeaf() ? (FieldDefinition)legacyField : null;
        return this;
    }

    public FieldListBuilderWithLegacySupport withAdditionalFields(List<FieldHierarchyNode> additionalFields) {
        this.myAdditionalFields.addAll(additionalFields);
        return this;
    }

    @Override
    public List<FieldHierarchyNode> buildList() {
        List<FieldHierarchyNode> list = super.buildList();
        if (this.myLegacyField != null && !list.contains(this.myLegacyField) && (FieldOrientedPluginProfileUtil.fieldIsTDF(this.myLegacyField) || "validation".equalsIgnoreCase(this.myLegacyField.getParameterType()))) {
            list.add(this.myLegacyField);
        }
        list.addAll(this.myAdditionalFields);
        return list;
    }

    @Override
    public boolean filtersAllow(FieldHierarchyNode field) {
        return this.myLegacyField != null && this.myLegacyField.equals(field) || super.filtersAllow(field);
    }
}

