/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.util;

import com.ericsson.ere.selectiontree.FieldFilter;
import ericsson.ere.defs.FieldDefinition;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class CombinedFieldFilter
implements FieldFilter {
    private final List<FieldFilter> myFilters;

    public CombinedFieldFilter(FieldFilter ... filters) {
        if (filters == null) {
            throw new IllegalArgumentException("Argument cannot be null");
        }
        this.myFilters = Arrays.asList(filters);
    }

    @Override
    public boolean isAllowed(FieldDefinition field) {
        boolean allowed = true;
        Iterator<FieldFilter> iterator = this.myFilters.iterator();
        while (iterator.hasNext() && allowed) {
            allowed = iterator.next().isAllowed(field);
        }
        return allowed;
    }
}

