/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.util;

import com.ericsson.ere.dataset.DataSet;
import ericsson.ere.datatype.Amount;
import ericsson.ere.datatype.factory.DefaultAmountFactory;
import ericsson.ere.datatype.interfaces.AmountFactory;
import ericsson.ere.datatype.interfaces.ExtendedAmountFactory;
import ericsson.ere.defs.FieldDefinition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Currency;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;

public class AmountUtil {
    private static final String DEFAULT_CURRENCY_CODE = "USD";
    private static final String[] ALL_ISO4217_CURRENCY_CODES = new String[]{"AED", "AFN", "ALL", "AMD", "ANG", "AOA", "ARS", "AUD", "AWG", "AZN", "BAM", "BBD", "BDT", "BGN", "BHD", "BIF", "BMD", "BND", "BOB", "BOV", "BRL", "BSD", "BTN", "BWP", "BYR", "BZD", "CAD", "CDF", "CHE", "CHF", "CHW", "CLF", "CLP", "CNY", "COP", "COU", "CRC", "CUC", "CUP", "CVE", "CZK", "DJF", "DKK", "DOP", "DZD", "EGP", "ERN", "ETB", "EUR", "FJD", "FKP", "GBP", "GEL", "GHS", "GIP", "GMD", "GNF", "GTQ", "GYD", "HKD", "HNL", "HRK", "HTG", "HUF", "IDR", "ILS", "INR", "IQD", "IRR", "ISK", "JMD", "JOD", "JPY", "KES", "KGS", "KHR", "KMF", "KPW", "KRW", "KWD", "KYD", "KZT", "LAK", "LBP", "LKR", "LRD", "LSL", "LTL", "LVL", "LYD", "MAD", "MDL", "MGA", "MKD", "MMK", "MNT", "MOP", "MRO", "MUR", "MVR", "MWK", "MXN", "MXV", "MYR", "MZN", "NAD", "NGN", "NIO", "NOK", "NPR", "NZD", "OMR", "PAB", "PEN", "PGK", "PHP", "PKR", "PLN", "PYG", "QAR", "RON", "RSD", "RUB", "RWF", "SAR", "SBD", "SCR", "SDG", "SEK", "SGD", "SHP", "SLL", "SOS", "SRD", "SSP", "STD", "SVC", "SYP", "SZL", "THB", "TJS", "TMT", "TND", "TOP", "TRY", "TTD", "TWD", "TZS", "UAH", "UGX", "USD", "USN", "USS", "UYI", "UYU", "UZS", "VEF", "VND", "VUV", "WST", "XAF", "XAG", "XAU", "XBA", "XBB", "XBC", "XBD", "XCD", "XDR", "XFU", "XOF", "XPD", "XPF", "XPT", "XSU", "XTS", "XUA", "XXX", "YER", "ZAR", "ZMW", "ZWL"};
    private static final String[] MISSING_CURRENCIES = new String[]{"AZM"};

    public static String getCurrencyCodeForLocale() {
        String retVal = null;
        Locale l = Locale.getDefault();
        try {
            retVal = Currency.getInstance(l).getCurrencyCode();
        }
        catch (IllegalArgumentException e) {
            retVal = DEFAULT_CURRENCY_CODE;
        }
        return retVal;
    }

    @Deprecated
    public static Object[] getAllAvaliableCurrencyCodes() {
        return AmountUtil.getAllAvailableCurrencyCodes();
    }

    public static Object[] getAllAvailableCurrencyCodes() {
        return AmountUtil.getAllAvailableCurrencyCodes(null);
    }

    public static Object[] getAllAvailableCurrencyCodes(String selection) {
        HashSet<String> set = new HashSet<String>();
        for (Locale l : Locale.getAvailableLocales()) {
            try {
                set.add(Currency.getInstance(l).getCurrencyCode());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        AmountUtil.addMissingCurrencies(set);
        if (selection != null) {
            set.add(selection);
        }
        Object[] allAvailableCurrencyCodes = set.toArray();
        Arrays.sort(allAvailableCurrencyCodes);
        return allAvailableCurrencyCodes;
    }

    private static void addMissingCurrencies(HashSet<String> set) {
        ArrayList<String> currencies = new ArrayList<String>(Arrays.asList(ALL_ISO4217_CURRENCY_CODES));
        currencies.addAll(Arrays.asList(MISSING_CURRENCIES));
        for (String currency : currencies) {
            if (set.contains(currency)) continue;
            set.add(currency);
        }
    }

    @Deprecated
    public static Object[] getAllAvaliableCurrencyCodes(String selection) {
        return AmountUtil.getAllAvailableCurrencyCodes(selection);
    }

    public static boolean allowsNegativeAmount(FieldDefinition field, boolean defaultValue) {
        if (field == null) {
            throw new IllegalArgumentException("Requires non-null field.");
        }
        Map<String, String> fieldSettings = field.getFieldSettings();
        String allowingValue = fieldSettings.get("AllowNegativeInput");
        boolean allow = allowingValue == null ? defaultValue : Boolean.parseBoolean(fieldSettings.get("AllowNegativeInput"));
        return allow;
    }

    public static Amount createDefaultAmount(DataSet dataset) {
        AmountFactory factory = dataset.getAmountFactory();
        if (factory == null) {
            factory = DefaultAmountFactory.getInstance();
        }
        String currency = factory instanceof ExtendedAmountFactory ? ((ExtendedAmountFactory)factory).getDefaultCurrencyCode() : DefaultAmountFactory.getInstance().getDefaultCurrencyCode();
        return factory.create(currency);
    }
}

