/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.tdfimport.states;

import com.ericsson.ere.gui.wizard.AbstractWizardState;
import com.ericsson.ere.gui.wizard.panels.WizardStateView;
import com.ericsson.ere.selectiontree.tdfimport.TDFImportWizardModel;
import com.ericsson.ere.selectiontree.tdfimport.panels.TDFImportFilePanel;
import com.ericsson.ere.selectiontree.tdfimport.panels.TDFImportFileView;
import com.ericsson.ere.swing.EDT;
import ericsson.ere.xml.EreXmlException;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Observable;
import java.util.Observer;
import org.w3c.dom.Document;

public class TDFImportWizardFileState
extends AbstractWizardState
implements Observer {
    private TDFImportFileView myPanel;

    public TDFImportWizardFileState(TDFImportWizardModel model) {
        super(model);
        this.myModel = model;
        this.myPanel = this.createView();
    }

    protected TDFImportFileView createView() {
        EDT.runAndWait(new Runnable(){

            @Override
            public void run() {
                TDFImportWizardFileState.this.myPanel = TDFImportWizardFileState.this.createPanel();
            }
        });
        return this.myPanel;
    }

    private TDFImportFilePanel createPanel() {
        TDFImportFilePanel panel = new TDFImportFilePanel();
        panel.addObserver(this);
        return panel;
    }

    @Override
    public void activate() {
        File selectedFile = ((TDFImportWizardModel)this.myModel).getSelectedFile();
        if (selectedFile == null) {
            this.myModel.setStandardStartNavigationButtonMode();
        } else {
            this.setBackAndNextEnabled(false, true);
        }
    }

    @Override
    public WizardStateView getPanel() {
        return this.myPanel;
    }

    @Override
    public void selectNextState() {
        if (this.myNextState != null) {
            try {
                Document doc = ((TDFImportWizardModel)this.myModel).validateFile();
                ((TDFImportWizardModel)this.myModel).createImportListFromDocument(doc);
                this.myModel.setCurrentState(this.myNextState);
            }
            catch (FileNotFoundException fnf) {
                this.myPanel.showInformation("File not found", "Selected file could not be found on the specified path.");
            }
            catch (EreXmlException xe) {
                this.myPanel.handleError(xe, "Faulty format of document, could not import file.");
            }
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        if (arg instanceof File) {
            File selectedFile = (File)arg;
            ((TDFImportWizardModel)this.myModel).setSelectedFile(selectedFile);
            this.myModel.setNextEnabled(true);
            this.myModel.setControlButtonEnabled(true);
        }
    }
}

