/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.tdfimport.states;

import com.ericsson.ere.gui.wizard.AbstractWizardState;
import com.ericsson.ere.gui.wizard.panels.WizardStateView;
import com.ericsson.ere.selectiontree.tdfimport.TDFImportWizardModel;
import com.ericsson.ere.selectiontree.tdfimport.panels.TDFImportFieldsPanel;
import com.ericsson.ere.selectiontree.tdfimport.panels.TDFImportFieldsView;
import com.ericsson.ere.swing.EDT;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;

public class TDFImportWizardFieldsState
extends AbstractWizardState
implements Observer {
    private TDFImportWizardModel myModel;
    private TDFImportFieldsView myPanel;

    public TDFImportWizardFieldsState(TDFImportWizardModel model) {
        super(model);
        this.myModel = model;
        this.myPanel = this.createView();
    }

    protected TDFImportFieldsView createView() {
        EDT.runAndWait(new Runnable(){

            @Override
            public void run() {
                TDFImportWizardFieldsState.this.myPanel = TDFImportWizardFieldsState.this.createFieldsPanel();
            }
        });
        return this.myPanel;
    }

    private TDFImportFieldsPanel createFieldsPanel() {
        TDFImportFieldsPanel panel = new TDFImportFieldsPanel(this.myModel);
        panel.addObserver(this);
        return panel;
    }

    @Override
    public void activate() {
        this.myPanel.prepareModel();
        this.validateState();
    }

    @Override
    public void selectNextState() {
        List<String> selected = this.myPanel.getSelectedTDFs();
        ArrayList<String> itemsToRemove = new ArrayList<String>();
        for (String name : selected) {
            if (this.myModel.fieldExistsInService(name)) {
                this.myPanel.notifyUserFieldIsDefinedInService(name);
                itemsToRemove.add(name);
                continue;
            }
            if (this.myModel.isUsedInTree(name)) {
                if (this.myPanel.shouldOverwriteUsedTDF(name)) continue;
                this.myPanel.removeSelectionFor(name);
                itemsToRemove.add(name);
                continue;
            }
            if (!this.myModel.existsInTree(name) || this.myPanel.shouldOverwriteExistingTDF(name)) continue;
            this.myPanel.removeSelectionFor(name);
            itemsToRemove.add(name);
        }
        for (String itemToRemove : itemsToRemove) {
            selected.remove(itemToRemove);
        }
        if (selected.size() > 0) {
            this.myModel.setSelectedTDFList(selected);
            this.myModel.setCurrentState(this.myNextState);
        } else {
            this.validateState();
        }
    }

    @Override
    public WizardStateView getPanel() {
        return this.myPanel;
    }

    @Override
    public void update(Observable o, Object arg) {
        this.validateState();
    }

    private void validateState() {
        if (this.myPanel.hasSelections()) {
            this.setNextEnabled(true);
            this.myModel.setNextEnabled(true);
        } else {
            this.setNextEnabled(false);
            this.myModel.setNextEnabled(false);
        }
        this.setBackEnabled(true);
    }
}

