/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.tdfexport.panels;

import com.ericsson.ere.gui.navigator.NavigatorFileChooser;
import com.ericsson.ere.gui.wizard.panels.AbstractWizardPanel;
import com.ericsson.ere.selectiontree.tdfexport.panels.TDFExportFileView;
import ericsson.ere.gui.GuiServiceCenter;
import ericsson.ere.gui.util.DialogFactory;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class TDFExportFilePanel
extends AbstractWizardPanel
implements TDFExportFileView {
    private JTextField myFileNameField;
    private JButton myFileBrowseBtn;
    private JLabel myFileLabel;

    public TDFExportFilePanel() {
        this.initialize();
    }

    private void initialize() {
        this.myFileLabel = new JLabel();
        this.myFileLabel.setText("Export destination:");
        GridBagConstraints fileLabelConstraints = new GridBagConstraints();
        fileLabelConstraints.gridx = 1;
        fileLabelConstraints.anchor = 16;
        fileLabelConstraints.insets = new Insets(17, 11, 0, 0);
        fileLabelConstraints.gridy = 0;
        GridBagConstraints browseBtnCOnstraints = new GridBagConstraints();
        browseBtnCOnstraints.insets = new Insets(6, 3, 10, 12);
        browseBtnCOnstraints.gridy = 1;
        browseBtnCOnstraints.anchor = 11;
        browseBtnCOnstraints.weighty = 1.0;
        browseBtnCOnstraints.gridx = 2;
        GridBagConstraints fileNameFieldConstraints = new GridBagConstraints();
        fileNameFieldConstraints.fill = 2;
        fileNameFieldConstraints.gridx = 1;
        fileNameFieldConstraints.gridy = 1;
        fileNameFieldConstraints.weightx = 1.0;
        fileNameFieldConstraints.anchor = 11;
        fileNameFieldConstraints.weighty = 1.0;
        fileNameFieldConstraints.insets = new Insets(6, 11, 5, 2);
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(443, 268));
        this.add((Component)this.createFileNameField(), fileNameFieldConstraints);
        this.add((Component)this.createFileBrowseBtn(), browseBtnCOnstraints);
        this.add((Component)this.myFileLabel, fileLabelConstraints);
    }

    private JTextField createFileNameField() {
        this.myFileNameField = new JTextField();
        this.myFileNameField.setPreferredSize(new Dimension(4, 27));
        this.myFileNameField.setEnabled(false);
        return this.myFileNameField;
    }

    private JButton createFileBrowseBtn() {
        this.myFileBrowseBtn = new JButton();
        this.myFileBrowseBtn.setText("Browse");
        this.myFileBrowseBtn.setName("TDFExportFilePanel.JButton.Browse");
        this.myFileBrowseBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                File targetFile = NavigatorFileChooser.getExportFile("Export to file");
                if (targetFile != null) {
                    TDFExportFilePanel.this.myFileNameField.setText(targetFile.getAbsolutePath());
                } else {
                    TDFExportFilePanel.this.myFileNameField.setText("");
                }
                TDFExportFilePanel.this.triggerObservers(targetFile);
            }
        });
        return this.myFileBrowseBtn;
    }

    @Override
    public String getPanelDescription() {
        return "Select the file that the export should be written to.";
    }

    @Override
    public String getPanelIdentifier() {
        return "FilePanel";
    }

    @Override
    public void wizardCanceled() {
    }

    @Override
    public boolean asYesNoQuestion(String header, String text) {
        return DialogFactory.getQuestionDialog(GuiServiceCenter.getInstance().getMainWindow(), header, text);
    }
}

