/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.tdfexport.panels;

import com.ericsson.ere.gui.wizard.panels.AbstractWizardPanel;
import com.ericsson.ere.gui.wizard.selectabletable.SelectableTableModel;
import com.ericsson.ere.gui.wizard.selectabletree.SelectableNodeWrapper;
import com.ericsson.ere.selectiontree.tdfexport.TDFExportWizardModel;
import com.ericsson.ere.selectiontree.tdfexport.panels.TDFExportFieldsView;
import ericsson.ere.defs.RmaDefs;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class TDFExportFieldsPanel
extends AbstractWizardPanel
implements TDFExportFieldsView {
    private JTable myFieldsTable = null;
    private SelectableTableModel myExportTableModel;
    private JButton mySelectAllBtn;
    private JButton myClearSelectionsBtn;
    private TDFExportWizardModel myModel;

    public TDFExportFieldsPanel(TDFExportWizardModel model) {
        this.myModel = model;
        this.initialize();
    }

    private void initialize() {
        GridBagConstraints clearBtnConstraints = new GridBagConstraints();
        clearBtnConstraints.gridx = 1;
        clearBtnConstraints.anchor = 16;
        clearBtnConstraints.insets = new Insets(11, 4, 0, 0);
        clearBtnConstraints.gridy = 0;
        GridBagConstraints selectAllBtnConstraints = new GridBagConstraints();
        selectAllBtnConstraints.gridx = 0;
        selectAllBtnConstraints.insets = new Insets(17, 11, 0, 0);
        selectAllBtnConstraints.gridy = 0;
        GridBagConstraints scrollPaneConstraints = new GridBagConstraints();
        scrollPaneConstraints.fill = 1;
        scrollPaneConstraints.gridx = 0;
        scrollPaneConstraints.gridy = 2;
        scrollPaneConstraints.weightx = 1.0;
        scrollPaneConstraints.weighty = 1.0;
        scrollPaneConstraints.gridwidth = 2;
        scrollPaneConstraints.insets = new Insets(6, 11, 11, 11);
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(418, 353));
        this.add((Component)this.createContentScrollPane(), scrollPaneConstraints);
        this.add((Component)this.createSelectAllButton(), selectAllBtnConstraints);
        this.add((Component)this.createClearSelectionsButton(), clearBtnConstraints);
    }

    @Override
    public String getPanelIdentifier() {
        return "ExportFieldSelection";
    }

    @Override
    public String getPanelDescription() {
        return "Select the TDF(s) that you want to export.";
    }

    @Override
    public boolean hasSelections() {
        return this.myExportTableModel.hasSelectedItems();
    }

    @Override
    public void wizardCanceled() {
    }

    @Override
    public List<String> getSelectedTDFNames() {
        return this.myExportTableModel.getSelectedValues();
    }

    private JScrollPane createContentScrollPane() {
        JScrollPane contentPane = new JScrollPane();
        contentPane.setViewportView(this.createFieldsTable());
        return contentPane;
    }

    private JTable createFieldsTable() {
        this.myFieldsTable = new JTable();
        this.myFieldsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                TDFExportFieldsPanel.this.myFieldsTable.repaint();
                TDFExportFieldsPanel.this.triggerObservers();
            }
        });
        this.myFieldsTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent k) {
                if (k.getKeyCode() != 32) {
                    return;
                }
                int[] comp = TDFExportFieldsPanel.this.myFieldsTable.getSelectedRows();
                if (comp instanceof SelectableNodeWrapper) {
                    TDFExportFieldsPanel.this.myFieldsTable.repaint();
                    TDFExportFieldsPanel.this.triggerObservers();
                }
            }
        });
        return this.myFieldsTable;
    }

    private JButton createSelectAllButton() {
        this.mySelectAllBtn = new JButton();
        this.mySelectAllBtn.setToolTipText("Select all");
        this.mySelectAllBtn.setPreferredSize(new Dimension(20, 20));
        this.mySelectAllBtn.setMinimumSize(new Dimension(20, 20));
        this.mySelectAllBtn.setIcon(RmaDefs.getImageIcon("MultiSelect16.gif"));
        this.mySelectAllBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TDFExportFieldsPanel.this.myExportTableModel.markAllForExport(true);
                TDFExportFieldsPanel.this.myFieldsTable.repaint();
                TDFExportFieldsPanel.this.triggerObservers();
            }
        });
        return this.mySelectAllBtn;
    }

    private JButton createClearSelectionsButton() {
        this.myClearSelectionsBtn = new JButton();
        this.myClearSelectionsBtn.setToolTipText("Clear all");
        this.myClearSelectionsBtn.setPreferredSize(new Dimension(20, 20));
        this.myClearSelectionsBtn.setMinimumSize(new Dimension(20, 20));
        this.myClearSelectionsBtn.setIcon(RmaDefs.getImageIcon("MultiDeSelect16.gif"));
        this.myClearSelectionsBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TDFExportFieldsPanel.this.myExportTableModel.markAllForExport(false);
                TDFExportFieldsPanel.this.myFieldsTable.repaint();
                TDFExportFieldsPanel.this.triggerObservers();
            }
        });
        return this.myClearSelectionsBtn;
    }

    @Override
    public void prepareModel() {
        this.myExportTableModel = new SelectableTableModel(new Vector<Object>(this.myModel.getAllExportableTDFs()));
        this.myFieldsTable.setModel(this.myExportTableModel);
        this.myFieldsTable.getColumnModel().getColumn(0).setMaxWidth(50);
    }
}

