/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.statements;

import com.ericsson.ere.constraint.contract.Constrainable;
import com.ericsson.ere.selectiontree.statements.NodeStatementProfile;
import com.ericsson.ere.selectiontree.statements.NodeStatementProfileContract;
import ericsson.vareditor.variable.DoubleVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

@Constrainable(contractClass=NodeStatementProfileContract.class)
public class RatingNodeStatementProfile
extends NodeStatementProfile {
    public static final String LBL_PRICEFACTOR = "Price factor";

    public RatingNodeStatementProfile() {
    }

    public RatingNodeStatementProfile(boolean enableSTQ) {
        super(enableSTQ);
    }

    @Override
    public List<Variable> getVariables() {
        List<Variable> list = super.getVariables();
        DoubleVariable priceFactor = new DoubleVariable(LBL_PRICEFACTOR, 100.0, 0.0, Double.MAX_VALUE);
        list.add(priceFactor);
        return list;
    }

    @Override
    public List<Variable> getVariables(Node iterator) {
        NamedNodeMap attributes;
        Node d;
        String priceFactorStr = "100.0";
        List<Variable> list = super.getVariables(iterator);
        if (iterator.hasAttributes() && (d = (attributes = iterator.getAttributes()).getNamedItem("Discount")) != null) {
            priceFactorStr = d.getNodeValue();
        }
        list.add(new DoubleVariable(LBL_PRICEFACTOR, priceFactorStr, 0.0, Double.MAX_VALUE));
        return list;
    }

    @Override
    public void printAdditionalPreamble(PrintWriter out, int indentLevel, String indentMarker, List<Variable> variables) {
        super.printAdditionalPreamble(out, indentLevel, indentMarker, variables);
        String discount = VarListUtil.getValueStringForName(variables, LBL_PRICEFACTOR);
        if (!discount.equals("100.0")) {
            out.print(" Discount=\"" + discount + "\"");
        }
    }

    @Override
    protected String getExtendedDescription(List<Variable> variables) {
        return this.createDescriptionString(false, variables);
    }

    @Override
    protected String getExtendedAdditionalInfo(List<Variable> variables) {
        return this.createDescriptionString(true, variables);
    }

    private String createDescriptionString(boolean isAdditionalInfo, List<Variable> variables) {
        Double discountValue = VarListUtil.getDoubleValueForName(variables, LBL_PRICEFACTOR);
        String discount = "";
        String descriptiveString = "";
        if (discountValue != null) {
            discount = discountValue.toString();
        }
        if (isAdditionalInfo) {
            descriptiveString = descriptiveString + "Discount=" + discount.toLowerCase() + "%";
        } else if (!discount.equals("100.0")) {
            descriptiveString = descriptiveString + discount.toLowerCase() + "%";
        }
        return descriptiveString;
    }

    @Override
    public boolean handlesCachedPrint(Node xmlNode) {
        if (xmlNode.hasAttributes()) {
            String val;
            NamedNodeMap attr = xmlNode.getAttributes();
            Node disc = attr.getNamedItem("Discount");
            Node inv = attr.getNamedItem("CallNextWhenFalse");
            if (disc != null && (val = disc.getNodeValue()) != null && !"".equals(val.trim()) && Double.parseDouble(val) == 100.0) {
                attr.removeNamedItem("Discount");
            }
            if (inv != null && (val = inv.getNodeValue()) != null && "false".equals(val)) {
                attr.removeNamedItem("CallNextWhenFalse");
            }
        }
        return false;
    }

    @Override
    public Map<String, Object> getDisplayValues(Node iterator, Map<String, Object> prev) {
        HashMap<String, Object> displayValues = prev != null ? prev : new HashMap<String, Object>();
        Boolean inv = Boolean.FALSE;
        String discount = "100.0";
        if (iterator.hasAttributes()) {
            Node d;
            String cnwfString;
            NamedNodeMap attributes = iterator.getAttributes();
            Node n = attributes.getNamedItem("CallNextWhenFalse");
            if (n != null && "true".equalsIgnoreCase(cnwfString = n.getNodeValue())) {
                inv = Boolean.TRUE;
            }
            if ((d = attributes.getNamedItem("Discount")) != null) {
                discount = d.getNodeValue();
            }
        }
        displayValues.put("Inverted", inv);
        displayValues.put(LBL_PRICEFACTOR, discount);
        return displayValues;
    }
}

