/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.statements;

import com.ericsson.ere.annotations.jcip.Immutable;
import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.dataset.RatingDataSet;
import com.ericsson.ere.math.RatingDecimal;
import com.ericsson.ere.selectiontree.ParseContext;
import com.ericsson.ere.selectiontree.statements.ImmutableNodeStatement;
import ericsson.ere.interfaces.TariffStructureNode;
import org.w3c.dom.Node;

@Immutable
public class RatingNodeStatement
extends ImmutableNodeStatement {
    public static final String ATTR_DISCOUNT = "Discount";
    private static final RatingDecimal RD_ONE = new RatingDecimal(1L, 1L);
    private final RatingDecimal myDiscount;

    protected RatingNodeStatement(ParseContext context, RatingDecimal discount, TariffStructureNode[] children) {
        super(context, children);
        this.myDiscount = discount;
    }

    public static RatingNodeStatement create(ParseContext context, TariffStructureNode[] children) {
        Node node;
        Node config = context.getXMLNode();
        RatingDecimal discount = RD_ONE;
        if (config.hasAttributes() && (node = config.getAttributes().getNamedItem(ATTR_DISCOUNT)) != null) {
            discount = new RatingDecimal(node.getNodeValue()).divide(new RatingDecimal(100L, 1L));
        }
        return new RatingNodeStatement(context, discount, children);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.myDiscount == null ? 0 : this.myDiscount.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RatingNodeStatement other = (RatingNodeStatement)obj;
        return !(this.myDiscount == null ? other.myDiscount != null : !this.myDiscount.equals(other.myDiscount));
    }

    @Override
    public void execute(DataSet theData) {
        RatingDataSet ratingData = (RatingDataSet)theData;
        RatingDecimal backupDiscount = ratingData.getCurrentPriceFactor();
        ratingData.setCurrentPriceFactor(ratingData.getCurrentPriceFactor().multiply(this.myDiscount));
        super.execute(theData);
        ratingData.setCurrentPriceFactor(backupDiscount);
    }
}

