/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.statements;

import com.ericsson.ere.annotations.jcip.Immutable;
import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.dataset.SelectionTreeQualifier;
import com.ericsson.ere.dataset.task.TreeTask;
import com.ericsson.ere.selectiontree.ParseContext;
import com.ericsson.ere.selectiontree.interfaces.ExecutableNode;
import com.ericsson.ere.selectiontree.interfaces.SelectionTreeQualifierUser;
import com.ericsson.ere.selectiontree.statements.ImmutableStatement;
import com.ericsson.ere.selectiontree.util.FieldOrientedPluginUtil;
import com.ericsson.ere.trace.TracePoint;
import com.ericsson.ere.trace.TraceableV2;
import ericsson.ere.interfaces.TariffStructureNode;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

@Immutable
public class ImmutableNodeStatement
extends ImmutableStatement
implements TraceableV2,
SelectionTreeQualifierUser {
    public static final String ATTR_CALLNEXTWHENFALSE = "CallNextWhenFalse";
    private final boolean myIsInverted;
    public static final String TAG_COMMENT = "Comment";
    public static final String ATTR_STQ = "STQvalue";
    private final SelectionTreeQualifier mySTQualifier;

    protected ImmutableNodeStatement(ParseContext ctx, TariffStructureNode[] children) {
        super(ctx, children);
        NamedNodeMap attr = ctx.getXMLNode().getAttributes();
        String inverted = this.getAttributeValue(attr, ATTR_CALLNEXTWHENFALSE, "false");
        this.myIsInverted = Boolean.valueOf(inverted);
        String stq = this.getAttributeValue(attr, ATTR_STQ, null);
        this.mySTQualifier = stq == null ? null : SelectionTreeQualifier.valueOf(stq);
        FieldOrientedPluginUtil.checkMissingFields(this, ctx.getClassRepository());
    }

    protected final String getAttributeValue(NamedNodeMap attrs, String attribute, String def) {
        String ret = def;
        if (attrs != null) {
            Node attr = attrs.getNamedItem(attribute);
            ret = attr == null ? def : attr.getNodeValue();
        }
        return ret;
    }

    public static TariffStructureNode create(ParseContext ctx, TariffStructureNode[] children) {
        return new ImmutableNodeStatement(ctx, children);
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCodeImpl();
        result = 31 * result + (this.myIsInverted ? 1231 : 1237);
        result = 31 * result + (this.mySTQualifier == null ? 0 : this.mySTQualifier.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !super.equalsImpl(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImmutableNodeStatement other = (ImmutableNodeStatement)obj;
        if (this.myIsInverted != other.myIsInverted) {
            return false;
        }
        return !(this.mySTQualifier == null ? other.mySTQualifier != null : !this.mySTQualifier.equals(other.mySTQualifier));
    }

    protected boolean executeChild(ExecutableNode child, DataSet theData) {
        this.executeChildUsingExecutor(child, theData);
        TreeTask task = theData.getTreeTask();
        return !task.isDone() && !theData.shallExecutionStop();
    }

    @Override
    public void execute(DataSet theData) {
        this.executeImpl(theData);
    }

    protected void executeImpl(DataSet theData) {
        int j;
        TreeTask task;
        block11: {
            boolean isValid = false;
            task = theData.getTreeTask();
            task.saveState();
            if (this.myConditionArray != null) {
                for (int i = 0; i < this.myConditionArray.length; ++i) {
                    this.myConditionArray[i].enter(theData);
                }
            }
            while ((isValid = this.testConditions(theData)) && !this.myIsInverted || !isValid && this.myIsInverted) {
                task.resetModified();
                int nchld = this.myChildrenArray.length;
                boolean leftOK = true;
                for (int i = 0; i < nchld && this.executeChild(this.myChildrenArray[i], theData); ++i) {
                }
                if (this.myConditionArray != null) {
                    for (int j2 = this.myConditionArray.length - 1; j2 >= 0; --j2) {
                        leftOK = this.myConditionArray[j2].isReadyToLeave(theData) && leftOK;
                    }
                }
                boolean modified = task.isModified();
                if (!leftOK || modified && !task.isDone() && !theData.shallExecutionStop()) {
                    continue;
                }
                break block11;
            }
            if (this.myConditionArray != null) {
                for (j = this.myConditionArray.length - 1; j >= 0; --j) {
                    this.myConditionArray[j].isReadyToLeave(theData);
                }
            }
        }
        if (this.myConditionArray != null) {
            for (j = this.myConditionArray.length - 1; j >= 0; --j) {
                this.myConditionArray[j].leave(theData);
            }
        }
        task.restoreState();
    }

    protected boolean testConditions(DataSet theData) {
        boolean isValid = false;
        if (this.myConditionArray != null && this.myConditionArray.length > 0) {
            int ncond = this.myConditionArray.length;
            for (int i = 0; i < ncond && !(isValid = this.testConditionUsingExecutor(this.myConditionArray[i], theData)); ++i) {
            }
        } else {
            isValid = true;
        }
        return isValid;
    }

    @Override
    public String describeTrace(TracePoint tp) {
        if (this.myIsInverted) {
            return "== INVERTED ============================== [" + this.getName() + "]";
        }
        return "========================================== [" + this.getName() + "]";
    }

    @Override
    public void setTracePointInfo(TracePoint tp) {
    }

    public String toString() {
        String s = this.myName;
        if (this.myIsInverted) {
            s = s + " (inverted)";
        }
        return s;
    }

    @Override
    public void setPreTracePointInfo(TracePoint tp) {
    }

    @Override
    public boolean hasSelectionTreeQualifier() {
        return this.mySTQualifier != null;
    }

    @Override
    public SelectionTreeQualifier getSelectionTreeQualifier() {
        return this.mySTQualifier;
    }
}

