/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.statements;

import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.executor.TreeExecutorHelper;
import com.ericsson.ere.selectiontree.ParseContext;
import com.ericsson.ere.selectiontree.TreeExecutionException;
import com.ericsson.ere.selectiontree.interfaces.Conditionality;
import com.ericsson.ere.selectiontree.interfaces.ExecutableNode;
import com.ericsson.ere.selectiontree.interfaces.Performable;
import com.ericsson.ere.selectiontree.statements.LeafStatement;
import com.ericsson.ere.selectiontree.statements.Statement;
import com.ericsson.ere.trace.TraceNodeInterface;
import com.ericsson.ere.trace.TraceNodeStatement;
import com.ericsson.ere.trace.Traceable;
import ericsson.ere.interfaces.DAGNode;
import ericsson.ere.interfaces.DAGUtil;
import ericsson.ere.interfaces.TariffStructureNode;
import ericsson.ere.interfaces.XMLInitializable;
import ericsson.ere.xml.XMLUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractNodeStatement
extends Statement
implements Traceable {
    protected List<Conditionality> myConditions = null;
    protected Conditionality[] myConditionArray = null;
    protected List<ExecutableNode> myChildren = null;
    protected ExecutableNode[] myChildrenArray = null;

    public AbstractNodeStatement(String name) {
        super(name);
    }

    public AbstractNodeStatement() {
    }

    @Override
    public XMLInitializable init(Node iterator) throws Exception {
        super.init(iterator);
        int nCond = 0;
        int nNode = 0;
        NodeList children = iterator.getChildNodes();
        int len = children.getLength();
        for (int i = 0; i < len; ++i) {
            Node node = children.item(i);
            if (node.getNodeType() != 1) continue;
            if ("Node".equalsIgnoreCase(node.getNodeName())) {
                ++nNode;
            }
            if (!"Condition".equalsIgnoreCase(node.getNodeName())) continue;
            ++nCond;
        }
        this.myConditions = nCond > 0 ? new ArrayList<Conditionality>(nCond) : null;
        this.myChildren = nNode > 0 ? new ArrayList<ExecutableNode>(nNode) : null;
        return this;
    }

    @Override
    protected int hashCodeImpl() {
        int prime = 31;
        int result = super.hashCodeImpl();
        result = 31 * result + (this.myChildren == null ? 0 : this.myChildren.hashCode());
        result = 31 * result + (this.myConditions == null ? 0 : this.myConditions.hashCode());
        return result;
    }

    @Override
    protected boolean equalsImpl(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !super.equalsImpl(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractNodeStatement other = (AbstractNodeStatement)obj;
        if (this.myChildren == null ? other.myChildren != null : !this.myChildren.equals(other.myChildren)) {
            return false;
        }
        return !(this.myConditions == null ? other.myConditions != null : !this.myConditions.equals(other.myConditions));
    }

    @Override
    public DAGNode getChildAt(int index) throws IndexOutOfBoundsException {
        int nCond = 0;
        if (this.myConditions != null && index < (nCond = this.myConditions.size())) {
            return (DAGNode)((Object)this.myConditions.get(index));
        }
        DAGNode node = (DAGNode)((Object)this.myChildren.get(index - nCond));
        if (node instanceof LeafStatement) {
            node = node.getChildAt(0);
        }
        return node;
    }

    @Override
    public int getChildCount() {
        int nCond = this.myConditions == null ? 0 : this.myConditions.size();
        int nChild = this.myChildren == null ? 0 : this.myChildren.size();
        return nCond + nChild;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doInsert(int index, DAGNode node) throws IllegalArgumentException, IndexOutOfBoundsException {
        int ncond;
        if (DAGUtil.pathExists(node, this)) {
            throw new IllegalArgumentException("Cycle detected when trying to add node: " + node + " to " + this);
        }
        if (index > this.getChildCount()) throw new IndexOutOfBoundsException("Index out of bounds: " + index + " Number of children: " + this.getChildCount());
        int n = ncond = this.myConditions == null ? 0 : this.myConditions.size();
        if (node instanceof Conditionality) {
            if (this.myConditions == null) {
                this.myConditions = new ArrayList<Conditionality>();
            }
            if (index > this.myConditions.size()) {
                this.myConditions.add((Conditionality)((Object)node));
                return;
            } else {
                this.myConditions.add(index, (Conditionality)((Object)node));
            }
            return;
        } else if (node instanceof Performable) {
            ExecutableNode leaf;
            if (this.myChildren == null) {
                this.myChildren = new ArrayList<ExecutableNode>();
            }
            int i = index - ncond;
            if (node instanceof ExecutableNode) {
                leaf = (ExecutableNode)((Object)node);
            } else {
                LeafStatement l = new LeafStatement(this.getName());
                l.setModifier((Performable)((Object)node));
                leaf = l;
            }
            if (i > this.myChildren.size()) {
                this.myChildren.add(leaf);
                return;
            } else {
                this.myChildren.add(i, leaf);
            }
            return;
        } else {
            int i;
            if (!(node instanceof ExecutableNode)) throw new IllegalArgumentException("Unrecognized node class: " + node.getClass());
            if (this.myChildren == null) {
                this.myChildren = new ArrayList<ExecutableNode>();
            }
            if ((i = index - ncond) > this.myChildren.size()) {
                this.myChildren.add((ExecutableNode)((Object)node));
                return;
            } else {
                this.myChildren.add(i, (ExecutableNode)((Object)node));
            }
        }
    }

    @Override
    public void replace(DAGNode child, DAGNode replacement) {
        int i = -1;
        if (this.myConditions != null) {
            i = DAGUtil.indexOf(child, this.myConditions);
        }
        if (i >= 0) {
            this.myConditions.set(i, (Conditionality)((Object)replacement));
            i = DAGUtil.indexOf(child, Arrays.asList(this.myConditionArray));
            this.myConditionArray[i] = (Conditionality)((Object)replacement);
        } else {
            List<ExecutableNode> children = Arrays.asList(this.myChildrenArray);
            i = DAGUtil.indexOf(child, this.myChildren);
            if (i >= 0) {
                this.myChildren.set(i, (ExecutableNode)((Object)replacement));
                i = DAGUtil.indexOf(child, children);
                this.myChildrenArray[i] = (ExecutableNode)((Object)replacement);
            } else {
                for (ExecutableNode n : this.myChildren) {
                    LeafStatement stmt;
                    if (!(n instanceof LeafStatement) || (stmt = (LeafStatement)n).getModifier() != child) continue;
                    stmt.replace(child, replacement);
                }
            }
        }
    }

    @Override
    public void insertChildAt(int index, DAGNode node) throws IllegalArgumentException, IndexOutOfBoundsException {
        this.doInsert(index, node);
        node.setParent(this);
    }

    @Override
    public void insertLinkAt(int index, DAGNode node) throws IllegalArgumentException, IndexOutOfBoundsException {
        this.doInsert(index, node);
        node.addReferer(this);
    }

    @Override
    protected void removeChild(DAGNode node) throws IllegalArgumentException {
        throw new IllegalArgumentException("Node not removed, structure is read-only");
    }

    @Override
    protected void removeLink(DAGNode node) throws IllegalArgumentException {
        throw new IllegalArgumentException("Node not removed, structure is read-only");
    }

    @Override
    public void add(XMLInitializable node) throws IllegalArgumentException {
        this.addNodeAsChild(node);
    }

    public void add(TariffStructureNode node) throws IllegalArgumentException {
        this.addNodeAsChild(node);
    }

    private void addNodeAsChild(Object node) {
        if (node instanceof Conditionality) {
            this.addCondition((Conditionality)node);
        } else if (node instanceof Performable) {
            this.addModifier((Performable)node);
        } else if (node instanceof ExecutableNode) {
            this.addChildStatement((ExecutableNode)node);
        } else {
            throw new IllegalArgumentException("Unrecognized node class: " + node.getClass());
        }
    }

    public void addCondition(Conditionality aCondition) {
        if (this.myConditions == null) {
            this.myConditions = new ArrayList<Conditionality>();
        }
        this.insertChildAt(this.myConditions.size(), (DAGNode)((Object)aCondition));
    }

    public void addModifier(Performable aModifier) throws IllegalArgumentException {
        if (this.myChildren == null) {
            this.myChildren = new ArrayList<ExecutableNode>(1);
        }
        this.insertChildAt(this.getChildCount(), (DAGNode)((Object)aModifier));
    }

    public void addCondition(Conditionality[] conditions) throws Exception {
        if (conditions.length == 0) {
            throw new Exception("TariffAbstractNodeStatement.addCondition(). Array contains no elements");
        }
        if (this.myConditions == null) {
            this.myConditions = new ArrayList<Conditionality>(conditions.length);
        }
        for (int ii = 0; ii < conditions.length; ++ii) {
            if (conditions[ii] == null) continue;
            this.insertChildAt(this.myConditions.size(), (DAGNode)((Object)conditions[ii]));
        }
    }

    public void addChildStatement(ExecutableNode aChildStatement) throws IllegalArgumentException {
        if (this.myChildren == null) {
            this.myChildren = new ArrayList<ExecutableNode>();
        }
        this.insertChildAt(this.getChildCount(), (DAGNode)((Object)aChildStatement));
    }

    public void buildFinished() {
        int i;
        int len;
        int size = 0;
        if (this.myConditions != null) {
            len = this.myConditions.size();
            for (i = 0; i < len; ++i) {
                if (this.myConditions.get(i) == null) continue;
                ++size;
            }
            this.myConditionArray = new Conditionality[size];
            len = this.myConditions.size();
            for (i = 0; i < len; ++i) {
                if (this.myConditions.get(i) == null) continue;
                this.myConditionArray[i] = this.myConditions.get(i);
            }
        } else {
            this.myConditionArray = new Conditionality[size];
        }
        size = 0;
        if (this.myChildren != null) {
            len = this.myChildren.size();
            for (i = 0; i < len; ++i) {
                if (this.myChildren.get(i) == null) continue;
                ++size;
            }
            this.myChildrenArray = new ExecutableNode[size];
            len = this.myChildren.size();
            for (i = 0; i < len; ++i) {
                if (this.myChildren.get(i) == null) continue;
                this.myChildrenArray[i] = this.myChildren.get(i);
            }
        } else {
            this.myChildrenArray = new ExecutableNode[0];
        }
    }

    @Override
    public TariffStructureNode createTraceNode(int childIndex, TraceNodeInterface parent) {
        try {
            TariffStructureNode tni;
            int i;
            AbstractNodeStatement clone = (AbstractNodeStatement)this.clone();
            TraceNodeStatement tns = new TraceNodeStatement(clone);
            tns.setParent(parent);
            parent.addChild(tns);
            tns.setChildIndex(childIndex);
            clone.myChildren = null;
            clone.myChildrenArray = null;
            clone.myConditions = null;
            clone.myConditionArray = null;
            for (i = 0; this.myConditionArray != null && i < this.myConditionArray.length; ++i) {
                tni = this.myConditionArray[i].createTraceNode(i, tns);
                clone.add(tni);
            }
            for (i = 0; this.myChildrenArray != null && i < this.myChildrenArray.length; ++i) {
                tni = this.myChildrenArray[i].createTraceNode(i, tns);
                clone.add(tni);
            }
            clone.buildFinished();
            return tns;
        }
        catch (CloneNotSupportedException e) {
            throw new TreeExecutionException(e);
        }
    }

    private final void performChildUsingExecutor(Performable child, DataSet dataSet) {
        TreeExecutorHelper.performPerformable(child, dataSet);
        dataSet.modifierExecuted();
    }

    protected final void executeChildUsingExecutor(ExecutableNode child, DataSet dataSet) {
        if (child instanceof LeafStatement) {
            this.performChildUsingExecutor(((LeafStatement)child).getModifier(), dataSet);
        } else if (child instanceof Performable) {
            this.performChildUsingExecutor((Performable)((Object)child), dataSet);
        } else {
            TreeExecutorHelper.executeExecutableNode(child, dataSet);
        }
    }

    protected final boolean testConditionUsingExecutor(Conditionality condition, DataSet dataSet) {
        return TreeExecutorHelper.testCondition(condition, dataSet);
    }

    @Deprecated
    protected void replaceWithImmutableStatementSuper(ParseContext ctx, TariffStructureNode[] children) {
        if (ctx == null) {
            this.myName = null;
            this.myNodeId = null;
        } else {
            Node node;
            Node iterator = ctx.getXMLNode();
            TariffStructureNode[] name = XMLUtil.getFirstTextContent(iterator);
            this.myName = name;
            String id = null;
            NamedNodeMap attr = null;
            if (iterator.hasAttributes()) {
                attr = iterator.getAttributes();
            }
            if (attr != null && (node = attr.getNamedItem("id")) != null) {
                id = node.getNodeValue().trim().replace('/', '\\');
            }
            this.myNodeId = id;
        }
        ArrayList<Conditionality> conds = new ArrayList<Conditionality>();
        for (TariffStructureNode n : children) {
            if (!(n instanceof Conditionality)) continue;
            conds.add((Conditionality)((Object)n));
        }
        if (conds.size() > 0) {
            this.myConditions = conds;
        }
        ArrayList<ExecutableNode> nodes = new ArrayList<ExecutableNode>();
        for (TariffStructureNode n : children) {
            if (n instanceof ExecutableNode) {
                nodes.add((ExecutableNode)((Object)n));
                continue;
            }
            if (!(n instanceof Performable)) continue;
            nodes.add(new LeafStatement(this.myName, (Performable)((Object)n)));
        }
        if (nodes.size() > 0) {
            this.myChildren = nodes;
        }
        this.buildFinished();
    }
}

