/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.search.predicate;

import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.dataset.DataSetFactory;
import com.ericsson.ere.dataset.Key;
import com.ericsson.ere.dataset.task.DefaultTask;
import com.ericsson.ere.dataset.task.TreeTask;
import com.ericsson.ere.gui.simulator.AbstractGroupedSimulationDataPanel;
import com.ericsson.ere.gui.util.SystemPropertyUtil;
import com.ericsson.ere.selectiontree.search.ConditionEvaluator;
import com.ericsson.ere.selectiontree.search.dataset.AccessTrackingDataSet;
import com.ericsson.ere.selectiontree.search.dataset.AccessTrackingDataSetImpl;
import com.ericsson.ere.selectiontree.search.dataset.DataSetHelper;
import com.ericsson.ere.selectiontree.search.dataset.DataSetParameters;
import com.ericsson.ere.selectiontree.search.dataset.DefaultParameterIdentifier;
import com.ericsson.ere.selectiontree.search.predicate.BranchPredicate;
import com.ericsson.ere.selectiontree.search.predicate.DataSetBasedBranchPredicate;
import ericsson.ere.datatype.Time;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.ClassRepositoryUtil;
import ericsson.ere.defs.EreClassLoader;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.management.ContextAwareServiceContainer;
import ericsson.ere.management.Service;
import ericsson.vareditor.variable.ArrayModel;
import ericsson.vareditor.variable.GroupedArrayVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import ericsson.vareditor.variable.array.GroupedObjectArrayVariable;
import ericsson.vareditor.variable.array.ObjectArrayModel;
import ericsson.vareditor.variable.array.ObjectMapModel;
import java.util.Calendar;
import java.util.List;
import java.util.Map;

public class SimulationBasedDataSetPredicateBuilder {
    public static final String PI_FACTORY_PROPERTY_NAME_PREFIX = "BranchSearch.DataSetParameterIdentifierFactory.";
    private ContextAwareServiceContainer myServiceContainer;
    private AbstractGroupedSimulationDataPanel myPanel;

    public SimulationBasedDataSetPredicateBuilder(ContextAwareServiceContainer serviceContainer, AbstractGroupedSimulationDataPanel panel) {
        this.myServiceContainer = serviceContainer;
        this.myPanel = panel;
    }

    public BranchPredicate createPredicate(ConditionEvaluator eval) {
        List<Variable> vars = this.myPanel.getInputParametersForSimulation();
        vars.addAll(this.myPanel.getCommonParameters());
        DataSet ds = this.createOriginalDataSet();
        this.registerParameters(ds, vars);
        Variable startTimeVar = VarListUtil.getVariableForName(vars, "Start time");
        if (startTimeVar != null && startTimeVar.isSelected()) {
            DataSetParameters.parametersOf(ds).setHasExplicitStartTime();
        } else {
            this.setArbitraryStartTime(ds);
        }
        TreeTask task = ds.getTreeTask();
        if (task != null && !(task instanceof DefaultTask)) {
            DataSetParameters.parametersOf(ds).register(AccessTrackingDataSet.PARAM_TREE_TASK);
        }
        AccessTrackingDataSetImpl.ParameterIdentifier pi = this.createParameterIdentifierForDataSet(ds);
        DataSetBasedBranchPredicate b1 = DataSetBasedBranchPredicate.create(eval, ds, pi);
        return b1;
    }

    protected AccessTrackingDataSetImpl.ParameterIdentifier createParameterIdentifierForDataSet(DataSet ds) {
        Service service;
        DataSetParameterIdentifierFactory factory;
        String key = PI_FACTORY_PROPERTY_NAME_PREFIX + ds.getClass().getSimpleName();
        String factoryClassName = SystemPropertyUtil.getPropertyWithOptionalJnlpPrefix(key);
        AccessTrackingDataSetImpl.ParameterIdentifier pi = null;
        DataSetParameterIdentifierFactory dataSetParameterIdentifierFactory = factory = factoryClassName != null ? this.createFactory(factoryClassName) : null;
        if (factory != null) {
            pi = factory.createParameterIdentifier(ds);
        }
        if ((service = ds.getService()) != null) {
            DataSetFactory dsFactory = service.getClassRepository(ClassRepositoryUtil.getCurrentFieldContext(ds)).getDataSetFactory();
            if (pi == null && dsFactory instanceof DataSetParameterIdentifierFactory) {
                pi = ((DataSetParameterIdentifierFactory)((Object)dsFactory)).createParameterIdentifier(ds);
            }
        }
        if (pi == null) {
            pi = new DefaultParameterIdentifier();
        }
        return pi;
    }

    private DataSetParameterIdentifierFactory createFactory(String factoryClassName) {
        DataSetParameterIdentifierFactory fact = null;
        try {
            Class<?> c = EreClassLoader.getClass(factoryClassName);
            if (DataSetParameterIdentifierFactory.class.isAssignableFrom(c)) {
                fact = (DataSetParameterIdentifierFactory)c.newInstance();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fact;
    }

    protected DataSet createOriginalDataSet() {
        DataSet ds = this.myServiceContainer.getService().getDataSet();
        this.myPanel.fillDataSet(ds, this.myServiceContainer.getClassRepository());
        return ds;
    }

    private void setArbitraryStartTime(DataSet ds) {
        Calendar cal = new Time("99921004T000000555").getCalendar();
        DataSetHelper.setStartTime(ds, cal);
    }

    private void registerParameters(DataSet ds, List<Variable> vars) {
        ClassRepository rep = ds.getService().getClassRepository(ClassRepositoryUtil.getCurrentFieldContext(ds));
        String contextFieldID = rep.getContextFieldIdentifier();
        for (Variable var : vars) {
            Key[] keys;
            FieldDefinition fd;
            if (contextFieldID != null && var.getLabel().equals(contextFieldID) || !var.isSelected()) continue;
            ObjectArrayModel groupModel = null;
            String name = var.getLabel();
            if (var instanceof GroupedObjectArrayVariable) {
                groupModel = (ObjectArrayModel)((GroupedObjectArrayVariable)var).getObjectArrayModel();
            }
            if ((fd = rep.getFieldDefinitionByName(name = name.replaceAll(" \\(IN\\)|\\(OUT\\)$", ""))) != null) {
                if (fd.isComplexType()) {
                    assert (var instanceof GroupedArrayVariable) : "Expected GroupedArrayVariable for map/array field.";
                    ArrayModel model = ((GroupedArrayVariable)var).getModel();
                    keys = this.extractArrayKeys(model, fd.isArray());
                    this.registerParameter(ds, keys, this.getIdentities(fd));
                    continue;
                }
                this.registerParameter(ds, this.getIdentities(fd));
                continue;
            }
            if (groupModel instanceof ObjectMapModel) {
                int cols = groupModel.getColumnCount();
                keys = this.extractMapGroupKeys((ObjectMapModel)groupModel, 0);
                for (int column = 0; column < cols; ++column) {
                    fd = rep.getFieldDefinitionByName(groupModel.getColumnName(column));
                    if (fd == null || !fd.isMap()) continue;
                    this.registerParameter(ds, keys, this.getIdentities(fd));
                }
                continue;
            }
            if (groupModel == null) continue;
            int cols = groupModel.getColumnCount();
            keys = this.extractArrayGroupKeys(groupModel);
            for (int i = 0; i < cols; ++i) {
                fd = rep.getFieldDefinitionByName(groupModel.getColumnName(i));
                if (fd == null || !fd.isArray()) continue;
                this.registerParameter(ds, keys, this.getIdentities(fd));
            }
        }
    }

    private Key[] extractMapGroupKeys(ObjectMapModel groupModel, int column) {
        Map<Object, Object> map = groupModel.getColumnMap(column);
        Key[] keys = new Key[map.size()];
        Object[] keyObjectArray = map.keySet().toArray();
        for (int j = 0; j < keys.length; ++j) {
            keys[j] = Key.asKey(keyObjectArray[j]);
        }
        return keys;
    }

    private Key[] extractArrayGroupKeys(ObjectArrayModel model) {
        int rc = model.getRowCount();
        Key[] keys = new Key[rc];
        for (int r = 0; r < rc; ++r) {
            keys[r] = Key.asIndex(r);
        }
        return keys;
    }

    private Key[] extractArrayKeys(ArrayModel model, boolean isArray) {
        assert (model.getNumberOfDimensions() == 2) : "Expected two dimensions in the ArrayModel.";
        int rc = model.getRowCount();
        Key[] keys = new Key[rc];
        for (int r = 0; r < rc; ++r) {
            Key k;
            Object keyOrIndex = model.getValueAt(r, 0);
            keys[r] = k = isArray ? Key.asIndex((Integer)keyOrIndex) : Key.asKey(keyOrIndex);
        }
        return keys;
    }

    private void registerParameter(DataSet ds, Object[] identities) {
        DataSetParameters.parametersOf(ds).register(identities);
    }

    private void registerParameter(DataSet ds, Key[] keys, Object[] identities) {
        DataSetParameters.parametersOf(ds).registerComplex(keys, identities);
    }

    private Object[] getIdentities(FieldDefinition fd) {
        if (fd.usesTagNumber()) {
            return new Object[]{fd.getFieldName(), fd.getTagNumber()};
        }
        return new Object[]{fd.getFieldName()};
    }

    public static interface DataSetParameterIdentifierFactory {
        public AccessTrackingDataSetImpl.ParameterIdentifier createParameterIdentifier(DataSet var1);
    }
}

