/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.search.filter;

import com.ericsson.ere.selectiontree.search.filter.AbstractBranchFilter;
import com.ericsson.ere.selectiontree.search.predicate.BranchPredicate;
import com.ericsson.ere.selectiontree.search.predicate.ElementBranchPredicate;
import ericsson.ere.gui.ratingrules.nodes.NodePredicate;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;

public class ElementBasedBranchFilter
extends AbstractBranchFilter {
    private NodePredicate myPredicate;

    public ElementBasedBranchFilter(String name) {
        super(name);
    }

    private ElementBasedBranchFilter(String name, NodePredicate predicate) {
        super(name);
        this.myPredicate = predicate;
    }

    @Override
    public BranchPredicate createPredicate() {
        return new ElementBranchPredicate(this.myPredicate);
    }

    public void setPredicate(NodePredicate predicate) {
        this.myPredicate = predicate;
        this.fireDataChanged();
    }

    public NodePredicate getPredicate() {
        return this.myPredicate;
    }

    @Override
    public void save(OutputStream out) throws IOException {
        DataOutputStream dos = ElementBasedBranchFilter.dataOutputStream(out);
        dos.writeUTF(this.getName());
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(this.myPredicate);
        byte[] data = bos.toByteArray();
        dos.writeInt(data.length);
        dos.write(data);
    }

    public static ElementBasedBranchFilter load(InputStream in) throws IOException {
        NodePredicate predicate;
        DataInputStream dis = ElementBasedBranchFilter.dataInputStream(in);
        String name = dis.readUTF();
        int size = dis.readInt();
        byte[] data = new byte[size];
        dis.readFully(data);
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(data));
        try {
            predicate = (NodePredicate)ois.readObject();
        }
        catch (ClassNotFoundException ex) {
            throw new IOException(ex);
        }
        return new ElementBasedBranchFilter(name, predicate);
    }
}

