/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.search.dataset;

import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.dataset.Key;
import com.ericsson.ere.dataset.task.DefaultTask;
import com.ericsson.ere.selectiontree.search.dataset.AccessTrackingDataSet;
import com.ericsson.ere.selectiontree.search.dataset.AccessTrackingDataSetImpl;
import ericsson.ere.util.StringUtil;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class DefaultParameterIdentifier
implements AccessTrackingDataSetImpl.ParameterIdentifier {
    protected static final Map<Integer, IndexInfo> METHOD_MAP = new HashMap<Integer, IndexInfo>();

    protected static void prepareMethodTracking(String methodName, int argumentCount, IndexInfo indexInfo) {
        METHOD_MAP.put(DefaultParameterIdentifier.createHash(methodName, argumentCount), indexInfo);
    }

    private static int createHash(String methodName, int argsLength) {
        int prime = 31;
        int result = methodName.hashCode();
        result = 31 * result + argsLength;
        return result;
    }

    @Override
    public AccessTrackingDataSetImpl.ParameterIdentifier.ParameterInfo identifyParameter(Method method, Object[] args, Object result, DataSet dataSet) {
        int argsLength;
        Object paramID = null;
        Key key = null;
        String methodName = method.getName();
        int hash = DefaultParameterIdentifier.createHash(methodName, argsLength = AccessTrackingDataSetImpl.argsLength(args));
        IndexInfo ii = METHOD_MAP.get(hash);
        if (ii != null) {
            if (ii.fixedIdentity != null) {
                paramID = ii.fixedIdentity;
            } else {
                paramID = args[ii.identityIndex];
                if (ii.keyIndex >= 0) {
                    key = (Key)args[ii.keyIndex];
                }
            }
        } else if (methodName.startsWith("getDataAs") && argsLength == 1) {
            paramID = args[0];
        } else if (this.isGetTreeTask(method) && this.isRealTreeTask(result)) {
            paramID = AccessTrackingDataSet.PARAM_TREE_TASK;
        } else if (argsLength == 0 && this.isGetterMethod(methodName)) {
            paramID = this.getParameterNameFromMethodName(methodName);
        }
        return new AccessTrackingDataSetImpl.ParameterIdentifier.ParameterInfo(paramID, key);
    }

    private boolean isGetterMethod(String methodName) {
        return methodName.length() >= 4 && methodName.startsWith("get") && Character.isUpperCase(methodName.charAt(3));
    }

    private String getParameterNameFromMethodName(String methodName) {
        String name = methodName.substring(3);
        return StringUtil.getDisplayStringFromCamelCaseString(name);
    }

    private boolean isRealTreeTask(Object task) {
        return task != null && !(task instanceof DefaultTask);
    }

    private boolean isGetTreeTask(Method m) {
        return m.getName().equals("getTreeTask") && m.getParameterTypes().length == 0;
    }

    static {
        DefaultParameterIdentifier.prepareMethodTracking("getDataAsTypedObjectForKey", 3, new IndexInfo(0, 1, null));
        DefaultParameterIdentifier.prepareMethodTracking("hasDataForKey", 2, new IndexInfo(0, 1, null));
        DefaultParameterIdentifier.prepareMethodTracking("hasData", 1, new IndexInfo(0, -1, null));
        DefaultParameterIdentifier.prepareMethodTracking("getStartTime", 0, new IndexInfo(-1, -1, AccessTrackingDataSet.PARAM_TIME));
        DefaultParameterIdentifier.prepareMethodTracking("getCurrentTime", 0, new IndexInfo(-1, -1, AccessTrackingDataSet.PARAM_TIME));
        DefaultParameterIdentifier.prepareMethodTracking("getMoneyLeft", 0, new IndexInfo(-1, -1, AccessTrackingDataSet.PARAM_MONEY_LEFT));
    }

    protected static class IndexInfo {
        protected final int identityIndex;
        protected final int keyIndex;
        protected final Object fixedIdentity;

        protected IndexInfo(int idIdx, int keyIdx, Object fixedID) {
            assert (idIdx >= 0 || fixedID != null);
            this.identityIndex = idIdx;
            this.keyIndex = keyIdx;
            this.fixedIdentity = fixedID;
        }
    }
}

