/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.search;

import com.ericsson.ere.selectiontree.search.BranchSearchModelIO;
import com.ericsson.ere.selectiontree.search.filter.BranchFilter;
import com.ericsson.ere.selectiontree.search.filter.BranchFilterNotFoundException;
import com.ericsson.ere.selectiontree.search.predicate.BooleanBranchPredicate;
import com.ericsson.ere.selectiontree.search.predicate.BranchPredicate;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class BranchSearchModel
implements ListModel {
    private SortedMap<String, BranchFilter> myFilters;
    private List<BranchFilter> myFilterList;
    private Handler myHandler = new Handler();
    private List<ListDataListener> myListDataListeners;
    private boolean mySuppressAddEvents = false;
    private boolean mySuppressRemoveEvents = false;

    public BranchSearchModel() {
        this.myFilters = new TreeMap<String, BranchFilter>(new IgnoringCaseStringComparator());
        this.myListDataListeners = new ArrayList<ListDataListener>();
    }

    public static BranchSearchModel loadFromFile(File f) throws IOException {
        try {
            return BranchSearchModelIO.loadFromFile(f);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new IOException("Failed to interpret file data: " + ex.getMessage());
        }
    }

    protected List<BranchFilter> filterList() {
        if (this.myFilterList == null) {
            this.myFilterList = new ArrayList<BranchFilter>(this.myFilters.values());
        }
        return this.myFilterList;
    }

    public void saveToFile(File f) throws IOException {
        BranchSearchModelIO.saveToFile(f, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importFiltersFromFile(File f, List<BranchFilter> conflictsOut) throws IOException {
        BranchSearchModel temp = BranchSearchModel.loadFromFile(f);
        try {
            this.mySuppressAddEvents = true;
            boolean didAdd = false;
            for (BranchFilter bf : temp.getFilters()) {
                boolean added = this.addFilter(bf);
                didAdd |= added;
                if (added || conflictsOut == null) continue;
                conflictsOut.add(bf);
            }
            if (didAdd) {
                this.fireListChangedEvent(0, this.getSize() - 1);
            }
        }
        finally {
            this.mySuppressAddEvents = false;
        }
    }

    public void exportFiltersToFile(File f, List<String> filters) throws IOException {
        BranchSearchSelectionModel submodel = this.createSelectionModel();
        for (String filter : filters) {
            submodel.selectFilter(filter);
        }
        submodel.saveToFile(f);
    }

    public BranchSearchSelectionModel createSelectionModel() {
        return new BranchSearchSelectionModel(this);
    }

    public boolean addFilter(BranchFilter f) {
        String name = f.getName();
        if (this.myFilters.containsKey(name)) {
            return false;
        }
        this.myFilters.put(name, f);
        f.addPropertyListener(this.myHandler);
        this.invalidateFilterList();
        if (!this.mySuppressAddEvents) {
            this.fireListAddEvent(this.filterList().indexOf(f));
        }
        return true;
    }

    public boolean removeFilter(String name) {
        BranchFilter filter = (BranchFilter)this.myFilters.get(name);
        if (filter != null) {
            filter.removePropertyListener(this.myHandler);
            int idx = this.filterList().indexOf(filter);
            this.myFilters.remove(name);
            this.invalidateFilterList();
            if (!this.mySuppressRemoveEvents) {
                this.fireListRemoveEvent(idx, name);
            }
        }
        return filter != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFilters(String ... names) {
        if (names.length == 1) {
            this.removeFilter(names[0]);
            return;
        }
        try {
            this.mySuppressRemoveEvents = true;
            boolean didRemove = false;
            for (String name : names) {
                didRemove |= this.removeFilter(name);
            }
            if (didRemove) {
                this.fireListChangedEvent(0, this.getSize() - 1);
            }
        }
        finally {
            this.mySuppressRemoveEvents = false;
        }
    }

    public Collection<BranchFilter> getFilters() {
        if (this.myFilters.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.myFilters.values());
    }

    public BranchFilter getFilter(String name) throws BranchFilterNotFoundException {
        if (!this.hasFilter(name)) {
            throw new BranchFilterNotFoundException(name);
        }
        return (BranchFilter)this.myFilters.get(name);
    }

    public boolean hasFilter(String name) {
        return this.myFilters.containsKey(name);
    }

    public Object getElementAt(int index) {
        return this.filterList().get(index);
    }

    @Override
    public int getSize() {
        return this.myFilters.size();
    }

    @Override
    public void removeListDataListener(ListDataListener l) {
        this.myListDataListeners.remove(l);
    }

    @Override
    public void addListDataListener(ListDataListener l) {
        if (this.myListDataListeners.contains(l)) {
            return;
        }
        this.myListDataListeners.add(l);
    }

    protected void fireListAddEvent(int index) {
        ListDataEvent event = new ListDataEvent(this, 1, index, index);
        for (ListDataListener listener : this.myListDataListeners) {
            listener.intervalAdded(event);
        }
    }

    protected void fireListRemoveEvent(int index, String name) {
        FilterRemoveListDataEvent event = new FilterRemoveListDataEvent((Object)this, 2, index, name);
        for (ListDataListener listener : this.myListDataListeners) {
            listener.intervalRemoved(event);
        }
    }

    protected void fireListChangedEvent(int i0, int i1) {
        ListDataEvent event = new ListDataEvent(this, 0, i0, i1);
        for (ListDataListener listener : this.myListDataListeners) {
            listener.contentsChanged(event);
        }
    }

    void invalidateFilterList() {
        this.myFilterList = null;
    }

    public static class FilterRemoveListDataEvent
    extends ListDataEvent {
        private String myFilterName;

        FilterRemoveListDataEvent(Object source, int type, int index, String filterName) {
            super(source, type, index, index);
            this.myFilterName = filterName;
        }

        public String getFilterName() {
            return this.myFilterName;
        }
    }

    private static class MutuallyExclusiveHandler
    implements ListDataListener {
        private Set<BranchSearchSelectionModel> myModels;

        static void tie(BranchSearchSelectionModel ... models) {
            new MutuallyExclusiveHandler(models);
        }

        private MutuallyExclusiveHandler(BranchSearchSelectionModel ... models) {
            if (models.length < 2) {
                throw new IllegalArgumentException("Not enough models.");
            }
            this.myModels = new HashSet<BranchSearchSelectionModel>();
            this.myModels.add(models[0]);
            models[0].addListDataListener(this);
            BranchSearchModel parent = models[0].myParent;
            for (int i = 1; i < models.length; ++i) {
                if (models[i].myParent != parent) {
                    throw new IllegalArgumentException("Can only tie selection models based on the same branch search model.");
                }
                if (!this.myModels.add(models[i])) {
                    throw new IllegalArgumentException("Non-unique model detected.");
                }
                models[i].addListDataListener(this);
            }
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            assert (this.myModels.contains(e.getSource()));
            BranchFilter filter = (BranchFilter)((BranchSearchModel)e.getSource()).getElementAt(e.getIndex0());
            String name = filter.getName();
            for (BranchSearchSelectionModel model : this.myModels) {
                if (model == e.getSource()) continue;
                model.deselectFilter(name);
            }
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
        }
    }

    public static class BranchSearchSelectionModel
    extends BranchSearchModel {
        private BranchSearchModel myParent;
        private ParentChangeHandler myParentChangeHandler = new ParentChangeHandler();

        BranchSearchSelectionModel(BranchSearchModel parent) {
            this.myParent = parent;
            this.myParent.addListDataListener(this.myParentChangeHandler);
        }

        @Override
        public boolean addFilter(BranchFilter f) {
            throw new UnsupportedOperationException("Use selectFilter instead.");
        }

        @Override
        public boolean removeFilter(String name) {
            throw new UnsupportedOperationException("Use deselectFilter instead.");
        }

        public boolean selectFilter(String name) {
            try {
                BranchFilter bf = this.myParent.getFilter(name);
                return super.addFilter(bf);
            }
            catch (BranchFilterNotFoundException e) {
                return false;
            }
        }

        public boolean deselectFilter(String name) {
            return super.removeFilter(name);
        }

        public void mutuallyExclusiveWith(BranchSearchSelectionModel other) {
            MutuallyExclusiveHandler.tie(this, other);
        }

        public static void makeMutuallyExclusive(BranchSearchSelectionModel ... models) {
            MutuallyExclusiveHandler.tie(models);
        }

        public BranchPredicate createIntersectionPredicate() {
            return this.createPredicate(true);
        }

        public BranchPredicate createUnionPredicate() {
            return this.createPredicate(false);
        }

        private BranchPredicate createPredicate(boolean intersection) {
            Collection<BranchFilter> filters = this.getFilters();
            int count = filters.size();
            if (count == 0) {
                throw new IllegalStateException("No filters have been selected into the selection model.");
            }
            if (count == 1) {
                return filters.iterator().next().createPredicate();
            }
            BranchPredicate[] preds = new BranchPredicate[count];
            int i = 0;
            Iterator<BranchFilter> iterator = filters.iterator();
            while (iterator.hasNext()) {
                preds[i++] = iterator.next().createPredicate();
            }
            return intersection ? BooleanBranchPredicate.and(preds) : BooleanBranchPredicate.or(preds);
        }

        private class ParentChangeHandler
        implements ListDataListener {
            private ParentChangeHandler() {
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
            }

            @Override
            public void intervalAdded(ListDataEvent e) {
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                if (e.getSource() == BranchSearchSelectionModel.this.myParent) {
                    String name = ((FilterRemoveListDataEvent)e).getFilterName();
                    BranchSearchSelectionModel.this.deselectFilter(name);
                }
            }
        }
    }

    private static class IgnoringCaseStringComparator
    implements Comparator<String> {
        private IgnoringCaseStringComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            return o1.compareToIgnoreCase(o2);
        }
    }

    private class Handler
    implements VetoableChangeListener {
        private Handler() {
        }

        @Override
        public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
            if (evt.getPropertyName().equals("name")) {
                boolean isNameChanging;
                String newName;
                String oldName = (String)evt.getOldValue();
                if (oldName.equals(newName = (String)evt.getNewValue())) {
                    return;
                }
                BranchFilter filter = (BranchFilter)evt.getSource();
                assert (BranchSearchModel.this.myFilters.containsValue(filter)) : "Not my filter!";
                boolean bl = isNameChanging = BranchSearchModel.this.myFilters.get(oldName) == filter;
                if (isNameChanging) {
                    if (BranchSearchModel.this.myFilters.containsKey(newName) && BranchSearchModel.this.myFilters.get(newName) != filter) {
                        throw new PropertyVetoException("Another filter named '" + newName + "' already exists.", evt);
                    }
                    int oldIdx = BranchSearchModel.this.filterList().indexOf(filter);
                    BranchSearchModel.this.myFilters.remove(oldName);
                    BranchSearchModel.this.myFilters.put(newName, filter);
                    BranchSearchModel.this.invalidateFilterList();
                    int newIdx = BranchSearchModel.this.filterList().indexOf(filter);
                    BranchSearchModel.this.fireListChangedEvent(oldIdx, newIdx);
                }
            } else {
                BranchFilter filter = (BranchFilter)evt.getSource();
                int index = BranchSearchModel.this.filterList().indexOf(filter);
                if (index >= 0) {
                    BranchSearchModel.this.fireListChangedEvent(index, index);
                }
            }
        }
    }
}

