/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.modifiers.operation;

import com.ericsson.ere.datatype.ERETime;
import com.ericsson.ere.datatype.ERETimeFactory;

public enum TimeOperation {
    SET{

        @Override
        public ERETime performTime(ERETime operand1, Long operand2, int selectedUnit) {
            return ERETimeFactory.createFromMillisecondsSinceEpoch(operand2);
        }

        @Override
        public ERETime performTime(ERETime operand1, ERETime operand2, int selectedUnit) {
            return operand2;
        }
    }
    ,
    ADD{

        @Override
        public ERETime performTime(ERETime operand1, Long operand2, int selectedUnit) {
            return TimeOperation.modifyERETime(operand1, operand2, selectedUnit);
        }

        @Override
        public ERETime performTime(ERETime operand1, ERETime operand2, int selectedUnit) {
            return TimeOperation.modifyERETime(operand1, operand2.getMillisecondsSinceEpoch(), selectedUnit);
        }
    }
    ,
    SUBTRACT{

        @Override
        public ERETime performTime(ERETime operand1, Long operand2, int selectedUnit) {
            return TimeOperation.modifyERETime(operand1, operand2 * -1L, selectedUnit);
        }

        @Override
        public ERETime performTime(ERETime operand1, ERETime operand2, int selectedUnit) {
            return TimeOperation.modifyERETime(operand1, -operand2.getMillisecondsSinceEpoch(), selectedUnit);
        }
    };

    static int DEFAULT_UNIT_IDENTIFIER;
    private static String UNIT_YEAR_STRING;
    private static String OLD_UNIT_YEAR_STRING;
    private static String UNIT_MONTH_STRING;
    private static String OLD_UNIT_MONTH_STRING;
    private static String UNIT_DAY_STRING;
    private static String OLD_UNIT_DAY_STRING;
    private static String UNIT_HOUR_STRING;
    private static String OLD_UNIT_HOUR_STRING;
    private static String UNIT_MINUTE_STRING;
    private static String OLD_UNIT_MINUTE_STRING;
    private static String UNIT_SECOND_STRING;
    private static String OLD_UNIT_SECOND_STRING;

    public abstract ERETime performTime(ERETime var1, Long var2, int var3);

    public ERETime performTime(ERETime operand1, ERETime operand2, int selectedUnit) {
        throw new UnsupportedOperationException("Operation " + this.name().toLowerCase() + " is not allowed for ERETimes.");
    }

    private static ERETime modifyERETime(ERETime operand1, Long operand2, int selectedUnit) {
        int val = operand2.intValue();
        ERETime ret = operand1;
        switch (selectedUnit) {
            case 1: {
                ret = (ERETime)operand1.plusYears(val);
                break;
            }
            case 2: {
                ret = (ERETime)operand1.plusMonths(val);
                break;
            }
            case 5: {
                ret = (ERETime)operand1.plusDays(val);
                break;
            }
            case 10: {
                ret = operand1.plusHours(val);
                break;
            }
            case 12: {
                ret = operand1.plusMinutes(val);
                break;
            }
            case 13: {
                ret = operand1.plusSeconds(val);
                break;
            }
            case 14: {
                ret = operand1.plusMilliseconds(val);
            }
        }
        return ret;
    }

    public static String[] getOperationNames() {
        return new String[]{(Object)((Object)SET) + "", (Object)((Object)ADD) + "", (Object)((Object)SUBTRACT) + ""};
    }

    public static TimeOperation getOperation(String operation) {
        if (operation == null || operation.equals((Object)((Object)SET) + "")) {
            return SET;
        }
        if (operation.equals((Object)((Object)ADD) + "")) {
            return ADD;
        }
        if (operation.equals((Object)((Object)SUBTRACT) + "")) {
            return SUBTRACT;
        }
        throw new IllegalArgumentException("Operation " + operation + " is NOT supported by TimeOperation");
    }

    public static int getUnitIdentifierForString(String unitString) {
        if (UNIT_YEAR_STRING.equals(unitString) || OLD_UNIT_YEAR_STRING.equals(unitString)) {
            return 1;
        }
        if (UNIT_MONTH_STRING.equals(unitString) || OLD_UNIT_MONTH_STRING.equals(unitString)) {
            return 2;
        }
        if (UNIT_DAY_STRING.equals(unitString) || OLD_UNIT_DAY_STRING.equals(unitString)) {
            return 5;
        }
        if (UNIT_HOUR_STRING.equals(unitString) || OLD_UNIT_HOUR_STRING.equals(unitString)) {
            return 10;
        }
        if (UNIT_MINUTE_STRING.equals(unitString) || OLD_UNIT_MINUTE_STRING.equals(unitString)) {
            return 12;
        }
        if (UNIT_SECOND_STRING.equals(unitString) || OLD_UNIT_SECOND_STRING.equals(unitString)) {
            return 13;
        }
        return 5;
    }

    public static String getUnitStringForIdentifier(int unitIdentifier) {
        switch (unitIdentifier) {
            case 1: {
                return UNIT_YEAR_STRING;
            }
            case 2: {
                return UNIT_MONTH_STRING;
            }
            case 5: {
                return UNIT_DAY_STRING;
            }
            case 10: {
                return UNIT_HOUR_STRING;
            }
            case 12: {
                return UNIT_MINUTE_STRING;
            }
            case 13: {
                return UNIT_SECOND_STRING;
            }
        }
        return "";
    }

    public static String[] getSupportedUnits() {
        return new String[]{UNIT_YEAR_STRING, UNIT_MONTH_STRING, UNIT_DAY_STRING, UNIT_HOUR_STRING, UNIT_MINUTE_STRING, UNIT_SECOND_STRING};
    }

    static {
        DEFAULT_UNIT_IDENTIFIER = 10;
        UNIT_YEAR_STRING = "Years";
        OLD_UNIT_YEAR_STRING = "Year";
        UNIT_MONTH_STRING = "Months";
        OLD_UNIT_MONTH_STRING = "Month";
        UNIT_DAY_STRING = "Days";
        OLD_UNIT_DAY_STRING = "Day";
        UNIT_HOUR_STRING = "Hours";
        OLD_UNIT_HOUR_STRING = "Hour";
        UNIT_MINUTE_STRING = "Minutes";
        OLD_UNIT_MINUTE_STRING = "Minute";
        UNIT_SECOND_STRING = "Seconds";
        OLD_UNIT_SECOND_STRING = "Second";
    }
}

