/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.modifiers.operation;

import ericsson.ere.datatype.Amount;

public enum AmountOperation {
    SET,
    ADD,
    SUBTRACT;


    public static String[] getOperationNames() {
        return new String[]{(Object)((Object)SET) + "", (Object)((Object)ADD) + "", (Object)((Object)SUBTRACT) + ""};
    }

    public static AmountOperation getOperation(String operation) {
        if (operation == null || operation.equals("SET")) {
            return SET;
        }
        if (operation.equals((Object)((Object)ADD) + "")) {
            return ADD;
        }
        if (operation.equals((Object)((Object)SUBTRACT) + "")) {
            return SUBTRACT;
        }
        throw new IllegalArgumentException("Operation " + operation + " is NOT supported by AmountOperation");
    }

    public Amount performAmount(Amount operand1, Amount operand2) {
        switch (this) {
            case SET: {
                return operand2;
            }
            case ADD: {
                return operand1.add(operand2);
            }
            case SUBTRACT: {
                return operand1.deduct(operand2);
            }
        }
        return operand1;
    }
}

