/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.modifiers.operation;

import com.ericsson.ere.dataset.DataDescriber;
import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.dataset.DataSetField;
import com.ericsson.ere.dataset.DataSetValueNotFoundException;
import com.ericsson.ere.dataset.DefaultDataDescriber;
import com.ericsson.ere.dataset.Key;
import com.ericsson.ere.datatype.LazyEvaluatedValue;
import com.ericsson.ere.datatype.ValueResolver;
import com.ericsson.ere.selectiontree.TreeExecutionException;
import com.ericsson.ere.selectiontree.modifiers.DataSetValueReader;
import com.ericsson.ere.selectiontree.modifiers.operation.Operation;
import com.ericsson.ere.selectiontree.util.FieldIndexKeyContainer;
import com.ericsson.ere.selectiontree.util.FieldOrientedPluginUtil;
import com.ericsson.ere.trace.PluginTraceHelper;
import com.ericsson.ere.trace.TracePoint;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.ClassRepositoryUtil;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.interfaces.UsedFieldLister;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class AbstractOperation<T, T2>
implements Operation<T, T2>,
UsedFieldLister {
    public static final String BUILTINFLD_CURRENTTIME = "CurrentTime()";
    public static final String BUILTINFLD_STARTTIME = "StartTime()";
    protected DataSetField myFieldToAffect;
    protected FieldIndexKeyContainer myFieldToAffectKeyContainer;
    private Object myFieldToAffectDefaultValue;
    protected DataSetField myOperandField;
    protected Object myOperandValue;
    protected FieldIndexKeyContainer myOperandFieldKeyContainer;
    protected DataType myOperandDataType;
    private DataSetValueReader myDataSetReader;

    @Override
    public String getFieldToAffectKey() {
        return this.myFieldToAffect.getFieldName();
    }

    @Override
    public void setFieldToAffect(DataSetField destField, FieldIndexKeyContainer keyContainer, ValueResolver resolver) {
        this.myFieldToAffect = destField;
        this.myFieldToAffectKeyContainer = keyContainer;
        this.myFieldToAffectDefaultValue = resolver.createDefaultInstance();
    }

    @Override
    public void setFieldOperand(DataSetField operandField, String value, FieldIndexKeyContainer keyContainer, ValueResolver resolver) {
        DataType dataType = this.myOperandDataType = resolver != null ? resolver.getDataType() : null;
        if (value != null) {
            this.myOperandValue = this.parseOperandValueString(resolver, value);
        } else {
            this.myOperandField = operandField;
        }
        this.myOperandFieldKeyContainer = keyContainer;
    }

    @Override
    public abstract String getOperation();

    @Override
    public String describeOperation() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.myFieldToAffect.getFieldName());
        buf.append(" ");
        buf.append(this.getOperation());
        buf.append(" ");
        if (this.myOperandField != null) {
            buf.append(this.myOperandField.getFieldName());
            buf.append(" ");
        } else {
            buf.append("value ");
        }
        return buf.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.myDataSetReader == null ? 0 : this.myDataSetReader.hashCode());
        result = 31 * result + (this.myFieldToAffect == null ? 0 : this.myFieldToAffect.hashCode());
        result = 31 * result + (this.myFieldToAffectKeyContainer == null ? 0 : this.myFieldToAffectKeyContainer.hashCode());
        result = 31 * result + (this.myFieldToAffectDefaultValue == null ? 0 : this.myFieldToAffectDefaultValue.hashCode());
        result = 31 * result + (this.myOperandDataType == null ? 0 : this.myOperandDataType.hashCode());
        result = 31 * result + (this.myOperandField == null ? 0 : this.myOperandField.hashCode());
        result = 31 * result + (this.myOperandFieldKeyContainer == null ? 0 : this.myOperandFieldKeyContainer.hashCode());
        result = 31 * result + (this.myOperandValue == null ? 0 : this.myOperandValue.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractOperation other = (AbstractOperation)obj;
        if (this.myDataSetReader == null ? other.myDataSetReader != null : !this.myDataSetReader.equals(other.myDataSetReader)) {
            return false;
        }
        if (this.myFieldToAffect == null ? other.myFieldToAffect != null : !this.myFieldToAffect.equals(other.myFieldToAffect)) {
            return false;
        }
        if (this.myFieldToAffectKeyContainer == null ? other.myFieldToAffectKeyContainer != null : !this.myFieldToAffectKeyContainer.equals(other.myFieldToAffectKeyContainer)) {
            return false;
        }
        if (this.myFieldToAffectDefaultValue == null ? other.myFieldToAffectDefaultValue != null : !this.myFieldToAffectDefaultValue.equals(other.myFieldToAffectDefaultValue)) {
            return false;
        }
        if (this.myOperandDataType == null ? other.myOperandDataType != null : !this.myOperandDataType.equals(other.myOperandDataType)) {
            return false;
        }
        if (this.myOperandField == null ? other.myOperandField != null : !this.myOperandField.equals(other.myOperandField)) {
            return false;
        }
        if (this.myOperandFieldKeyContainer == null ? other.myOperandFieldKeyContainer != null : !this.myOperandFieldKeyContainer.equals(other.myOperandFieldKeyContainer)) {
            return false;
        }
        return !(this.myOperandValue == null ? other.myOperandValue != null : !this.myOperandValue.equals(other.myOperandValue));
    }

    @Override
    public final List<T> getFieldToAffectValue(DataSet dataset) {
        Key[] keys = this.getKeys(dataset, this.myFieldToAffectKeyContainer);
        return this.getFieldToAffectValue(dataset, false, keys);
    }

    private List<T> getFieldToAffectValue(DataSet dataset, boolean forceValueExtraction, Key[] keys) {
        List<T> list;
        try {
            if (this.myDataSetReader != null) {
                list = this.extractAffectedFieldValueList(dataset, forceValueExtraction, keys);
            } else {
                try {
                    list = this.extractAffectedFieldValueList(dataset, forceValueExtraction, keys);
                }
                catch (DataSetValueNotFoundException e) {
                    list = Collections.singletonList(this.createDefaultValueForAffectedField(dataset));
                }
            }
        }
        catch (RuntimeException e) {
            throw this.wrapExceptionIfNeeded(e);
        }
        return list;
    }

    private Key[] getKeys(DataSet dataset, FieldIndexKeyContainer keyContainer) {
        Key[] keys = null;
        if (keyContainer != null) {
            try {
                keys = this.myDataSetReader != null ? this.myDataSetReader.getKeysFromDataSet(dataset, keyContainer) : keyContainer.getKeySet(dataset);
            }
            catch (RuntimeException ex) {
                throw this.wrapExceptionIfNeeded(ex);
            }
        }
        return keys;
    }

    private RuntimeException wrapExceptionIfNeeded(RuntimeException e) {
        if (this.myDataSetReader != null) {
            return new TreeExecutionException(e);
        }
        return e;
    }

    private List<T> extractAffectedFieldValueList(DataSet dataset, boolean forceValueExtraction, Key[] keys) {
        List<T> list = keys != null ? this.extractAffectedFieldValues(dataset, keys, forceValueExtraction) : this.extractSingleAffectedFieldValue(dataset, forceValueExtraction);
        return list;
    }

    private List<T> extractSingleAffectedFieldValue(DataSet dataset, boolean forceValueExtraction) {
        try {
            if (this.needsAffectedFieldValueForOperation() || forceValueExtraction) {
                Object value = this.getSingleFieldValue(dataset, this.myFieldToAffect, null);
                return Collections.singletonList(this.prepareAffectedValue(value, dataset));
            }
            return Collections.singletonList(null);
        }
        catch (RuntimeException e) {
            throw this.wrapExceptionIfNeeded(e);
        }
    }

    private List<T> extractAffectedFieldValues(DataSet dataset, Key[] fieldToAffectKeys, boolean forceValueExtraction) {
        List<Object> list;
        assert (fieldToAffectKeys != null);
        if (this.needsAffectedFieldValueForOperation() || forceValueExtraction) {
            list = new ArrayList(fieldToAffectKeys.length);
            for (int i = 0; i < fieldToAffectKeys.length; ++i) {
                T value;
                if (this.myDataSetReader != null) {
                    try {
                        value = this.prepareAffectedValue(this.myDataSetReader.getValueFromDataSet(dataset, this.myFieldToAffect, fieldToAffectKeys[i]), dataset);
                        list.add(value);
                        continue;
                    }
                    catch (RuntimeException e) {
                        throw new TreeExecutionException(e);
                    }
                }
                try {
                    value = this.prepareAffectedValue(this.myFieldToAffect.getValueFromDataSet(dataset, fieldToAffectKeys[i]), dataset);
                    list.add(value);
                    continue;
                }
                catch (DataSetValueNotFoundException e) {
                    list.add(this.createDefaultValueForAffectedField(dataset));
                }
            }
        } else {
            list = this.createListWithNullValuesOfSize(fieldToAffectKeys.length);
        }
        return list;
    }

    private List<T> createListWithNullValuesOfSize(int length) {
        ArrayList<Object> list = new ArrayList<Object>(length);
        for (int i = 0; i < length; ++i) {
            list.add(null);
        }
        return list;
    }

    protected boolean needsAffectedFieldValueForOperation() {
        return true;
    }

    protected T prepareAffectedValue(Object value, DataSet dataSet) {
        return (T)value;
    }

    protected T createDefaultValueForAffectedField(DataSet dataSet) {
        Object ret = this.myFieldToAffectDefaultValue;
        if (ret instanceof LazyEvaluatedValue) {
            ret = ((LazyEvaluatedValue)ret).evaluate(dataSet);
        }
        return (T)ret;
    }

    @Override
    public final T2 getOperandValue(DataSet dataSet) {
        T2 operandValue = null;
        try {
            Object value = this.myOperandValue;
            if (value instanceof LazyEvaluatedValue) {
                value = ((LazyEvaluatedValue)value).evaluate(dataSet);
            } else if (value == null && (value = this.fetchSpecialOperandValue(dataSet)) == null) {
                Key[] keyArray = this.getKeys(dataSet, this.myOperandFieldKeyContainer);
                Key operandFieldKey = keyArray != null ? FieldOrientedPluginUtil.extractFirstKeyFromSet(keyArray) : null;
                value = this.getSingleFieldValue(dataSet, this.myOperandField, operandFieldKey);
            }
            operandValue = this.prepareOperandValue(value, dataSet);
        }
        catch (RuntimeException e) {
            throw this.wrapExceptionIfNeeded(e);
        }
        return operandValue;
    }

    private Object getSingleFieldValue(DataSet dataSet, DataSetField field, Key key) {
        Object fetchedValue = this.myDataSetReader != null ? this.myDataSetReader.getValueFromDataSet(dataSet, field, key) : field.getValueFromDataSet(dataSet, key);
        return fetchedValue;
    }

    protected T2 fetchSpecialOperandValue(DataSet dataSet) {
        return null;
    }

    protected T2 prepareOperandValue(Object value, DataSet dataSet) {
        return (T2)value;
    }

    protected Object parseOperandValueString(ValueResolver resolver, String valueString) {
        return resolver.parseValueString(valueString);
    }

    @Override
    public String getTraceString(DataSet pre, DataSet post) {
        FieldDefinition sourceFieldFD;
        List<T> fieldToAffectValueBefore = this.getFieldToAffectValue(pre);
        T2 operand2 = null;
        try {
            operand2 = this.fetchSpecialOperandValue(pre);
            if (operand2 == null) {
                operand2 = this.getOperandValue(pre);
            }
        }
        catch (DataSetValueNotFoundException dataSetValueNotFoundException) {
            // empty catch block
        }
        Key[] keys = this.getKeys(post, this.myFieldToAffectKeyContainer);
        List<T> result = this.getFieldToAffectValue(post, true, keys);
        StringBuilder buf = new StringBuilder("FieldOperation : ");
        String fieldToAffectName = this.myFieldToAffect.getFieldName();
        ClassRepository repository = pre.getService().getClassRepository(ClassRepositoryUtil.getCurrentFieldContext(pre));
        FieldDefinition fieldToAffectFD = repository.getFieldDefinitionByName(fieldToAffectName);
        assert (fieldToAffectFD != null) : "Missing destination field!";
        FieldDefinition fieldDefinition = sourceFieldFD = this.myOperandField == null ? null : repository.getFieldDefinitionByName(this.myOperandField.getFieldName());
        if (keys != null) {
            for (int i = 0; i < fieldToAffectValueBefore.size(); ++i) {
                if (i > 0) {
                    buf.append("\n");
                }
                this.appendSingleOperationTrace(buf, pre, fieldToAffectValueBefore.get(i), operand2, result.get(i), fieldToAffectFD, sourceFieldFD, keys[i], this.myFieldToAffectKeyContainer.getKeyFieldName());
            }
        } else {
            this.appendSingleOperationTrace(buf, pre, fieldToAffectValueBefore.get(0), operand2, result.get(0), fieldToAffectFD, sourceFieldFD, null, null);
        }
        return buf.toString();
    }

    private void appendSingleOperationTrace(StringBuilder buf, DataSet dataset, T fieldToAffectValueBefore, T2 operandValue, T result, FieldDefinition fieldToAffectFD, FieldDefinition sourceFieldFD, Key fieldToAffectKey, String fieldToAffectKeyFieldName) {
        buf.append(FieldOrientedPluginUtil.formatFieldNameWithKeyInformation(fieldToAffectFD.getFieldName(), fieldToAffectKey, fieldToAffectKeyFieldName, dataset));
        this.appendDisplayableStringFromAffectedFieldValueObjectWithParenthesis(buf, fieldToAffectValueBefore, fieldToAffectFD, true);
        buf.append(" ");
        buf.append(this.getOperation());
        buf.append(this.getAdditionalInformationString());
        buf.append(" ");
        this.printOperandSpecificTrace(dataset, operandValue, fieldToAffectFD, sourceFieldFD, buf);
        buf.append(" = ");
        this.appendDisplayableStringFromAffectedFieldValueObjectWithParenthesis(buf, result, fieldToAffectFD, false);
    }

    private void printOperandSpecificTrace(DataSet data, Object operand2Value, FieldDefinition affectedFieldDefinition, FieldDefinition sourceFieldDefinition, StringBuilder buf) {
        if (this.myOperandValue == null) {
            Key operandFieldKey;
            Key[] keyArray = this.getKeys(data, this.myOperandFieldKeyContainer);
            Key key = operandFieldKey = keyArray != null ? FieldOrientedPluginUtil.extractFirstKeyFromSet(keyArray) : null;
            if (operandFieldKey != null) {
                buf.append(FieldOrientedPluginUtil.formatFieldNameWithKeyInformation(this.myOperandField.getFieldName(), operandFieldKey, this.myOperandFieldKeyContainer.getKeyFieldName(), data));
            } else {
                buf.append(this.myOperandField.getFieldName());
            }
            buf.append(" (");
            FieldDefinition fd = this.useCurrentTime(this.myOperandField) || this.useStartTime(this.myOperandField) ? affectedFieldDefinition : sourceFieldDefinition;
            buf.append(operand2Value != null ? this.makeDisplayableStringFromOperandValueObject(operand2Value, fd) : "[VALUE NOT FOUND]");
            buf.append(")");
        } else {
            buf.append(operand2Value != null ? this.makeDisplayableStringFromOperandValueObject(operand2Value, affectedFieldDefinition) : "[VALUE NOT FOUND]");
        }
    }

    public String getAdditionalInformationString() {
        return "";
    }

    private void appendDisplayableStringFromAffectedFieldValueObjectWithParenthesis(StringBuilder buf, Object valueObject, FieldDefinition fd, boolean printParentheses) {
        if (valueObject != null) {
            buf.append(printParentheses ? " (" : "");
            buf.append(this.makeDisplayableStringFromAffectedFieldValueObject(valueObject, fd));
            buf.append(printParentheses ? ")" : "");
        }
    }

    protected String makeDisplayableStringFromAffectedFieldValueObject(Object valueObject, FieldDefinition fd) {
        return this.createDataDescriber().describeObject(valueObject, fd);
    }

    public String makeDisplayableStringFromOperandValueObject(Object valueObject, FieldDefinition fd) {
        DataDescriber describer = this.createDataDescriber();
        if (this.myOperandField == null && !"SET".equals(this.getOperation())) {
            return describer.describeObject(valueObject, fd.getTypedDataType());
        }
        return describer.describeObject(valueObject, fd);
    }

    protected DataDescriber createDataDescriber() {
        return new DefaultDataDescriber();
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": " + this.getOperation();
    }

    @Deprecated
    public void setShouldThrowWhenFieldValueMissing() {
    }

    public void setDataSetValueReader(DataSetValueReader reader) {
        this.myDataSetReader = reader;
    }

    @Override
    public void perform(DataSet dataset) {
        Key[] keys = this.getKeys(dataset, this.myFieldToAffectKeyContainer);
        List<T> initialValues = this.getFieldToAffectValue(dataset, false, keys);
        T2 operandValue = this.getOperandValue(dataset);
        for (int i = 0; i < initialValues.size(); ++i) {
            T result = this.perform(initialValues.get(i), operandValue, dataset);
            this.myFieldToAffect.setValueInDataSet(dataset, keys != null ? keys[i] : null, result);
        }
    }

    @Override
    public final boolean isDataTypeSupported(String dataType) {
        return this.isDataTypeSupported(DataType.lookup(dataType));
    }

    @Override
    public void setAdditionalData(String data) {
    }

    @Override
    public boolean useAdditionalData() {
        return false;
    }

    @Override
    public String getAdditionalDataLabel() {
        return "";
    }

    protected abstract T perform(T var1, T2 var2, DataSet var3);

    protected abstract boolean isDataTypeSupported(DataType var1);

    public void setPreTracePointInfo(TracePoint tp) {
        PluginTraceHelper.addFieldValueAsPreDataInTracePoint(this.myFieldToAffect, this.myFieldToAffectKeyContainer, tp);
        if (this.myOperandField != null) {
            if (this.useCurrentTime(this.myOperandField)) {
                PluginTraceHelper.storeCurrentTimeAsPreDataInTracePoint(tp);
            } else if (!this.useStartTime(this.myOperandField)) {
                PluginTraceHelper.addFieldValueAsPreDataInTracePoint(this.myOperandField, this.myOperandFieldKeyContainer, tp);
            }
        }
    }

    protected boolean useCurrentTime(DataSetField field) {
        return BUILTINFLD_CURRENTTIME.equals(field.getFieldName());
    }

    protected boolean useStartTime(DataSetField field) {
        return BUILTINFLD_STARTTIME.equals(field.getFieldName());
    }

    public void setTracePointInfo(TracePoint tp) {
        PluginTraceHelper.addFieldValueAsPostDataInTracePoint(this.myFieldToAffect, this.myFieldToAffectKeyContainer, tp);
    }

    @Override
    public Set<String> getUsedFields() {
        HashSet<String> set = new HashSet<String>();
        if (this.myOperandField != null) {
            set.add(this.myOperandField.getFieldName());
            if (this.myOperandFieldKeyContainer != null) {
                set.addAll(this.myOperandFieldKeyContainer.getUsedFields());
            }
        }
        set.add(this.myFieldToAffect.getFieldName());
        if (this.myFieldToAffectKeyContainer != null) {
            set.addAll(this.myFieldToAffectKeyContainer.getUsedFields());
        }
        return set;
    }
}

