/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.modifiers.mfo;

import com.ericsson.ere.annotations.jcip.Immutable;
import com.ericsson.ere.expression.EvaluationContext;
import com.ericsson.ere.expression.FieldContainerOperand;
import com.ericsson.ere.expression.Operand;
import com.ericsson.ere.selectiontree.util.MultipleValueFieldCompositeObject;
import com.ericsson.ere.selectiontree.util.ValueFieldCompositeObject;
import ericsson.ere.datatype.DataType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

@Immutable
public class ValueFieldCompositeOperand
implements Operand,
FieldContainerOperand {
    private final ValueFieldCompositeObject myValue;
    private final ValueFieldCompositeObject myIndex;
    private final boolean myIndexIsMapKey;

    public ValueFieldCompositeOperand(ValueFieldCompositeObject value) {
        this(value, null);
    }

    public ValueFieldCompositeOperand(ValueFieldCompositeObject value, ValueFieldCompositeObject index) {
        this(value, index, false);
    }

    public ValueFieldCompositeOperand(ValueFieldCompositeObject value, ValueFieldCompositeObject index, boolean indexIsMapKey) {
        this.myValue = value;
        this.myIndex = index;
        this.myIndexIsMapKey = indexIsMapKey;
    }

    @Override
    public Object getValue(EvaluationContext context) {
        throw new AssertionError((Object)"Not meant to be called for this operand type.");
    }

    public ValueFieldCompositeObject getValue() {
        return this.myValue;
    }

    public ValueFieldCompositeObject getIndex() {
        return this.myIndex;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.myIndex == null ? 0 : this.myIndex.hashCode());
        result = 31 * result + (this.myIndexIsMapKey ? 1231 : 1237);
        result = 31 * result + (this.myValue == null ? 0 : this.myValue.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ValueFieldCompositeOperand other = (ValueFieldCompositeOperand)obj;
        if (this.myIndex == null ? other.myIndex != null : !this.myIndex.equals(other.myIndex)) {
            return false;
        }
        if (this.myIndexIsMapKey != other.myIndexIsMapKey) {
            return false;
        }
        return !(this.myValue == null ? other.myValue != null : !this.myValue.equals(other.myValue));
    }

    public String toString() {
        String s = this.describe(this.myValue);
        if (this.myIndex != null) {
            s = s + "[" + this.describe(this.myIndex) + "]";
        }
        return s;
    }

    private String describe(ValueFieldCompositeObject obj) {
        String value = this.getDisplayString(obj);
        if (this.isMapKeyValue(obj)) {
            value = "'" + value + "'";
        } else if (this.hasValueOfStringType(obj)) {
            value = "\"" + value + "\"";
        }
        return value;
    }

    private String getDisplayString(ValueFieldCompositeObject obj) {
        String str = obj.getFieldOrValueAsString();
        if (obj.getMode() == ValueFieldCompositeObject.Mode.Field || obj instanceof MultipleValueFieldCompositeObject) {
            return str;
        }
        DataType dt = obj.getValueDataType();
        return dt == null ? str : dt.makeDisplayString(dt.parseValue(str));
    }

    private boolean hasValueOfStringType(ValueFieldCompositeObject obj) {
        DataType dt;
        boolean valueOfStringType = obj instanceof MultipleValueFieldCompositeObject ? false : (obj.getMode() != ValueFieldCompositeObject.Mode.Value ? false : (dt = obj.getValueDataType()) != null && dt.isStringType());
        return valueOfStringType;
    }

    private boolean isMapKeyValue(ValueFieldCompositeObject obj) {
        return obj == this.myIndex && this.myIndexIsMapKey && obj.getMode() == ValueFieldCompositeObject.Mode.Value;
    }

    @Override
    public Collection<FieldContainerOperand.FieldContainer> getContainedFields() {
        List<FieldContainerOperand.FieldContainer> fields;
        if (this.myValue.getMode() == ValueFieldCompositeObject.Mode.Field) {
            fields = new ArrayList();
            fields.add(new FieldContainerOperand.FieldContainer(this.myValue.getFieldOrValueAsString(), (Object)this.myIndex));
            if (this.myIndex != null) {
                this.addIndexFields(fields, this.myIndex);
            }
        } else {
            fields = Collections.emptyList();
        }
        return fields;
    }

    private void addIndexFields(List<FieldContainerOperand.FieldContainer> fields, ValueFieldCompositeObject object) {
        if (object instanceof MultipleValueFieldCompositeObject) {
            List children = (List)object.getValueAsObject();
            for (ValueFieldCompositeObject child : children) {
                this.addIndexFields(fields, child);
            }
        } else if (object.getMode() == ValueFieldCompositeObject.Mode.Field) {
            fields.add(new FieldContainerOperand.FieldContainer(object.getFieldOrValueAsString(), null));
        }
    }
}

