/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.modifiers.mfo;

import com.ericsson.ere.expression.ExpressionToken;
import com.ericsson.ere.expression.Function;
import com.ericsson.ere.expression.FunctionParameterInfo;
import com.ericsson.ere.selectiontree.modifiers.mfo.ComplexRow;
import com.ericsson.ere.selectiontree.modifiers.mfo.ExpressionPanel;
import com.ericsson.ere.selectiontree.modifiers.mfo.ExpressionVariable;
import com.ericsson.ere.selectiontree.modifiers.mfo.FunctionRow;
import com.ericsson.ere.selectiontree.modifiers.mfo.FunctionVariant;
import com.ericsson.ere.selectiontree.modifiers.mfo.MFORow;
import com.ericsson.ere.selectiontree.modifiers.mfo.MultiFieldOperationModel;
import ericsson.ere.gui.util.GuiUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class MultiFieldOperationRowRenderer
extends DefaultListCellRenderer {
    private static final Border NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);
    private Font myFont = new Font("Monospaced", 0, 12);

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        boolean invalid;
        super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        this.setFont(this.myFont);
        MultiFieldOperationModel model = (MultiFieldOperationModel)list.getModel();
        String desc = model.describeRow(index);
        this.setText(desc);
        this.setToolTipText(null);
        if (cellHasFocus && !isSelected) {
            this.setBorder(NO_FOCUS_BORDER);
        }
        Map<ExpressionToken, String> invalidTokens = this.getInvalidTokensInCurrentExpression(list);
        MFORow row = (MFORow)value;
        List<ExpressionToken> rowTokens = row.getExpressionTokens();
        ArrayList<ExpressionToken> invalidRowTokens = new ArrayList<ExpressionToken>(rowTokens);
        this.retainAllByIdentity(invalidRowTokens, invalidTokens.keySet());
        boolean bl = invalid = !invalidRowTokens.isEmpty();
        if (invalid) {
            this.setForeground(Color.red);
            this.setFont(this.myFont.deriveFont(1));
            StringBuilder b = new StringBuilder("<html><b>Invalid on this row</b>:");
            for (ExpressionToken invalidRowToken : invalidRowTokens) {
                String reason = invalidTokens.get(invalidRowToken);
                if (reason == null) continue;
                b.append("<br>").append(reason).append(" (<b>").append(invalidRowToken).append("</b>)");
            }
            b.append("</html>");
            String invalidReason = b.toString();
            if (!"".equals(invalidReason)) {
                this.setToolTipText(invalidReason);
            }
        } else {
            String fdesc = this.describeFunctionsOfRow(row);
            if (!"".equals(fdesc)) {
                this.setToolTipText(fdesc);
            }
        }
        return this;
    }

    private String describeFunctionsOfRow(MFORow row) {
        String desc = "";
        List<FunctionRow> functionRows = this.findFunctionRows(row);
        if (!functionRows.isEmpty()) {
            StringBuilder b = new StringBuilder("<html>");
            for (FunctionRow frow : functionRows) {
                FunctionVariant variant = frow.getFunctionVariant();
                this.describeFunctionParameters(b, variant);
            }
            b.append("</html>");
            desc = b.toString();
        }
        return desc;
    }

    private List<FunctionRow> findFunctionRows(MFORow row) {
        ArrayList<FunctionRow> rows = new ArrayList<FunctionRow>();
        ComplexRow parent = this.getParentIfLeadRow(row);
        while (parent != null) {
            if (parent instanceof FunctionRow) {
                rows.add((FunctionRow)parent);
            }
            parent = this.getParentIfLeadRow(parent);
        }
        return rows;
    }

    private ComplexRow getParentIfLeadRow(MFORow row) {
        ComplexRow parent = row.getParent();
        return parent != null && parent.isLeadRow(row) ? parent : null;
    }

    private void describeFunctionParameters(StringBuilder b, FunctionVariant variant) {
        Function func = variant.getFunction();
        int paramCount = variant.getParameterCount();
        b.append("<p><b>Parameters for function ");
        b.append(func.getFunctionName()).append("</b>:<dl>");
        FunctionParameterInfo[] parameters = func.getParameters();
        for (int i = 0; i < paramCount; ++i) {
            FunctionParameterInfo param = parameters[i];
            b.append("<dt>").append(param.getName()).append("</dt>");
            b.append("<dd>").append(param.getDescription()).append("</dd>");
        }
        b.append("</dl></p>");
    }

    private Map<ExpressionToken, String> getInvalidTokensInCurrentExpression(JList list) {
        Map<ExpressionToken, String> map;
        ExpressionPanel panel = GuiUtil.getClosestParentOfClass(list, ExpressionPanel.class);
        if (panel != null) {
            ExpressionVariable owner = panel.getOwner();
            map = owner.getInvalidTokens();
        } else {
            map = Collections.emptyMap();
        }
        return map;
    }

    private <T> void retainAllByIdentity(Collection<T> collection, Collection<?> keep) {
        IdentityHashMap map = new IdentityHashMap();
        for (Object toKeep : keep) {
            map.put(toKeep, toKeep);
        }
        Iterator<T> iterator = collection.iterator();
        while (iterator.hasNext()) {
            T cand = iterator.next();
            if (map.containsKey(cand)) continue;
            iterator.remove();
        }
    }
}

