/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.modifiers.mfo;

import com.ericsson.charging.common.RMAStatusInterface;
import com.ericsson.charging.common.StatusInterface;
import com.ericsson.charging.common.dataitem.DataItemAdapter;
import com.ericsson.ere.expression.ExpressionToken;
import com.ericsson.ere.expression.Operator;
import com.ericsson.ere.expression.Operators;
import com.ericsson.ere.selectiontree.modifiers.mfo.ExpressionVariable;
import com.ericsson.ere.selectiontree.modifiers.mfo.MFORow;
import com.ericsson.ere.selectiontree.modifiers.mfo.SimpleRow;
import com.ericsson.ere.selectiontree.modifiers.mfo.ValueFieldCompositeOperand;
import com.ericsson.ere.selectiontree.util.FieldOrientedPluginProfileUtil;
import com.ericsson.ere.selectiontree.util.ValueFieldCompositeObject;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.exception.NotImplementedException;
import ericsson.vareditor.VarTable2;
import ericsson.vareditor.VarTableModel;
import ericsson.vareditor.documents.RatingDecimalDocument;
import ericsson.vareditor.variable.TypedDropDownVariable;
import ericsson.vareditor.variable.ValueFieldVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.text.PlainDocument;
import org.w3c.dom.Element;

public class MultiFieldOperationDialog {
    private static HashMap<ExpressionToken, String> TOKEN_DESC = new HashMap();
    private static final String OPERATION_VARIABLE_LABEL = "Operation";
    private static final String VALUE_VARIABLE_LABEL = "Operand";
    private static final String INDEX_VARIABLE_LABEL = "Index";
    private ExpressionVariable.ExpressionBuilder myExpressionBuilder;
    private VarTableModel myVariableModel;
    private JOptionPane myPane;

    public static MFORow createForAdd(Component owner, ExpressionVariable.ExpressionBuilder expressionBuilder) {
        MultiFieldOperationDialog dlg = new MultiFieldOperationDialog(expressionBuilder);
        return dlg.getRowViaDialog(owner, null);
    }

    public static MFORow createForEdit(Component owner, ExpressionVariable.ExpressionBuilder expressionBuilder, MFORow currentRow) {
        MultiFieldOperationDialog dlg = new MultiFieldOperationDialog(expressionBuilder);
        return dlg.getRowViaDialog(owner, currentRow);
    }

    private MultiFieldOperationDialog(ExpressionVariable.ExpressionBuilder expressionBuilder) {
        this.myExpressionBuilder = expressionBuilder;
    }

    private JPanel createContentsPanel(MFORow selectedRow) {
        JPanel panel = new JPanel(new BorderLayout());
        VarTable2 varTable = new VarTable2(this.createModel(selectedRow));
        varTable.setPreferredSize(new Dimension(300, 150));
        panel.add((Component)varTable, "Center");
        return panel;
    }

    private MFORow getRowViaDialog(Component owner, MFORow row) {
        JOptionPane pane;
        RMAStatusInterface statusHandler = new RMAStatusInterface();
        String title = row == null ? "Add expression row" : "Edit expression row";
        JPanel contentsPanel = this.createContentsPanel(row);
        Object oldOrientation = UIManager.put("OptionPane.buttonOrientation", 4);
        JButton okButton = new JButton(new OKAction(statusHandler));
        this.sizeEqualToCancelButton(okButton);
        this.myPane = pane = new JOptionPane(contentsPanel, -1, -1, null, new Object[]{okButton, "Cancel"}, okButton);
        JDialog dialog = pane.createDialog(owner, title);
        dialog.setName("MFOVariableDialog");
        dialog.setResizable(true);
        pane.selectInitialValue();
        dialog.setVisible(true);
        dialog.dispose();
        statusHandler.printMessage("");
        UIManager.put("OptionPane.buttonOrientation", oldOrientation);
        Object selectedValue = pane.getValue();
        return selectedValue instanceof MFORow ? (MFORow)selectedValue : null;
    }

    private void sizeEqualToCancelButton(JButton btn) {
        Dimension d = new JButton("Cancel").getPreferredSize();
        btn.setPreferredSize(d);
    }

    private VarTableModel createModel(MFORow row) {
        this.myVariableModel = this.createVariableModelFromRow(row);
        return this.myVariableModel;
    }

    private VarTableModel createVariableModelFromRow(MFORow row) {
        VarTableModel model = new VarTableModel();
        model.addRow(this.createOperatorVariableFromRow(row));
        Variable operandVariable = this.createOperandVariableFromRow(row);
        if (operandVariable != null) {
            model.addRow(operandVariable);
            Variable indexVariable = this.createIndexVariableIfApplicableFromRow(row);
            if (indexVariable != null) {
                model.addRow(indexVariable);
            }
        }
        return model;
    }

    private Variable createOperatorVariableFromRow(MFORow row) {
        TypedDropDownVariable<ExpressionToken> operatorVariable;
        List<ExpressionToken> operators = this.getSupportedOperators();
        ExpressionToken selectedOperator = row != null ? this.extractOperator(row) : this.getDefaultOperator(operators);
        if (this.isLockedOperator(selectedOperator)) {
            operatorVariable = new TypedDropDownVariable<ExpressionToken>(OPERATION_VARIABLE_LABEL, new ExpressionToken[]{selectedOperator}, selectedOperator);
            operatorVariable.setAllowEdit(false);
        } else {
            operatorVariable = new TypedDropDownVariable<ExpressionToken>(OPERATION_VARIABLE_LABEL, operators.toArray(new ExpressionToken[operators.size()]), selectedOperator, new MFOItemLabeler());
        }
        return operatorVariable;
    }

    private boolean isLockedOperator(ExpressionToken operator) {
        return operator.equals(Operators.ASSIGN) || operator.equals(ExpressionToken.FUNCTION_ARG_SEPARATOR);
    }

    private ExpressionToken extractOperator(MFORow row) {
        List<ExpressionToken> tokens = row.getExpressionTokens();
        assert (!tokens.isEmpty() && tokens.get(0) instanceof Operator || tokens.get(0).equals(ExpressionToken.FUNCTION_ARG_SEPARATOR));
        return tokens.get(0);
    }

    private ValueFieldCompositeOperand extractOperand(MFORow row) {
        List<ExpressionToken> tokens = row.getExpressionTokens();
        ValueFieldCompositeOperand ret = null;
        for (ExpressionToken tok : tokens) {
            if (!(tok instanceof ValueFieldCompositeOperand)) continue;
            ret = (ValueFieldCompositeOperand)tok;
            break;
        }
        return ret;
    }

    private List<ExpressionToken> getSupportedOperators() {
        ArrayList<ExpressionToken> operators = new ArrayList<ExpressionToken>();
        operators.addAll(this.myExpressionBuilder.getAllowedOperators());
        return operators;
    }

    private ExpressionToken getDefaultOperator(List<ExpressionToken> operators) {
        ExpressionToken token = Operators.ADD;
        if (!operators.contains(token)) {
            token = operators.get(0);
        }
        return token;
    }

    private Variable createOperandVariableFromRow(MFORow row) {
        ValueFieldCompositeObject obj = null;
        if (row != null) {
            ValueFieldCompositeOperand selectedOperand = this.extractOperand(row);
            if (selectedOperand == null) {
                return null;
            }
            obj = selectedOperand.getValue();
        }
        List<DataType> valueDataTypes = this.myExpressionBuilder.getAllowedValueDataTypes();
        ValueFieldVariable.ValueType[] refSelected = new ValueFieldVariable.ValueType[1];
        ValueFieldVariable.ValueType[] valueTypes = this.createValueTypesFromDataTypes(valueDataTypes, obj, refSelected);
        if (obj == null) {
            DataType dt = refSelected[0].getDataType();
            if (dt != null) {
                String value = this.createDefaultValueAsString(this.myExpressionBuilder.getClassRepository(), dt);
                obj = ValueFieldCompositeObject.createForValue(value, dt);
            } else {
                obj = new ValueFieldCompositeObject(ValueFieldCompositeObject.Mode.Value, "0");
            }
        }
        List<String> allowedOperandFields = this.myExpressionBuilder.getAllowedOperandFields();
        String[] availableFields = allowedOperandFields.toArray(new String[allowedOperandFields.size()]);
        ValueFieldVariable valueVariable = ValueFieldVariable.createForMultipleTypesWithSelected(VALUE_VARIABLE_LABEL, obj, availableFields, valueTypes, refSelected[0]);
        valueVariable.setDataItem(new VariableListener());
        return valueVariable;
    }

    private String createDefaultValueAsString(ClassRepository repository, DataType valueType) {
        Object value = valueType.createContextBasedValueResolver().withClassRepository(repository).createDefaultValue();
        return valueType.makeParseableString(value);
    }

    private ValueFieldVariable.ValueType[] createValueTypesFromDataTypes(List<DataType> valueDataTypes, ValueFieldCompositeObject obj, ValueFieldVariable.ValueType[] refSelected) {
        ArrayList<DataType> newTypes = new ArrayList<DataType>();
        for (DataType dt : valueDataTypes) {
            DataType use = dt.isNumeric() ? DataType.RATINGDECIMAL : dt;
            if (newTypes.contains(use)) continue;
            newTypes.add(use);
        }
        assert (newTypes.size() > 0) : "Expected at least one data type.";
        DataType objectType = obj != null ? this.getValueObjectType(obj) : null;
        ValueFieldVariable.ValueType[] valueTypes = new ValueFieldVariable.ValueType[newTypes.size()];
        int idx = 0;
        for (DataType dt : newTypes) {
            ValueFieldVariable.ValueType vt;
            switch (dt) {
                case RATINGDECIMAL: {
                    vt = new ValueFieldVariable.ValueType(new RatingDecimalDocument(false, true), null, "Numeric");
                    break;
                }
                case AMOUNT: {
                    vt = new ValueFieldVariable.AmountValueType(this.myExpressionBuilder.getClassRepository(), true);
                    break;
                }
                case STRING: {
                    vt = new ValueFieldVariable.ValueType(new PlainDocument(), DataType.STRING, "String");
                    break;
                }
                default: {
                    throw new NotImplementedException("ValueType construction not implemented for " + dt);
                }
            }
            valueTypes[idx++] = vt;
            if (dt != objectType) continue;
            refSelected[0] = vt;
        }
        if (refSelected[0] == null) {
            refSelected[0] = valueTypes[0];
        }
        return valueTypes;
    }

    private DataType getValueObjectType(ValueFieldCompositeObject obj) {
        DataType ret = null;
        if (obj.getMode() == ValueFieldCompositeObject.Mode.Field) {
            FieldDefinition fd = this.myExpressionBuilder.getClassRepository().getFieldDefinitionByName(obj.getFieldOrValueAsString());
            if (fd != null) {
                ret = fd.getTypedDataType();
            }
        } else {
            ret = obj.getValueDataType();
        }
        if (ret == null) {
            ret = DataType.RATINGDECIMAL;
        }
        return ret;
    }

    private Variable createIndexVariableIfApplicableFromRow(MFORow row) {
        ClassRepository repository;
        FieldDefinition fieldDefinition;
        ValueFieldCompositeObject indexCompositeObject;
        ValueFieldCompositeOperand selectedOperand;
        Variable var = null;
        ValueFieldCompositeOperand valueFieldCompositeOperand = selectedOperand = row == null ? null : this.extractOperand(row);
        if (selectedOperand != null && (indexCompositeObject = selectedOperand.getIndex()) != null && (fieldDefinition = (repository = this.myExpressionBuilder.getClassRepository()).getFieldDefinitionByName(selectedOperand.getValue().getFieldOrValueAsString())) != null) {
            var = FieldOrientedPluginProfileUtil.createIndexVariable(INDEX_VARIABLE_LABEL, INDEX_VARIABLE_LABEL, fieldDefinition, repository, indexCompositeObject, true);
        }
        return var;
    }

    private boolean isMapField(String field) {
        FieldDefinition fd = this.myExpressionBuilder.getClassRepository().getFieldDefinitionByName(field);
        return fd != null && fd.isMap();
    }

    private boolean allVariablesValid() {
        return VarListUtil.areAllValid(this.myVariableModel.getData());
    }

    static {
        TOKEN_DESC.put(Operators.ADD, "add");
        TOKEN_DESC.put(Operators.SUBTRACT, "subtract");
        TOKEN_DESC.put(Operators.DIVIDE, "divide");
        TOKEN_DESC.put(Operators.MULTIPLY, "multiply");
        TOKEN_DESC.put(Operators.INT_DIVIDE, "integer divide");
        TOKEN_DESC.put(Operators.MODULUS, "modulus");
        TOKEN_DESC.put(Operators.POWER, "power");
        TOKEN_DESC.put(Operators.APPEND, "append");
        TOKEN_DESC.put(Operators.PREFIX, "prefix");
        TOKEN_DESC.put(ExpressionToken.FUNCTION_ARG_SEPARATOR, "function argument separator");
    }

    private class VariableListener
    extends DataItemAdapter {
        private VariableListener() {
        }

        @Override
        public void setDataItem(Object reference, Object object) {
            if (reference.equals(MultiFieldOperationDialog.VALUE_VARIABLE_LABEL)) {
                ClassRepository repository;
                FieldDefinition fd;
                if (MultiFieldOperationDialog.this.myVariableModel.getRowCount() > 2) {
                    MultiFieldOperationDialog.this.myVariableModel.removeRow(2);
                }
                if (((ValueFieldVariable)object).inFieldMode() && (fd = (repository = MultiFieldOperationDialog.this.myExpressionBuilder.getClassRepository()).getFieldDefinitionByName(((Variable)object).getValueString())) != null && fd.isComplexType()) {
                    MultiFieldOperationDialog.this.myVariableModel.addRow(FieldOrientedPluginProfileUtil.createIndexVariable(MultiFieldOperationDialog.INDEX_VARIABLE_LABEL, MultiFieldOperationDialog.INDEX_VARIABLE_LABEL, fd, repository, (Element)null, true));
                }
            }
        }
    }

    private class MFOItemLabeler
    implements TypedDropDownVariable.ItemLabeler<ExpressionToken> {
        private MFOItemLabeler() {
        }

        @Override
        public String getDisplayStringFor(ExpressionToken token, int index) {
            String descriptiveString = "";
            String desc = (String)TOKEN_DESC.get(token);
            descriptiveString = desc != null ? token.toString() + " (" + desc + ")" : token.toString();
            return descriptiveString;
        }
    }

    private class OKAction
    extends AbstractAction {
        private StatusInterface myStatusHandler;

        OKAction(StatusInterface statusHandler) {
            this.putValue("Name", "OK");
            this.myStatusHandler = statusHandler;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (MultiFieldOperationDialog.this.allVariablesValid()) {
                ValueFieldCompositeOperand operand = null;
                ExpressionToken operator = (ExpressionToken)((TypedDropDownVariable)MultiFieldOperationDialog.this.myVariableModel.getVariableForLabel(MultiFieldOperationDialog.OPERATION_VARIABLE_LABEL)).getSelectedItem();
                ValueFieldVariable valueVariable = (ValueFieldVariable)MultiFieldOperationDialog.this.myVariableModel.getVariableForLabel(MultiFieldOperationDialog.VALUE_VARIABLE_LABEL);
                if (valueVariable != null) {
                    ValueFieldCompositeObject compositeValueObject = (ValueFieldCompositeObject)valueVariable.getValueObject();
                    Variable indexVariable = MultiFieldOperationDialog.this.myVariableModel.getVariableForKey(MultiFieldOperationDialog.INDEX_VARIABLE_LABEL);
                    if (indexVariable != null) {
                        ValueFieldCompositeObject indexValueObject = FieldOrientedPluginProfileUtil.createValueFieldCompositeObjectForVariable(indexVariable);
                        boolean isMapValueKey = indexVariable instanceof ValueFieldVariable && !((ValueFieldVariable)indexVariable).inFieldMode() && MultiFieldOperationDialog.this.isMapField(valueVariable.getValueString());
                        operand = new ValueFieldCompositeOperand(compositeValueObject, indexValueObject, isMapValueKey);
                    } else {
                        operand = new ValueFieldCompositeOperand(compositeValueObject);
                    }
                }
                MultiFieldOperationDialog.this.myPane.setValue(new SimpleRow(operator, operand));
            } else {
                this.myStatusHandler.beep();
                this.myStatusHandler.printMessage("The incorrect values must be corrected before edit can be finished.");
            }
        }
    }
}

