/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.modifiers.mfo;

import com.ericsson.ere.expression.Function;
import com.ericsson.ere.expression.FunctionParameterInfo;
import java.util.ArrayList;

public class FunctionVariant {
    private Function myFunction;
    private int myParameterCount;

    private FunctionVariant(Function func, int paramCount) {
        this.myFunction = func;
        this.myParameterCount = paramCount;
    }

    public static FunctionVariant[] createVariants(Function function) {
        if (function == null || FunctionVariant.hasVarArgParameter(function)) {
            throw new IllegalArgumentException("Requires non-null function without var-arg parameter.");
        }
        int startCount = FunctionVariant.findLeastParameterCount(function);
        ArrayList<FunctionVariant> variants = new ArrayList<FunctionVariant>();
        for (int i = startCount; i <= function.getParameters().length; ++i) {
            variants.add(new FunctionVariant(function, i));
        }
        return variants.toArray(new FunctionVariant[variants.size()]);
    }

    public static FunctionVariant create(Function function, int paramCount) {
        FunctionVariant[] variants = FunctionVariant.createVariants(function);
        FunctionVariant ret = null;
        for (FunctionVariant v : variants) {
            if (v.getParameterCount() != paramCount) continue;
            ret = v;
            break;
        }
        if (ret == null) {
            throw new IllegalArgumentException("No variant with parameter count " + paramCount + " was found.");
        }
        return ret;
    }

    private static int findLeastParameterCount(Function function) {
        int count;
        FunctionParameterInfo[] parameters = function.getParameters();
        for (count = 0; parameters.length > count && parameters[count].isMandatory(); ++count) {
        }
        return count;
    }

    private static boolean hasVarArgParameter(Function function) {
        FunctionParameterInfo[] parameters = function.getParameters();
        boolean found = false;
        for (FunctionParameterInfo param : parameters) {
            if (!param.isVarArg()) continue;
            found = true;
            break;
        }
        return found;
    }

    public String getSignature() {
        FunctionParameterInfo[] parameters = this.myFunction.getParameters();
        StringBuilder b = new StringBuilder(this.myFunction.getFunctionName());
        b.append("(");
        for (int i = 0; i < this.myParameterCount; ++i) {
            FunctionParameterInfo param = parameters[i];
            if (i > 0) {
                b.append(", ");
            }
            b.append(param.getName());
        }
        b.append(")");
        return b.toString();
    }

    public Function getFunction() {
        return this.myFunction;
    }

    public int getParameterCount() {
        return this.myParameterCount;
    }

    public String toString() {
        return this.getSignature();
    }
}

