/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.modifiers.mfo;

import com.ericsson.ere.expression.AbstractExpressionChecker;
import com.ericsson.ere.expression.ExpressionException;
import com.ericsson.ere.expression.IdentityFunction;
import com.ericsson.ere.expression.IdentityOperator;
import com.ericsson.ere.expression.Operand;
import com.ericsson.ere.expression.OperationRestriction;
import com.ericsson.ere.expression.Operator;
import com.ericsson.ere.selectiontree.modifiers.mfo.ValueFieldCompositeOperand;
import com.ericsson.ere.selectiontree.util.MultipleValueFieldCompositeObject;
import com.ericsson.ere.selectiontree.util.ValueFieldCompositeObject;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.util.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

public class ExpressionValidator
extends AbstractExpressionChecker {
    private static final String RE_NUMERIC = "\\d*(\\.\\d+)?";
    private final ClassRepository myRepository;
    private final Map<Operator, String> myInvalidOperators;
    private final Map<Operand, String> myInvalidOperands;
    private final List<String> myFields;
    private List<DataType> myDataTypes;

    public ExpressionValidator(ClassRepository rep) {
        this(rep, null, null);
    }

    public ExpressionValidator(ClassRepository rep, List<String> allowedFields) {
        this(rep, allowedFields, null);
    }

    public ExpressionValidator(ClassRepository rep, List<String> allowedFields, List<DataType> allowedDataTypes) {
        this(rep, allowedFields, allowedDataTypes, null);
    }

    public ExpressionValidator(ClassRepository rep, List<String> allowedFields, List<DataType> allowedDataTypes, List<? extends OperationRestriction> operationRestrictions) {
        super(operationRestrictions);
        this.myRepository = rep;
        this.myInvalidOperators = new IdentityHashMap<Operator, String>();
        this.myInvalidOperands = new IdentityHashMap<Operand, String>();
        this.myFields = allowedFields == null ? null : new ArrayList<String>(allowedFields);
        this.myDataTypes = allowedDataTypes == null ? null : new ArrayList<DataType>(allowedDataTypes);
    }

    @Override
    protected DataType getOperandDataType(Operand operand) {
        throw new ExpressionException("Unexpected operand: " + operand);
    }

    @Override
    protected void markOperationInvalid(Operator operator, List<Operand> operands, String reason) {
        assert (this.isIdentityOperator(operator)) : "Expected uniquely identifiable operator: " + operator;
        if (!this.myInvalidOperators.containsKey(operator)) {
            this.myInvalidOperators.put(operator, reason);
        }
    }

    private boolean isIdentityOperator(Operator operator) {
        return operator instanceof IdentityOperator || operator instanceof IdentityFunction;
    }

    public Map<Operator, String> getInvalidOperators() {
        return Collections.unmodifiableMap(this.myInvalidOperators);
    }

    public Map<Operand, String> getInvalidOperands() {
        return Collections.unmodifiableMap(this.myInvalidOperands);
    }

    @Override
    protected Operand stubOperand(Operand o) {
        Operand ret;
        block10: {
            ret = null;
            if (o instanceof ValueFieldCompositeOperand) {
                String reason;
                ValueFieldCompositeOperand vo = (ValueFieldCompositeOperand)o;
                ValueFieldCompositeObject value = vo.getValue();
                ValueFieldCompositeObject index = vo.getIndex();
                if (index != null && !(index instanceof MultipleValueFieldCompositeObject)) {
                    try {
                        if (this.getDataTypeForObject(index) == null) {
                            reason = "Invalid index type: " + index.getFieldOrValueAsString();
                            ret = this.createInvalidStub(o, reason);
                        }
                    }
                    catch (MissingFieldException e) {
                        reason = "Invalid index field: " + index.getFieldOrValueAsString();
                        ret = this.createInvalidStub(o, reason);
                    }
                }
                if (ret == null) {
                    try {
                        DataType valueType = this.getDataTypeForObject(value);
                        if (valueType == null) {
                            reason = "Invalid value type: " + value.getFieldOrValueAsString();
                            ret = this.createInvalidStub(o, reason);
                            break block10;
                        }
                        Object v = this.createStubValue(valueType);
                        ret = AbstractExpressionChecker.StubOperand.createValid(v, valueType);
                    }
                    catch (MissingFieldException e) {
                        reason = "Invalid value field: " + value.getFieldOrValueAsString();
                        ret = this.createInvalidStub(o, reason);
                    }
                }
            } else {
                ret = super.stubOperand(o);
            }
        }
        return ret;
    }

    private AbstractExpressionChecker.StubOperand createInvalidStub(Operand o, String reason) {
        this.myInvalidOperands.put(o, reason);
        return AbstractExpressionChecker.StubOperand.createInvalid(reason);
    }

    private DataType getDataTypeForObject(ValueFieldCompositeObject value) {
        DataType ret;
        String fv = value.getFieldOrValueAsString();
        DataType dt = value.getValueDataType();
        if (value.getMode() == ValueFieldCompositeObject.Mode.Field) {
            FieldDefinition fd = this.lookupField(fv);
            if (fd == null) {
                throw new MissingFieldException();
            }
            ret = fd.getTypedDataType();
        } else if (dt != null) {
            ret = dt;
        } else if (this.isNumericString(fv)) {
            ret = DataType.getSmallestDataTypeForNumericValue(fv);
        } else {
            throw new UnsupportedOperationException();
        }
        if (this.myDataTypes != null && !this.myDataTypes.contains(ret)) {
            ret = null;
        }
        return ret;
    }

    private FieldDefinition lookupField(String name) {
        FieldDefinition ret = null;
        if (this.myFields == null || this.myFields.contains(name)) {
            ret = this.myRepository.getFieldDefinitionByName(name);
        }
        return ret;
    }

    private boolean isNumericString(String str) {
        return !StringUtil.isEmptyString(str) && str.matches(RE_NUMERIC);
    }

    private static class MissingFieldException
    extends RuntimeException {
        private MissingFieldException() {
        }
    }
}

