/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.modifiers.mfo;

import com.ericsson.ere.dataset.AbstractDataSet;
import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.expression.ExpressionException;
import com.ericsson.ere.math.RatingDecimal;
import com.ericsson.ere.selectiontree.modifiers.mfo.AbstractDestinationFieldInfo;
import com.ericsson.ere.selectiontree.modifiers.operation.strategy.RangeStrategy;
import com.ericsson.ere.selectiontree.util.AmountUtil;
import com.ericsson.ere.selectiontree.util.FieldIndexKeyContainer;
import ericsson.ere.datatype.Amount;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.FieldDefinition;

public class AmountDestinationFieldInfo
extends AbstractDestinationFieldInfo {
    private boolean myAllowNegativeAmount;

    public AmountDestinationFieldInfo(FieldDefinition field, FieldIndexKeyContainer key) {
        super(field, key, DataType.AMOUNT);
        this.myAllowNegativeAmount = AmountUtil.allowsNegativeAmount(field, true);
    }

    @Override
    public Object convertValue(DataSet dataSet, Object resultValue) {
        Object input = resultValue;
        if (!(input instanceof Amount)) {
            throw new ExpressionException("Incompatible type, expected amount.");
        }
        Amount amount = (Amount)input;
        if (this.hasDisallowedNegativeBalance(amount) && dataSet instanceof AbstractDataSet) {
            RangeStrategy strategy = ((AbstractDataSet)dataSet).getFieldOperationRangeStrategy();
            RatingDecimal newBalance = strategy.calculateResult(amount.getBalance(), null, RatingDecimal.ZERO, DataType.RATINGDECIMAL);
            amount = amount.getAmountFactory().create(newBalance, amount.getCurrency());
        }
        Amount ret = amount;
        return ret;
    }

    private boolean hasDisallowedNegativeBalance(Amount amount) {
        return !this.myAllowNegativeAmount && amount.getBalance().isLessThanZero();
    }
}

