/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.modifiers.mfo;

import com.ericsson.ere.expression.Expression;
import com.ericsson.ere.expression.ExpressionException;
import com.ericsson.ere.expression.ExpressionToken;
import com.ericsson.ere.expression.FormatStringOperand;
import com.ericsson.ere.expression.Function;
import com.ericsson.ere.expression.Functions;
import com.ericsson.ere.expression.Operand;
import com.ericsson.ere.expression.Operator;
import com.ericsson.ere.expression.Operators;
import com.ericsson.ere.expression.Unit;
import com.ericsson.ere.expression.UnitOperand;
import com.ericsson.ere.expression.Units;
import com.ericsson.ere.selectiontree.modifiers.mfo.ExpressionXMLReader;
import ericsson.ere.util.NodeListIterable;
import ericsson.ere.xml.EreXmlException;
import ericsson.ere.xml.XMLUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class AbstractExpressionXMLReader
implements ExpressionXMLReader {
    private static final String CUSTOM_FUNCTION_PREFIX = "$";
    private static final String CUSTOM_OPERATOR_PREFIX = "#";
    private static final ExpressionToken[] TOKENS = new ExpressionToken[]{ExpressionToken.LEFT_PAREN, ExpressionToken.RIGHT_PAREN, ExpressionToken.FUNCTION_ARG_SEPARATOR};
    public static final String TAG_EXPRESSION = "Expression";
    public static final String TAG_OPERATOR = "Operator";
    public static final String TAG_OPERAND = "Operand";
    public static final String TAG_TOKEN = "Token";
    public static final String TAG_SUBEXPR = "SubExpression";
    public static final String TAG_FUNCTION = "Function";
    public static final String TAG_OPERAND_VALUE = "V";
    public static final String TAG_OPERAND_INDEX = "I";
    public static final String ATTR_EXPRESSION_NOTATION = "notation";
    public static final String ATTR_TOKEN_NAME = "name";
    public static final String ATTR_FUNCTION_NAME = "name";
    public static final String ATTR_OPERATOR_NAME = "name";
    public static final String ATTR_OPERAND_UNIT = "unit";
    public static final String ATTR_OPERAND_FORMAT = "format";
    public static final String ATTR_OPERAND_LOCALE = "locale";

    @Override
    public Expression read(Node xml) {
        this.checkNode(xml);
        Expression.ExpressionNotation notation = this.readNotation((Element)xml);
        List<ExpressionToken> tokens = this.readTokens((Element)xml);
        return new Expression(tokens, notation);
    }

    private void checkNode(Node xml) {
        Schema schema;
        if (xml == null) {
            throw new IllegalArgumentException("XML node is null.");
        }
        if (!TAG_EXPRESSION.equals(xml.getNodeName())) {
            throw new EreXmlException("Initializing from non-Expression node: " + xml.getNodeName());
        }
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            InputStream is = AbstractExpressionXMLReader.class.getResourceAsStream("mfo-expression-schema.xsd");
            assert (is != null) : "Failed to get schema from resource.";
            schema = factory.newSchema(new StreamSource(is));
        }
        catch (SAXException e) {
            throw new AssertionError((Object)e);
        }
        Validator validator = schema.newValidator();
        try {
            validator.validate(new DOMSource(xml));
        }
        catch (SAXException e) {
            throw new EreXmlException("Invalid XML.", e);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    private Expression.ExpressionNotation readNotation(Element xml) {
        String notation = xml.getAttribute(ATTR_EXPRESSION_NOTATION);
        return Expression.ExpressionNotation.valueOf(notation);
    }

    private List<ExpressionToken> readTokens(Element xml) {
        NodeList children = xml.getChildNodes();
        ArrayList<ExpressionToken> tokens = new ArrayList<ExpressionToken>(children.getLength());
        for (Node child : new NodeListIterable(children, 1)) {
            ExpressionToken token;
            Element echild = (Element)child;
            String name = child.getNodeName();
            if (TAG_OPERATOR.equals(name)) {
                token = this.readOperator(echild);
            } else if (TAG_OPERAND.equals(name)) {
                token = this.readOperand(echild);
            } else if (TAG_TOKEN.equals(name)) {
                token = this.readToken(echild);
            } else if (TAG_SUBEXPR.equals(name)) {
                tokens.add(ExpressionToken.LEFT_PAREN);
                tokens.addAll(this.readTokens((Element)child));
                token = ExpressionToken.RIGHT_PAREN;
            } else if (TAG_FUNCTION.equals(name)) {
                token = this.readFunction(echild);
            } else {
                throw new AssertionError((Object)("Unhandled expression token type: " + name));
            }
            if (token == null) {
                throw new AssertionError((Object)("Failed to read an expression token, element name = '" + name + "'"));
            }
            tokens.add(token);
        }
        return tokens;
    }

    private Function readFunction(Element function) {
        String name = function.getAttribute("name");
        Function f = this.findFunctionByName(name);
        if (f == null) {
            throw new ExpressionException("Unknown function: " + name);
        }
        return f;
    }

    private Operator readOperator(Element operator) {
        String name = operator.getAttribute("name");
        Operator o = this.findOperatorByName(name);
        if (o == null) {
            throw new ExpressionException("Unknown operator: " + name);
        }
        return o;
    }

    protected Function findFunctionByName(String name) {
        if (name.startsWith(CUSTOM_FUNCTION_PREFIX)) {
            return this.findCustomFunctionByName(name.substring(1));
        }
        return Functions.getFunctionByName(name);
    }

    protected Function findCustomFunctionByName(String name) {
        return null;
    }

    protected Operator findOperatorByName(String name) {
        if (name.startsWith(CUSTOM_OPERATOR_PREFIX)) {
            return this.findCustomOperatorByName(name.substring(1));
        }
        return Operators.getOperatorByName(name);
    }

    protected Operator findCustomOperatorByName(String name) {
        return null;
    }

    protected Operand readOperand(Element operand) {
        String unitName = null;
        if (operand.hasAttribute(ATTR_OPERAND_UNIT)) {
            unitName = operand.getAttribute(ATTR_OPERAND_UNIT);
        }
        String formatString = null;
        if (operand.hasAttribute(ATTR_OPERAND_FORMAT)) {
            if (unitName != null) {
                throw new EreXmlException("Invalid XML: cannot combine 'format' and 'unit' Operand attributes.");
            }
            formatString = operand.getAttribute(ATTR_OPERAND_FORMAT);
        }
        String localeString = null;
        if (operand.hasAttribute(ATTR_OPERAND_LOCALE)) {
            if (formatString == null) {
                throw new EreXmlException("Invalid XML: the 'locale' Operand attribute can only be used together with the 'format' attribute.");
            }
            localeString = operand.getAttribute(ATTR_OPERAND_LOCALE);
        }
        Element value = XMLUtil.getFirstElementNamed(TAG_OPERAND_VALUE, operand);
        Element index = XMLUtil.getFirstElementNamed(TAG_OPERAND_INDEX, operand);
        if (value == null) {
            throw new EreXmlException("Missing operand value.");
        }
        Operand op = this.readOperand(value, index);
        if (unitName != null) {
            Unit unit = this.findUnitByName(unitName);
            if (unit == null) {
                throw new EreXmlException("Unknown unit: " + unitName);
            }
            op = UnitOperand.create(op, unit);
        } else if (formatString != null) {
            try {
                op = FormatStringOperand.create(op, formatString, localeString);
            }
            catch (IllegalArgumentException e) {
                throw new EreXmlException(e.getMessage(), e);
            }
        }
        return op;
    }

    protected Unit findUnitByName(String unitName) {
        return Units.getUnitByName(unitName);
    }

    protected abstract Operand readOperand(Element var1, Element var2);

    protected ExpressionToken readToken(Element token) {
        String name = token.getAttribute("name");
        for (ExpressionToken t : TOKENS) {
            if (!t.toString().equals(name)) continue;
            return t;
        }
        return null;
    }

    protected Element getFirstChildElement(Element parent) {
        return (Element)XMLUtil.getElementChildren(parent).get(0);
    }
}

