/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.modifiers.jump;

import com.ericsson.ere.dataset.jump.JumperSupport;
import com.ericsson.ere.dataset.jump.SelectionTreeDestination;
import com.ericsson.ere.selectiontree.modifiers.AbstractModifierProfile;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.gui.util.GuiUtil;
import ericsson.ere.xml.XMLUtil;
import ericsson.vareditor.variable.DropDownVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class GoToModifierProfile
extends AbstractModifierProfile {
    private static String LBL_GOTO = "Goto";
    private ClassRepository myClassRep;

    @Override
    public List<Variable> getVariables() {
        ArrayList<Variable> l = new ArrayList<Variable>();
        List<SelectionTreeDestination> availableGoToTreeChoices = this.getAvailableGoToTreeChoices();
        Object[] choices = availableGoToTreeChoices.toArray();
        l.add(new DropDownVariable(LBL_GOTO, choices[0], choices));
        return l;
    }

    @Override
    public List<Variable> getVariables(Node iterator) {
        ArrayList<Variable> l = new ArrayList<Variable>();
        Element goToNode = XMLUtil.getNamedElement("GoTo", iterator.getChildNodes());
        SelectionTreeDestination destination = new SelectionTreeDestination(goToNode);
        List<SelectionTreeDestination> availableGoToTreeChoices = this.getAvailableGoToTreeChoices();
        Object[] choices = availableGoToTreeChoices.toArray();
        l.add(new DropDownVariable(LBL_GOTO, destination, choices));
        return l;
    }

    @Override
    public String getAdditionalInfo(List<Variable> variables) {
        String info = "<b>" + this.getName() + "</b>";
        String destination = VarListUtil.getValueStringForName(variables, LBL_GOTO);
        info = info + " (" + destination + ")\n" + this.getComment(variables);
        return GuiUtil.multilineTooltipWrapper(info);
    }

    @Override
    public String getDescription(List<Variable> variables) {
        String name = VarListUtil.getValueStringForName(variables, "Name");
        String destination = VarListUtil.getValueStringForName(variables, LBL_GOTO);
        return name + " " + destination;
    }

    @Override
    public void printParametersImpl(PrintWriter out, int indentLevel, String indentMarker, List<Variable> variables) {
        SelectionTreeDestination goToTree = (SelectionTreeDestination)VarListUtil.getValueForName(variables, LBL_GOTO);
        for (int i = 0; i < indentLevel + 1; ++i) {
            out.print(indentMarker);
        }
        out.println(goToTree.getXmlTag());
    }

    private List<SelectionTreeDestination> getAvailableGoToTreeChoices() {
        ArrayList<SelectionTreeDestination> subTrees = new ArrayList<SelectionTreeDestination>();
        JumperSupport theJumperSupport = this.myClassRep.getJumperSupport();
        if (theJumperSupport != null) {
            subTrees = theJumperSupport.getSelectionTreeDestinationsForService(this.myClassRep.getServiceName());
        }
        subTrees.add(0, new SelectionTreeDestination("", "", ""));
        return subTrees;
    }

    @Override
    public boolean needsRepository() {
        return true;
    }

    @Override
    public void setClassRepository(ClassRepository repository) {
        this.myClassRep = repository;
    }
}

