/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.modifiers;

import com.ericsson.ere.annotations.jcip.Immutable;
import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.dataset.DataSetField;
import com.ericsson.ere.datatype.ERETime;
import com.ericsson.ere.datatype.ERETimeFactory;
import com.ericsson.ere.selectiontree.ParseContext;
import com.ericsson.ere.selectiontree.modifiers.AbstractSetFieldModifier;
import com.ericsson.ere.selectiontree.util.FieldIndexKeyContainer;
import com.ericsson.ere.trace.PluginTraceHelper;
import com.ericsson.ere.trace.TracePoint;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.interfaces.TariffStructureNode;
import ericsson.ere.xml.XMLUtil;
import org.w3c.dom.Element;

@Immutable
public final class SetTimeFieldModifier
extends AbstractSetFieldModifier<ERETime> {
    private static final String BUILTINFLD_CURRENTTIME = "CurrentTime()";
    private static final String BUILTINFLD_STARTTIME = "StartTime()";
    private final boolean myUseStartTime;
    private final boolean myUseCurrentTime;

    private SetTimeFieldModifier(ParseContext ctx) {
        super(ctx, DataType.TIME);
        Element copyFromElement = XMLUtil.getNamedElement("CopyFrom", ctx.getXMLNode().getChildNodes());
        String sourceFieldName = "";
        if (copyFromElement != null) {
            sourceFieldName = XMLUtil.getFirstTextContent(copyFromElement);
        }
        this.myUseCurrentTime = BUILTINFLD_CURRENTTIME.equals(sourceFieldName);
        this.myUseStartTime = BUILTINFLD_STARTTIME.equals(sourceFieldName);
    }

    public static SetTimeFieldModifier create(ParseContext ctx, TariffStructureNode[] notUsed) {
        return new SetTimeFieldModifier(ctx);
    }

    @Override
    protected ERETime fetchSpecialValue(DataSet dataSet) {
        ERETime value = null;
        if (this.myUseCurrentTime) {
            value = ERETimeFactory.createFromCalendar(dataSet.getCurrentTime());
        } else if (this.myUseStartTime) {
            value = ERETimeFactory.createFromCalendar(dataSet.getStartTime());
        }
        return value;
    }

    @Override
    public boolean shallCopyFromField() {
        return super.shallCopyFromField() || this.myUseCurrentTime || this.myUseStartTime;
    }

    @Override
    protected String makeDisplayableValueString(FieldDefinition associatedField, Object value) {
        if (this.myUseCurrentTime || this.myUseStartTime) {
            return DataType.TIME.makeDisplayString(value);
        }
        return super.makeDisplayableValueString(associatedField, value);
    }

    @Override
    protected String describeSourceField(DataSet dataset, DataSetField field, FieldIndexKeyContainer index) {
        String name = this.myUseCurrentTime ? BUILTINFLD_CURRENTTIME : (this.myUseStartTime ? BUILTINFLD_STARTTIME : super.describeSourceField(dataset, field, index));
        return name;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.myUseCurrentTime ? 1231 : 1237);
        result = 31 * result + (this.myUseStartTime ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SetTimeFieldModifier other = (SetTimeFieldModifier)obj;
        if (this.myUseCurrentTime != other.myUseCurrentTime) {
            return false;
        }
        return this.myUseStartTime == other.myUseStartTime;
    }

    @Override
    public void setPreTracePointInfo(TracePoint tp) {
        super.setPreTracePointInfo(tp);
        if (this.myUseCurrentTime) {
            PluginTraceHelper.storeCurrentTimeAsPreDataInTracePoint(tp);
        }
    }
}

