/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.modifiers;

import com.ericsson.ere.constraint.ConstraintService;
import com.ericsson.ere.constraint.LegacyAutoConditionMapProfile;
import com.ericsson.ere.constraint.contract.Constrainable;
import com.ericsson.ere.constraint.entity.ConstraintContext;
import com.ericsson.ere.constraint.entity.ConstraintContextItemType;
import com.ericsson.ere.defs.DataTypeCompatibilityStrategy;
import com.ericsson.ere.selectiontree.FieldFilter;
import com.ericsson.ere.selectiontree.HierarchicalFieldFilter;
import com.ericsson.ere.selectiontree.modifiers.AbstractFieldOrientedModifierProfile;
import com.ericsson.ere.selectiontree.modifiers.SetFieldModifierProfileContract;
import com.ericsson.ere.selectiontree.util.AvailableFieldListBuilder;
import com.ericsson.ere.selectiontree.util.ClassRepositoryHelper;
import com.ericsson.ere.selectiontree.util.FieldListBuilderWithLegacySupport;
import com.ericsson.ere.selectiontree.util.FieldOrientedPluginProfileUtil;
import com.ericsson.ere.selectiontree.util.FieldOrientedPluginUtil;
import com.ericsson.ere.selectiontree.util.ValueFieldCompositeObject;
import com.ericsson.ere.util.FieldDefinitionUtil;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.defs.FieldStructure;
import ericsson.ere.gui.util.GuiUtil;
import ericsson.ere.gui.util.IndexVariableFactory;
import ericsson.ere.interfaces.FieldHierarchyNode;
import ericsson.ere.xml.XMLUtil;
import ericsson.vareditor.variable.BoolVariable;
import ericsson.vareditor.variable.InfoVariable;
import ericsson.vareditor.variable.LazyFieldDropDownVariable;
import ericsson.vareditor.variable.NotAllowedVariable;
import ericsson.vareditor.variable.StringVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import ericsson.vareditor.variable.treedefinedfields.TreeDefinedFieldHelper;
import java.awt.Color;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Constrainable(contractClass=SetFieldModifierProfileContract.class)
@LegacyAutoConditionMapProfile
public class SetFieldModifierProfile
extends AbstractFieldOrientedModifierProfile {
    private static final String LBL_WARNING = "Warning";
    private static final String LBL_FIELD = "Field";
    private static final String LBL_FIELD_INDEX = "Field index";
    private static final String LBL_DO_COPY_FROM_FIELD = "Copy from field";
    private static final String LBL_VALUE = "Set value";
    private static final String LBL_FIELD_TO_COPY_FROM = "Field to copy from";
    private static final String LBL_FIELD_TO_COPY_FROM_INDEX = "Field to copy from index";
    private static final String MSG_NO_FIELDS_EXISTS = "No available fields found";
    private static final String MSG_WARNING_WIDTH = "The source field has a wider data type than the destination field! This may affect tree execution.";
    private static final String ARRAY_MAP_SUPPORT_FEATURE = "Array_Map_Support";
    private static final String DATASET_TIME_FIELD_SUPPORT_FEATURE = "DataSet_Time_field_Support";
    private static final String DATE_TIME_INTEROPERABILITY_FEATURE = "Date_Time_Interoperability_Support";
    private static final String MSG_WARNING_TIME_TO_DATE = "Assigning from TIME to DATE will discard the hh/mm/ss part in the destination field!";
    private TreeDefinedFieldHelper myTreeDefinedFieldsHelper;
    private boolean mySupportArrayMap = false;
    private boolean mySupportDataSetTimeField = false;
    private boolean mySupportDateTimeInteroperability = false;
    private static DataTypeCompatibilityStrategy myDefaultDataTypeCompatibilityStrategy = new DefaultDataTypeCompatibilityStrategy();

    private Variable getWarningVariable(String aWarning) {
        InfoVariable var = new InfoVariable(LBL_WARNING, aWarning);
        JComponent editor = (JComponent)((Variable)var).getEditor();
        editor.setForeground(Color.red);
        editor.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        return var;
    }

    @Override
    public List<Variable> getVariables() {
        ArrayList<Variable> varList = new ArrayList<Variable>(3);
        Variable fieldsDropDown = this.createFieldsDropDown("", this.createTargetListBuilder(), LBL_FIELD);
        varList.add(fieldsDropDown);
        String destinationFieldName = this.extractSelectedField(fieldsDropDown);
        this.addIndexVariable(LBL_FIELD_INDEX, LBL_FIELD_INDEX, destinationFieldName, null, varList, this.createIndexVariableFactory(true));
        BoolVariable copyFromField = new BoolVariable(LBL_DO_COPY_FROM_FIELD, false);
        copyFromField.setAllowEdit(destinationFieldName != null);
        varList.add(copyFromField);
        varList.add(this.createInputValueVariableWithSimData(destinationFieldName));
        return varList;
    }

    private String extractSelectedField(Variable variable) {
        if (variable instanceof NotAllowedVariable) {
            return null;
        }
        return variable.getValueString();
    }

    @Override
    public List<Variable> getVariables(Node iterator) {
        ArrayList<Variable> l = new ArrayList<Variable>(3);
        String sourceField = "";
        NodeList children = iterator.getChildNodes();
        Element nameNode = XMLUtil.getNamedElement("TreeDefinedField", children);
        String destinationFieldName = XMLUtil.getFirstTextContent(nameNode);
        Element valueNode = XMLUtil.getNamedElement("Value", children);
        String valueToSet = XMLUtil.getFirstTextContent(valueNode);
        Element copyFromFieldNode = XMLUtil.getNamedElement("CopyFrom", children);
        if (copyFromFieldNode != null) {
            sourceField = XMLUtil.getFirstTextContent(copyFromFieldNode).trim();
        }
        boolean shallCopyFromField = !sourceField.isEmpty();
        Variable fieldsDropDown = this.createFieldsDropDown(destinationFieldName, this.createTargetListBuilder(), LBL_FIELD);
        l.add(fieldsDropDown);
        Element destinationFieldIndexElement = XMLUtil.getFirstElementNamed("Index", nameNode);
        this.addIndexVariable(LBL_FIELD_INDEX, LBL_FIELD_INDEX, destinationFieldName, destinationFieldIndexElement, l, this.createIndexVariableFactory(true));
        BoolVariable copyFromFieldVar = new BoolVariable(LBL_DO_COPY_FROM_FIELD, shallCopyFromField);
        l.add(copyFromFieldVar);
        if (shallCopyFromField) {
            l.add(this.createCopyFromFieldDropDown(destinationFieldName, sourceField));
            Element sourceFieldIndexElement = XMLUtil.getFirstElementNamed("Index", copyFromFieldNode);
            this.addIndexVariable(LBL_FIELD_TO_COPY_FROM_INDEX, LBL_FIELD_TO_COPY_FROM_INDEX, sourceField, sourceFieldIndexElement, l, this.createIndexVariableFactory(false));
            if (this.isSourceFieldWider(destinationFieldName, sourceField)) {
                l.add(this.getWarningVariable(MSG_WARNING_WIDTH));
            } else if (this.isAssignmentFromTimeToDate(destinationFieldName, sourceField)) {
                l.add(this.getWarningVariable(MSG_WARNING_TIME_TO_DATE));
            }
        } else {
            Variable valueVar = this.createInputValueVariableWithSimData(destinationFieldName);
            valueVar.setValue(valueToSet);
            valueVar.setAllowEdit(fieldsDropDown.isValueValid());
            copyFromFieldVar.setAllowEdit(fieldsDropDown.isValueValid());
            l.add(valueVar);
        }
        return l;
    }

    private AvailableFieldListBuilder createTargetListBuilder() {
        AvailableFieldListBuilder builder = AvailableFieldListBuilder.createAvailableFieldListBuilder(this.myClassRepository).withHierarchicalFields().withConstraints(this, null).withFilter(new TargetHierarchicalFieldFilter());
        return builder;
    }

    private boolean isComplexFieldInComplexFieldStructure(FieldDefinition field) {
        return field.getComplexType() != FieldHierarchyNode.ComplexType.NONE && field.getParent() != null && field.getParent().getComplexType() != FieldHierarchyNode.ComplexType.NONE;
    }

    private AvailableFieldListBuilder createSourceFieldListBuilder(String destField, String sourceField) {
        ConstraintContext context = new ConstraintContext.Builder().addContext(ConstraintContextItemType.FIELD, destField).build();
        FieldDefinition field = this.myClassRepository.getFieldDefinitionByName(destField);
        FieldListBuilderWithLegacySupport builder = new FieldListBuilderWithLegacySupport(this.myClassRepository);
        builder.withLegacyField(this.myClassRepository.getFieldDefinitionByName(sourceField));
        builder.withHierarchicalFields();
        builder.withFilter(new SourceHierarchicalFieldFilter(field)).withConstraints(this, context);
        DataTypeCompatibilityStrategy strategy = this.getDataTypeCompatibilityStrategy();
        if (strategy == null) {
            strategy = myDefaultDataTypeCompatibilityStrategy;
        }
        builder.withFilter(new SourceFieldFilter(field, strategy));
        builder.withFilter(new DateTimeInteropFilter(field));
        builder.withAdditionalFields(this.getBuiltInFieldsIfDateAndFeatureActive(destField));
        return builder;
    }

    private List<FieldHierarchyNode> getBuiltInFieldsIfDateAndFeatureActive(String destinationFieldName) {
        ArrayList<FieldHierarchyNode> additions = new ArrayList<FieldHierarchyNode>();
        FieldDefinition destinationField = this.myClassRepository.getFieldDefinitionByName(destinationFieldName);
        if (destinationField != null && this.mySupportDataSetTimeField && (DataType.DATE == destinationField.getTypedDataType() || DataType.TIME == destinationField.getTypedDataType())) {
            additions.add(ClassRepositoryHelper.SPECIAL_FIELD_CURRENT_TIME);
            additions.add(ClassRepositoryHelper.SPECIAL_FIELD_START_TIME);
        }
        return additions;
    }

    static List<FieldDefinition> getSupportedDestinationFieldList(ClassRepository repository) {
        return SetFieldModifierProfile.getSupportedFields(ClassRepositoryHelper.extractVisibleFields(repository), new DestinationFieldFilter());
    }

    static List<FieldDefinition> getSupportedSourceFieldList(ClassRepository repository, String destinationFieldName, DataTypeCompatibilityStrategy compatibilityStrategy) {
        FieldDefinition destinationField = repository.getFieldDefinitionByName(destinationFieldName);
        List<FieldDefinition> candidateFieldList = destinationField != null ? SetFieldModifierProfile.getSupportedFields(ClassRepositoryHelper.extractVisibleFieldsForField(destinationFieldName, repository), new SourceFieldFilter(destinationField, compatibilityStrategy)) : SetFieldModifierProfile.getSupportedFields(ClassRepositoryHelper.extractVisibleFields(repository), new FieldOrientedFieldFilter());
        return candidateFieldList;
    }

    private Variable createFieldsDropDown(String selectedFieldName, AvailableFieldListBuilder builder, String label) {
        if (!builder.filtersAllow(this.myClassRepository.getFieldDefinitionByName(selectedFieldName))) {
            List<FieldHierarchyNode> fields = builder.buildList();
            if (fields.isEmpty() && "".equals(selectedFieldName)) {
                return new NotAllowedVariable(label, MSG_NO_FIELDS_EXISTS);
            }
            String name = "".equals(selectedFieldName) ? fields.get(0).getCanonicalName() : selectedFieldName;
            return FieldOrientedPluginProfileUtil.createFilterableFieldListVariable(label, label, fields, name);
        }
        return new LazyFieldDropDownVariable(label, builder, selectedFieldName);
    }

    private static boolean compatibleDataTypes(DataType to, DataType from, DataTypeCompatibilityStrategy dataTypeCompatibilityStrategy) {
        boolean isSupportedByDefault = myDefaultDataTypeCompatibilityStrategy.areDataTypesAssignmentCompatible(to, from);
        if (isSupportedByDefault && dataTypeCompatibilityStrategy != null) {
            return dataTypeCompatibilityStrategy.areDataTypesAssignmentCompatible(to, from);
        }
        return isSupportedByDefault;
    }

    private Variable createCopyFromFieldDropDown(String destField, String selectedSourceFieldName) {
        FieldHierarchyNode sourceField;
        AvailableFieldListBuilder builder = this.createSourceFieldListBuilder(destField, selectedSourceFieldName);
        if (!builder.filtersAllow(sourceField = this.myClassRepository.getFieldRepository().getFieldByName(selectedSourceFieldName))) {
            List<FieldHierarchyNode> list = builder.buildList();
            if (list.isEmpty() && "".equals(selectedSourceFieldName)) {
                return new NotAllowedVariable(LBL_FIELD_TO_COPY_FROM, MSG_NO_FIELDS_EXISTS);
            }
            String name = "".equals(selectedSourceFieldName) ? list.get(0).getCanonicalName() : selectedSourceFieldName;
            return FieldOrientedPluginProfileUtil.createFilterableFieldListVariable(LBL_FIELD_TO_COPY_FROM, LBL_FIELD_TO_COPY_FROM, list, name);
        }
        return new LazyFieldDropDownVariable(LBL_FIELD_TO_COPY_FROM, builder, selectedSourceFieldName);
    }

    private boolean isSourceFieldWider(String destField, String sourceField) {
        DataType destDT = DataType.lookup(this.myTreeDefinedFieldsHelper.getDataTypeAsInClassRepository(destField));
        DataType sourceDT = DataType.lookup(this.myTreeDefinedFieldsHelper.getDataTypeAsInClassRepository(sourceField));
        if (destDT == null || sourceDT == null) {
            return false;
        }
        return destDT.isIntegerNumeric() && sourceDT.isIntegerNumeric() && sourceDT.bitSize() > destDT.bitSize();
    }

    private boolean isAssignmentFromTimeToDate(String destField, String sourceField) {
        DataType destDT = DataType.lookup(this.myTreeDefinedFieldsHelper.getDataTypeAsInClassRepository(destField));
        DataType sourceDT = DataType.lookup(this.myTreeDefinedFieldsHelper.getDataTypeAsInClassRepository(sourceField));
        if (destDT == null || sourceDT == null) {
            return false;
        }
        return destDT == DataType.DATE && sourceDT == DataType.TIME;
    }

    @Override
    public void setClassRepository(ClassRepository repository) {
        super.setClassRepository(repository);
        this.myTreeDefinedFieldsHelper = new TreeDefinedFieldHelper(repository);
        this.checkFeaturesViaClassRepository(repository);
    }

    private void checkFeaturesViaClassRepository(ClassRepository repository) {
        List<String> enabledFeatures = ConstraintService.constrainFeatures(this, repository, SetFieldModifierProfile.getSupportedFeatures());
        this.mySupportArrayMap = enabledFeatures.contains(ARRAY_MAP_SUPPORT_FEATURE);
        this.mySupportDataSetTimeField = enabledFeatures.contains(DATASET_TIME_FIELD_SUPPORT_FEATURE);
        this.mySupportDateTimeInteroperability = enabledFeatures.contains(DATE_TIME_INTEROPERABILITY_FEATURE);
    }

    @Override
    public void printParametersImpl(PrintWriter out, int indentLevel, String indentMarker, List<Variable> variables) {
        String name;
        String[] tdfs = new String[2];
        int tdf_idx = 0;
        boolean shallCopyFromField = VarListUtil.getBooleanValueForName(variables, LBL_DO_COPY_FROM_FIELD);
        String value = VarListUtil.getValueStringForName(variables, LBL_VALUE);
        if (value == null) {
            value = "";
        }
        if ((name = VarListUtil.getValueStringForName(variables, LBL_FIELD)) == null || name.equals(MSG_NO_FIELDS_EXISTS)) {
            name = "";
        } else if (this.myTreeDefinedFieldsHelper.checkIfFieldIsTreeDefinedField(name)) {
            tdfs[tdf_idx++] = name;
        }
        ValueFieldCompositeObject destinationFieldIndexObject = this.createObjectForIndexVariable(VarListUtil.getVariableForKey(variables, LBL_FIELD_INDEX));
        ValueFieldCompositeObject sourceFieldIndexObject = null;
        String fieldToCopyFrom = "";
        if (shallCopyFromField) {
            fieldToCopyFrom = VarListUtil.getValueStringForName(variables, LBL_FIELD_TO_COPY_FROM);
            if (this.myTreeDefinedFieldsHelper.checkIfFieldIsTreeDefinedField(fieldToCopyFrom)) {
                tdfs[tdf_idx++] = fieldToCopyFrom;
            }
            sourceFieldIndexObject = this.createObjectForIndexVariable(VarListUtil.getVariableForKey(variables, LBL_FIELD_TO_COPY_FROM_INDEX));
        }
        StringBuilder indentBuilder = new StringBuilder();
        for (int i = 0; i < indentLevel + 1; ++i) {
            indentBuilder.append(indentMarker);
        }
        String reusedIndentString = indentBuilder.toString();
        String destinationFieldTag = this.createDestinationFieldTag(name, destinationFieldIndexObject, reusedIndentString, indentMarker);
        out.println(destinationFieldTag);
        String sourcetagField = this.createSourceFieldTag(fieldToCopyFrom, sourceFieldIndexObject, reusedIndentString, indentMarker);
        out.println(sourcetagField);
        out.println(reusedIndentString + "<" + "Value" + ">" + XMLUtil.escape(value) + "</" + "Value" + ">");
    }

    private String createSourceFieldTag(String fieldToCopyFrom, ValueFieldCompositeObject sourceFieldIndexObject, String reusedIndentString, String indentMarker) {
        StringBuilder destinationFieldTag = new StringBuilder();
        destinationFieldTag.append(reusedIndentString);
        destinationFieldTag.append("<");
        destinationFieldTag.append("CopyFrom");
        destinationFieldTag.append(">");
        destinationFieldTag.append(fieldToCopyFrom);
        if (sourceFieldIndexObject != null) {
            destinationFieldTag.append("\n");
            destinationFieldTag.append(reusedIndentString);
            destinationFieldTag.append(indentMarker);
            destinationFieldTag.append("<Index>");
            destinationFieldTag.append(sourceFieldIndexObject.getXMLRepresentation());
            destinationFieldTag.append("</Index>\n");
            destinationFieldTag.append(reusedIndentString);
        }
        destinationFieldTag.append("</");
        destinationFieldTag.append("CopyFrom");
        destinationFieldTag.append(">");
        return destinationFieldTag.toString();
    }

    private String createDestinationFieldTag(String name, ValueFieldCompositeObject destinationFieldIndexObject, String reusedIndentString, String indentMarker) {
        StringBuilder destinationFieldTag = new StringBuilder();
        destinationFieldTag.append(reusedIndentString);
        destinationFieldTag.append("<");
        destinationFieldTag.append("TreeDefinedField");
        destinationFieldTag.append(">");
        destinationFieldTag.append(name);
        if (destinationFieldIndexObject != null) {
            destinationFieldTag.append("\n");
            destinationFieldTag.append(reusedIndentString);
            destinationFieldTag.append(indentMarker);
            destinationFieldTag.append("<Index>");
            destinationFieldTag.append(destinationFieldIndexObject.getXMLRepresentation());
            destinationFieldTag.append("</Index>\n");
            destinationFieldTag.append(reusedIndentString);
        }
        destinationFieldTag.append("</");
        destinationFieldTag.append("TreeDefinedField");
        destinationFieldTag.append(">");
        return destinationFieldTag.toString();
    }

    @Override
    public String getDescription(List<Variable> variables) {
        boolean destinationFieldExistsInService;
        String destinationFieldName;
        Variable fieldVariable = VarListUtil.getVariableForName(variables, LBL_FIELD);
        StringBuilder builder = new StringBuilder();
        builder.append(super.getDescription(variables));
        builder.append(" (");
        if (fieldVariable instanceof NotAllowedVariable) {
            builder.append(MSG_NO_FIELDS_EXISTS);
            return builder.append(")").toString();
        }
        String destinationFieldNameAndMaybeKey = destinationFieldName = fieldVariable.getValueString();
        FieldDefinition destinationFieldDefinition = this.myClassRepository.getFieldDefinitionByName(destinationFieldName);
        boolean bl = destinationFieldExistsInService = destinationFieldDefinition != null;
        if (destinationFieldExistsInService) {
            destinationFieldNameAndMaybeKey = this.createFieldStringWithIndexIfPresent(destinationFieldName, LBL_FIELD_INDEX, variables);
        }
        builder.append(destinationFieldNameAndMaybeKey);
        builder.append(" = ");
        Boolean copyFromField = VarListUtil.getBooleanValueForName(variables, LBL_DO_COPY_FROM_FIELD);
        if (copyFromField.booleanValue()) {
            String fieldToCopyFrom = VarListUtil.getValueStringForName(variables, LBL_FIELD_TO_COPY_FROM);
            String sourceFieldNameAndMaybeKey = this.createFieldStringWithIndexIfPresent(fieldToCopyFrom, LBL_FIELD_TO_COPY_FROM_INDEX, variables);
            builder.append(sourceFieldNameAndMaybeKey);
        } else {
            Variable var = VarListUtil.getVariableForName(variables, LBL_VALUE);
            String value = FieldOrientedPluginProfileUtil.describeValueForField(var, this.myClassRepository, destinationFieldDefinition, true);
            builder.append(value);
        }
        return builder.append(")").toString();
    }

    private String createFieldStringWithIndexIfPresent(String fieldName, String keyVariableLabel, List<Variable> variables) {
        String text = "";
        if (SetFieldModifierProfile.isBuiltInTimeField(fieldName)) {
            return fieldName;
        }
        FieldDefinition fieldDefinition = this.myClassRepository.getFieldDefinitionByName(fieldName);
        if (fieldDefinition != null) {
            ValueFieldCompositeObject vfco = FieldOrientedPluginProfileUtil.createValueFieldCompositeObjectForVariable(VarListUtil.getVariableForKey(variables, keyVariableLabel));
            text = FieldOrientedPluginProfileUtil.formatFieldNameStringWithIndexOrKeyIfPresent(fieldDefinition, vfco, this.myClassRepository);
        }
        return text;
    }

    private static boolean isBuiltInTimeField(String fieldName) {
        return "CurrentTime()".equals(fieldName) || "StartTime()".equals(fieldName);
    }

    @Override
    public String getAdditionalInfo(List<Variable> variables) {
        String desc = this.getDescription(variables);
        return GuiUtil.descriptionToTooltip(desc, this.getName(), this.getComment(variables));
    }

    @Override
    public boolean parameterChanged(String reference, Variable value, List<Variable> vars) {
        if (this.isParameterCandidateForChange(reference)) {
            String destinationField = VarListUtil.getValueStringForName(vars, LBL_FIELD);
            Boolean useCopyField = VarListUtil.getVariableForName(vars, LBL_DO_COPY_FROM_FIELD) != null ? VarListUtil.getBooleanValueForName(vars, LBL_DO_COPY_FROM_FIELD) : null;
            boolean hasChanged = false;
            if (LBL_FIELD.equals(reference)) {
                this.removeVariablesAfter(value, vars);
                hasChanged = true;
                this.addIndexVariable(LBL_FIELD_INDEX, LBL_FIELD_INDEX, value.getValueString(), null, vars, this.createIndexVariableFactory(true));
                vars.add(new BoolVariable(LBL_DO_COPY_FROM_FIELD, useCopyField));
            }
            if (LBL_DO_COPY_FROM_FIELD.equals(reference) || hasChanged) {
                if (!hasChanged) {
                    this.removeVariablesAfter(value, vars);
                    hasChanged = true;
                }
                if (useCopyField.booleanValue()) {
                    Variable cfvar = this.createCopyFromFieldDropDown(destinationField, "");
                    vars.add(cfvar);
                } else {
                    vars.add(this.createInputValueVariableWithSimData(destinationField));
                }
            }
            if (LBL_FIELD_TO_COPY_FROM.equals(reference) || hasChanged) {
                String sourceField;
                if (!hasChanged) {
                    this.removeVariablesAfter(value, vars);
                    hasChanged = true;
                }
                if ((sourceField = VarListUtil.getValueStringForName(vars, LBL_FIELD_TO_COPY_FROM)) != null) {
                    this.addIndexVariable(LBL_FIELD_TO_COPY_FROM_INDEX, LBL_FIELD_TO_COPY_FROM_INDEX, sourceField, null, vars, this.createIndexVariableFactory(false));
                    if (this.isSourceFieldWider(destinationField, sourceField)) {
                        vars.add(this.getWarningVariable(MSG_WARNING_WIDTH));
                    } else if (this.isAssignmentFromTimeToDate(destinationField, sourceField)) {
                        vars.add(this.getWarningVariable(MSG_WARNING_TIME_TO_DATE));
                    }
                }
            }
            return hasChanged;
        }
        return false;
    }

    private void removeVariablesAfter(Variable value, List<Variable> vars) {
        while (vars.size() > 0 && vars.get(vars.size() - 1) != value) {
            vars.remove(vars.size() - 1);
        }
    }

    private boolean isParameterCandidateForChange(String reference) {
        return LBL_FIELD.equals(reference) || LBL_DO_COPY_FROM_FIELD.equals(reference) || LBL_FIELD_TO_COPY_FROM.equals(reference) || LBL_FIELD_INDEX.equals(reference) || LBL_FIELD_TO_COPY_FROM_INDEX.equals(reference);
    }

    private Variable createInputValueVariableWithSimData(String fieldName) {
        Variable var = null;
        FieldDefinition field = this.myClassRepository.getFieldDefinitionByName(fieldName);
        if (field != null) {
            try {
                ArrayList<String> fieldNameList = new ArrayList();
                String restriction = field.getUtilClass("InputRestriction");
                if ("RelativeDate".equals(restriction) || "RelativeTime".equals(restriction)) {
                    fieldNameList = this.createSourceFieldListBuilder(fieldName, null).buildFieldNameList();
                }
                var = this.createVariableForField(LBL_VALUE, null, field, null, fieldNameList);
            }
            catch (Exception ex) {
                var = new InfoVariable(LBL_VALUE, ex.getMessage());
            }
        }
        if (var == null) {
            var = new StringVariable(LBL_VALUE, "");
            ((Variable)var).setAllowEdit(false);
        }
        return var;
    }

    protected DataTypeCompatibilityStrategy getDataTypeCompatibilityStrategy() {
        return null;
    }

    private static boolean isDataTypeSupportedAsDestination(DataType dataType) {
        switch (dataType) {
            case AMOUNT: 
            case BCDSTRING: 
            case BOOLEAN: 
            case DATE: 
            case DECIMAL: 
            case DOUBLE: 
            case INTEGER: 
            case LONG: 
            case MONETARYUNITS: 
            case OBJECT: 
            case OCTETSTRING: 
            case RATINGDECIMAL: 
            case SHORT: 
            case STRING: 
            case TIME: 
            case UNSIGNEDINT: 
            case UNSIGNEDINT16: 
            case UNSIGNEDINT32: 
            case UNSIGNEDINT8: 
            case UNSIGNEDLONG: 
            case UNSIGNEDSHORT: {
                return true;
            }
        }
        return false;
    }

    static List<String> getSupportedFeatures() {
        return Arrays.asList(ARRAY_MAP_SUPPORT_FEATURE, DATASET_TIME_FIELD_SUPPORT_FEATURE, DATE_TIME_INTEROPERABILITY_FEATURE);
    }

    @Override
    public Map<String, Object> getDisplayValues(Node data, Map<String, Object> prev) {
        Map<String, Object> displayValuesMap = this.createOrGetDisplayValuesMap(prev);
        Element destFieldElement = XMLUtil.getFirstElementNamed("TreeDefinedField", (Element)data);
        String destField = XMLUtil.getFirstTextContent(destFieldElement);
        FieldDefinition fd = this.myClassRepository.getFieldDefinitionByName(destField);
        displayValuesMap.put(LBL_FIELD, destField);
        Element indexElement = XMLUtil.getFirstElementNamed("Index", destFieldElement);
        if (indexElement != null) {
            displayValuesMap.put(LBL_FIELD_INDEX, indexElement.getTextContent());
        }
        if (fd != null) {
            Element copyFromElement = XMLUtil.getFirstElementNamed("CopyFrom", (Element)data);
            String copyFrom = copyFromElement.getTextContent();
            if ("".equals(copyFrom)) {
                displayValuesMap.put(LBL_DO_COPY_FROM_FIELD, "false");
                Element valueElement = XMLUtil.getFirstElementNamed("Value", (Element)data);
                String displayString = FieldOrientedPluginUtil.describeFieldValue(fd, valueElement.getTextContent());
                displayValuesMap.put(LBL_VALUE, displayString);
            } else {
                displayValuesMap.put(LBL_DO_COPY_FROM_FIELD, "true");
                String copyFromField = XMLUtil.getFirstTextContent(copyFromElement);
                displayValuesMap.put(LBL_FIELD_TO_COPY_FROM, copyFromField);
                Element copyFromIndexElement = XMLUtil.getFirstElementNamed("Index", copyFromElement);
                if (copyFromIndexElement != null) {
                    displayValuesMap.put(LBL_FIELD_TO_COPY_FROM_INDEX, copyFromIndexElement.getTextContent());
                }
            }
        }
        return displayValuesMap;
    }

    private Map<String, Object> createOrGetDisplayValuesMap(Map<String, Object> prev) {
        Map<String, Object> displayValuesMap = prev;
        if (displayValuesMap == null) {
            displayValuesMap = new HashMap<String, Object>();
        }
        return displayValuesMap;
    }

    @Override
    public Map<String, Object> getDisplayValues(List<Variable> variables, Map<String, Object> prev) {
        Map<String, Object> displayValuesMap = super.getDisplayValues(variables, prev);
        String field = VarListUtil.getValueStringForName(variables, LBL_FIELD);
        String destFieldIndex = VarListUtil.getValueStringForName(variables, LBL_FIELD_INDEX);
        if (destFieldIndex != null) {
            displayValuesMap.put(LBL_FIELD_INDEX, destFieldIndex);
        }
        Boolean copy = VarListUtil.getBooleanValueForName(variables, LBL_DO_COPY_FROM_FIELD);
        displayValuesMap.put(LBL_DO_COPY_FROM_FIELD, copy.toString());
        String copyFromFieldIndex = VarListUtil.getValueStringForName(variables, LBL_FIELD_TO_COPY_FROM_INDEX);
        if (copyFromFieldIndex != null) {
            displayValuesMap.put(LBL_FIELD_TO_COPY_FROM_INDEX, copyFromFieldIndex);
        }
        if (!copy.booleanValue()) {
            FieldDefinition destinationFieldDefinition = this.myClassRepository.getFieldDefinitionByName(field);
            Variable valueVar = VarListUtil.getVariableForName(variables, LBL_VALUE);
            String value = FieldOrientedPluginProfileUtil.describeValueForField(valueVar, this.myClassRepository, destinationFieldDefinition, false);
            displayValuesMap.put(LBL_VALUE, value);
        }
        return displayValuesMap;
    }

    @Override
    public String[] getTreeDefinedFieldInUse(List<Variable> variableList) {
        HashSet<String> usedTDFs = new HashSet<String>();
        usedTDFs.addAll(FieldOrientedPluginProfileUtil.extractReservedTreeDefinedFieldFromVariable(VarListUtil.getVariableForName(variableList, LBL_FIELD), this.myClassRepository, true));
        usedTDFs.addAll(FieldOrientedPluginProfileUtil.extractReservedTreeDefinedFieldFromVariable(VarListUtil.getVariableForName(variableList, LBL_FIELD_INDEX), this.myClassRepository, true));
        usedTDFs.addAll(FieldOrientedPluginProfileUtil.extractReservedTreeDefinedFieldFromVariable(VarListUtil.getVariableForName(variableList, LBL_FIELD_TO_COPY_FROM), this.myClassRepository, true));
        usedTDFs.addAll(FieldOrientedPluginProfileUtil.extractReservedTreeDefinedFieldFromVariable(VarListUtil.getVariableForName(variableList, LBL_FIELD_TO_COPY_FROM_INDEX), this.myClassRepository, true));
        usedTDFs.addAll(FieldOrientedPluginProfileUtil.extractReservedTreeDefinedFieldFromVariable(VarListUtil.getVariableForName(variableList, LBL_VALUE), this.myClassRepository, false));
        return usedTDFs.toArray(new String[usedTDFs.size()]);
    }

    private static boolean typeIsInList(String parameterType, List<String> list) {
        for (String currentParameterType : list) {
            if (!currentParameterType.equalsIgnoreCase(parameterType)) continue;
            return true;
        }
        return false;
    }

    private static List<String> prepareParameterTypeList() {
        ArrayList<String> parameterTypeList = new ArrayList<String>(Arrays.asList(ClassRepository.OUTPUT_TYPES));
        parameterTypeList.add("INTERNAL");
        return parameterTypeList;
    }

    private IndexVariableFactory createIndexVariableFactory(boolean allowMultiInput) {
        return IndexVariableFactory.buildFactory().withMultipleInputAllowed(allowMultiInput).withHierarchicalFieldSupport(true).withFilterableFieldVariable(true).withDateTimeInteroperability(this.mySupportDateTimeInteroperability).andRepository(this.myClassRepository);
    }

    private static class FieldOrientedFieldFilter
    implements FieldFilter {
        private FieldOrientedFieldFilter() {
        }

        @Override
        public boolean isAllowed(FieldDefinition field) {
            return field.isFieldOriented();
        }
    }

    private static class SourceFieldFilter
    implements FieldFilter {
        private final FieldDefinition myDestinationField;
        private final DataTypeCompatibilityStrategy myCompatibilityStrategy;

        private SourceFieldFilter(FieldDefinition aDestinationField, DataTypeCompatibilityStrategy compatibilityStrategy) {
            this.myDestinationField = aDestinationField;
            this.myCompatibilityStrategy = compatibilityStrategy;
        }

        @Override
        public boolean isAllowed(FieldDefinition field) {
            return field.isAutoConditionMapAllowed() && !field.isSet() && SetFieldModifierProfile.compatibleDataTypes(this.myDestinationField.getTypedDataType(), field.getTypedDataType(), this.myCompatibilityStrategy) && FieldDefinitionUtil.areFieldsUsingSameValueClass(this.myDestinationField, field) && field.isFieldOriented();
        }
    }

    private static class DestinationFieldFilter
    implements FieldFilter {
        private DestinationFieldFilter() {
        }

        @Override
        public boolean isAllowed(FieldDefinition field) {
            return SetFieldModifierProfile.isDataTypeSupportedAsDestination(field.getTypedDataType()) && SetFieldModifierProfile.typeIsInList(field.getParameterType(), SetFieldModifierProfile.prepareParameterTypeList());
        }
    }

    private static class DefaultDataTypeCompatibilityStrategy
    implements DataTypeCompatibilityStrategy {
        private DefaultDataTypeCompatibilityStrategy() {
        }

        @Override
        public boolean areDataTypesAssignmentCompatible(DataType destinationDataType, DataType sourceDataType) {
            if (destinationDataType == DataType.UNSIGNEDSHORT && (sourceDataType == DataType.UNSIGNEDINT32 || sourceDataType == DataType.UNSIGNEDINT)) {
                return true;
            }
            if (destinationDataType == DataType.UNSIGNEDINT8 && sourceDataType == DataType.UNSIGNEDSHORT) {
                return true;
            }
            if (destinationDataType == DataType.UNSIGNEDINT16 && sourceDataType == DataType.UNSIGNEDINT) {
                return true;
            }
            if (destinationDataType == DataType.UNSIGNEDINT32 && sourceDataType == DataType.UNSIGNEDLONG) {
                return true;
            }
            if (destinationDataType == DataType.RATINGDECIMAL && (sourceDataType == DataType.DOUBLE || sourceDataType == DataType.DECIMAL)) {
                return false;
            }
            if (!(destinationDataType != DataType.DATE && destinationDataType != DataType.TIME || sourceDataType != DataType.DATE && sourceDataType != DataType.TIME)) {
                return true;
            }
            return destinationDataType.isAssignableFrom(sourceDataType);
        }
    }

    private class SourceHierarchicalFieldFilter
    implements HierarchicalFieldFilter {
        private final List<String> allowedTypes = Arrays.asList("IN", "OUT", "INTERNAL", "VARIABLE", "VIRTUAL");
        private FieldDefinition myDestination;

        public SourceHierarchicalFieldFilter(FieldDefinition dest) {
            this.myDestination = dest;
        }

        private boolean isOfAllowedComplexType(FieldDefinition def) {
            FieldHierarchyNode.ComplexType type = def.getComplexType();
            boolean isNotSet = type != FieldHierarchyNode.ComplexType.SET;
            boolean isParentNullOrNone = true;
            boolean isParentNotSet = true;
            FieldStructure parent = def.getParent();
            if (parent != null) {
                FieldHierarchyNode.ComplexType parentType = parent.getComplexType();
                isParentNullOrNone = parentType == FieldHierarchyNode.ComplexType.NONE;
                isParentNotSet = parentType != FieldHierarchyNode.ComplexType.SET;
            }
            boolean typeIsNotSet = isNotSet && isParentNotSet;
            boolean typeIsNone = type == FieldHierarchyNode.ComplexType.NONE && isParentNullOrNone;
            return typeIsNone || SetFieldModifierProfile.this.mySupportArrayMap && typeIsNotSet;
        }

        private boolean isCommonContextOrSameAsDestination(FieldDefinition def) {
            boolean commonOrSame = true;
            if (def.isContextField() && this.myDestination.isContextField()) {
                List<String> sourceContexts = def.getContextNames();
                if (sourceContexts.isEmpty()) {
                    commonOrSame = false;
                } else {
                    boolean isContextFieldIdentifier = this.myDestination.getCanonicalName().equals(SetFieldModifierProfile.this.myClassRepository.getContextFieldIdentifier());
                    if (!isContextFieldIdentifier && Collections.disjoint(sourceContexts, this.myDestination.getContextNames())) {
                        commonOrSame = false;
                    }
                }
            }
            return commonOrSame;
        }

        @Override
        public boolean isAllowed(FieldHierarchyNode field) {
            boolean allowed = false;
            if (field.isLeaf()) {
                FieldDefinition fieldDefinition = (FieldDefinition)field;
                allowed = this.allowedTypes.contains(fieldDefinition.getParameterType());
                allowed &= ClassRepositoryHelper.fieldIsCommonOrVisibleContextField(fieldDefinition, SetFieldModifierProfile.this.myClassRepository);
                allowed &= this.isCommonContextOrSameAsDestination(fieldDefinition);
                allowed &= this.isOfAllowedComplexType(fieldDefinition);
                allowed &= !fieldDefinition.isKey();
                allowed &= !SetFieldModifierProfile.this.isComplexFieldInComplexFieldStructure(fieldDefinition);
            }
            return allowed;
        }
    }

    private class DateTimeInteropFilter
    implements FieldFilter {
        private DataType myDestinationType;

        public DateTimeInteropFilter(FieldDefinition field) {
            this.myDestinationType = field.getTypedDataType();
        }

        @Override
        public boolean isAllowed(FieldDefinition sourceField) {
            boolean allowed = true;
            DataType sourceType = sourceField.getTypedDataType();
            if (this.myDestinationType != sourceType && (this.myDestinationType == DataType.TIME || this.myDestinationType == DataType.DATE)) {
                allowed = SetFieldModifierProfile.this.mySupportDateTimeInteroperability && (sourceType == DataType.TIME || sourceType == DataType.DATE);
            }
            return allowed;
        }
    }

    private class TargetHierarchicalFieldFilter
    implements HierarchicalFieldFilter {
        private final List<String> allowedTypes = Arrays.asList("OUT", "INTERNAL", "VARIABLE");

        private TargetHierarchicalFieldFilter() {
        }

        private boolean isOfAllowedComplexType(FieldDefinition def) {
            FieldHierarchyNode.ComplexType type = def.getComplexType();
            boolean isSetOrNone = type == FieldHierarchyNode.ComplexType.SET || type == FieldHierarchyNode.ComplexType.NONE;
            boolean isParentNullSetOrNone = true;
            FieldStructure parent = def.getParent();
            if (parent != null) {
                FieldHierarchyNode.ComplexType parentType = parent.getComplexType();
                isParentNullSetOrNone = parentType == FieldHierarchyNode.ComplexType.SET || parentType == FieldHierarchyNode.ComplexType.NONE;
            }
            return SetFieldModifierProfile.this.mySupportArrayMap || isSetOrNone && isParentNullSetOrNone;
        }

        @Override
        public boolean isAllowed(FieldHierarchyNode field) {
            boolean allowed = false;
            if (field.isLeaf()) {
                FieldDefinition fieldDefinition = (FieldDefinition)field;
                allowed = this.allowedTypes.contains(fieldDefinition.getParameterType());
                allowed &= ClassRepositoryHelper.fieldIsCommonOrVisibleContextField(fieldDefinition, SetFieldModifierProfile.this.myClassRepository);
                allowed &= this.isOfAllowedComplexType(fieldDefinition);
                allowed &= !field.isKey();
                allowed &= !SetFieldModifierProfile.this.isComplexFieldInComplexFieldStructure(fieldDefinition);
            }
            return allowed;
        }
    }
}

