/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.modifiers;

import com.ericsson.ere.gui.simulator.testgenerator.TestCaseGenerationModifierInterface;
import com.ericsson.ere.math.RatingDecimal;
import com.ericsson.ere.selectiontree.ParseContextAdapter;
import com.ericsson.ere.selectiontree.modifiers.AbstractModifierProfile;
import com.ericsson.ere.selectiontree.modifiers.RateConfiguration;
import com.ericsson.ere.selectiontree.util.PluginConfigurationHelper;
import ericsson.ere.gui.util.GuiUtil;
import ericsson.ere.xml.XMLUtil;
import ericsson.vareditor.variable.DoubleVariable;
import ericsson.vareditor.variable.IntegerVariable;
import ericsson.vareditor.variable.LongVariable;
import ericsson.vareditor.variable.RatingDecimalVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RateProfile
extends AbstractModifierProfile
implements TestCaseGenerationModifierInterface {
    public static String LBL_PRICE = "Price per minute";
    public static String LBL_INTERVAL = "Charging interval";
    private static final String LBL_EXPECTED_COST = "Expected cost";
    private static final String TAG_EXPECTED_COST = "ExpectedCost";
    private static final String LBL_EXPECTED_DURATION = "Expected duration";
    private static final String TAG_EXPECTED_DURATION = "ExpectedDuration";

    @Override
    public List<Variable> getVariables() {
        return this.getVariables(RatingDecimal.ZERO, 1);
    }

    @Override
    public List<Variable> getVariables(Node xmlNode) {
        RateConfiguration conf = RateConfiguration.create(new ParseContextAdapter(null, xmlNode, null));
        return this.getVariables(conf.getPricePerMinute(), conf.getChargingInterval());
    }

    public List<Variable> getVariables(RatingDecimal pricePerMinute, int chargingInterval) {
        ArrayList<Variable> l = new ArrayList<Variable>(2);
        l.add(new RatingDecimalVariable(LBL_PRICE, pricePerMinute));
        l.add(new IntegerVariable(LBL_INTERVAL, chargingInterval, 1, Integer.MAX_VALUE));
        return l;
    }

    @Override
    public void printParametersImpl(PrintWriter out, int indentLevel, String indentMarker, List<Variable> variables) {
        String price = VarListUtil.getValueStringForName(variables, LBL_PRICE);
        RatingDecimal priceDecimal = new RatingDecimal(price);
        Integer interval = (Integer)VarListUtil.getValueForName(variables, LBL_INTERVAL);
        RateConfiguration config = new RateConfiguration(priceDecimal, interval);
        PluginConfigurationHelper.writeXML(config, out, indentLevel, indentMarker);
    }

    @Override
    public String getDescription(List<Variable> variables) {
        String name = VarListUtil.getValueStringForName(variables, "Name");
        String price = VarListUtil.getValueStringForName(variables, LBL_PRICE);
        String interval = VarListUtil.getValueStringForName(variables, LBL_INTERVAL);
        return name + " price = " + price + ", interval = " + interval;
    }

    @Override
    public String getAdditionalInfo(List<Variable> variables) {
        String name = VarListUtil.getValueStringForName(variables, "Name");
        String price = VarListUtil.getValueStringForName(variables, LBL_PRICE);
        String interval = VarListUtil.getValueStringForName(variables, LBL_INTERVAL);
        String info = "<b>" + name + "</b> (Price = " + price + " Interval = " + interval + ")\n" + this.getComment(variables);
        return GuiUtil.multilineTooltipWrapper(info);
    }

    @Override
    public List<Variable> getTestVariables(Node settingsIterator, Node testSettingsIterator) {
        ArrayList<Variable> vars = new ArrayList<Variable>();
        if (testSettingsIterator == null) {
            vars.add(new IntegerVariable(LBL_EXPECTED_DURATION, 0));
            vars.add(new DoubleVariable(LBL_EXPECTED_COST, 0.0));
        } else {
            Element expectedDurationNode = XMLUtil.getNamedElement(TAG_EXPECTED_DURATION, testSettingsIterator.getChildNodes());
            String expectedDuration = XMLUtil.getFirstTextContent(expectedDurationNode);
            vars.add(new LongVariable(LBL_EXPECTED_DURATION, expectedDuration));
            Element expectedCostNode = XMLUtil.getNamedElement(TAG_EXPECTED_COST, testSettingsIterator.getChildNodes());
            String expectedCost = XMLUtil.getFirstTextContent(expectedCostNode);
            vars.add(new DoubleVariable(LBL_EXPECTED_COST, expectedCost));
        }
        return vars;
    }

    @Override
    public void printTestVariables(PrintWriter out, List<Variable> vars) {
        out.print("<TestSettings>\n");
        out.print("<ExpectedDuration>");
        out.print(VarListUtil.getVariableForName(vars, LBL_EXPECTED_DURATION).getValueString());
        out.print("</ExpectedDuration>\n");
        out.print("<ExpectedCost>");
        out.print(VarListUtil.getVariableForName(vars, LBL_EXPECTED_COST).getValueString());
        out.print("</ExpectedCost>\n");
        out.print("</TestSettings>");
    }

    @Override
    public Map<String, Object> getTestSimulationFieldValues(Node config, Node testConfig) throws Exception {
        HashMap<String, Object> info = new HashMap<String, Object>();
        NodeList children = testConfig.getChildNodes();
        Element expectedDurationNode = XMLUtil.getNamedElement(TAG_EXPECTED_DURATION, children);
        String expectedDuration = XMLUtil.getFirstTextContent(expectedDurationNode);
        info.put(LBL_EXPECTED_DURATION, Long.parseLong(expectedDuration));
        Element expectedCostNode = XMLUtil.getNamedElement(TAG_EXPECTED_COST, children);
        String expectedCost = XMLUtil.getFirstTextContent(expectedCostNode);
        info.put(LBL_EXPECTED_COST, Double.parseDouble(expectedCost));
        return info;
    }

    @Override
    public boolean isManualValidationPossible(Node variableValueIterator) {
        return true;
    }

    @Override
    public boolean testParameterChanged(String reference, Variable value, List<Variable> vars) {
        return false;
    }
}

