/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.modifiers;

import com.ericsson.ere.math.RatingDecimal;
import com.ericsson.ere.selectiontree.ParseContextAdapter;
import com.ericsson.ere.selectiontree.modifiers.AbstractModifierProfile;
import com.ericsson.ere.selectiontree.modifiers.RateIntervalConfiguration;
import com.ericsson.ere.selectiontree.util.PluginConfigurationHelper;
import ericsson.ere.gui.util.GuiUtil;
import ericsson.vareditor.variable.IntegerVariable;
import ericsson.vareditor.variable.RatingDecimalVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Node;

public class RateIntervalProfile
extends AbstractModifierProfile {
    static String LBL_PRICE = "Price per interval";
    static String LBL_PRICE_INTERVAL = "Price interval";
    static String LBL_CHARGING_INTERVAL = "Charging interval";

    @Override
    public List<Variable> getVariables() {
        return this.getVariables(RatingDecimal.ZERO, 1, 1);
    }

    @Override
    public List<Variable> getVariables(Node xmlNode) {
        RateIntervalConfiguration conf = RateIntervalConfiguration.create(new ParseContextAdapter(null, xmlNode, null));
        return this.getVariables(conf.getPricePerInterval(), conf.getChargingInterval(), conf.getPriceInterval());
    }

    public List<Variable> getVariables(RatingDecimal pricePerInterval, int chargingInterval, int priceInterval) {
        ArrayList<Variable> l = new ArrayList<Variable>(3);
        l.add(new RatingDecimalVariable(LBL_PRICE, pricePerInterval));
        l.add(new IntegerVariable(LBL_CHARGING_INTERVAL, chargingInterval, 1, Integer.MAX_VALUE));
        l.add(new IntegerVariable(LBL_PRICE_INTERVAL, priceInterval, 1, Integer.MAX_VALUE));
        return l;
    }

    @Override
    public void printParametersImpl(PrintWriter out, int indentLevel, String indentMarker, List<Variable> variables) {
        String price = VarListUtil.getValueStringForName(variables, LBL_PRICE);
        RatingDecimal priceDecimal = new RatingDecimal(price);
        Integer priceInterval = (Integer)VarListUtil.getValueForName(variables, LBL_PRICE_INTERVAL);
        Integer chargingInterval = (Integer)VarListUtil.getValueForName(variables, LBL_CHARGING_INTERVAL);
        RateIntervalConfiguration config = new RateIntervalConfiguration(priceDecimal, priceInterval, chargingInterval);
        PluginConfigurationHelper.writeXML(config, out, indentLevel, indentMarker);
    }

    @Override
    public String getAdditionalInfo(List<Variable> variables) {
        String price = VarListUtil.getValueStringForName(variables, LBL_PRICE);
        String priceInterval = VarListUtil.getValueStringForName(variables, LBL_PRICE_INTERVAL);
        String chargingInterval = VarListUtil.getValueStringForName(variables, LBL_CHARGING_INTERVAL);
        String name = VarListUtil.getValueStringForName(variables, "Name");
        String info = "<b>" + name + "</b> (Price = " + price + " Price interval = " + priceInterval + " Charging interval = " + chargingInterval + ")\n" + this.getComment(variables);
        return GuiUtil.multilineTooltipWrapper(info);
    }

    @Override
    public String getDescription(List<Variable> variables) {
        String name = VarListUtil.getValueStringForName(variables, "Name");
        String price = VarListUtil.getValueStringForName(variables, LBL_PRICE);
        String priceInterval = VarListUtil.getValueStringForName(variables, LBL_PRICE_INTERVAL);
        String chargingInterval = VarListUtil.getValueStringForName(variables, LBL_CHARGING_INTERVAL);
        String info = name + " price = " + price + ", price interval = " + priceInterval + ", charging interval = " + chargingInterval;
        return info;
    }
}

