/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.modifiers;

import com.ericsson.ere.math.RatingDecimal;
import com.ericsson.ere.selectiontree.BeanBasedPluginConfiguration;
import com.ericsson.ere.selectiontree.ParseContext;
import com.ericsson.ere.selectiontree.util.TreeParseUtil;
import ericsson.ere.xml.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RateIntervalConfiguration
extends BeanBasedPluginConfiguration {
    private int myPriceInterval;
    private RatingDecimal myPricePerInterval;
    private int myChargingInterval;

    private RateIntervalConfiguration(ParseContext context) {
        super(context);
        NodeList children = context.getXMLNode().getChildNodes();
        Element priceNode = XMLUtil.getNamedElement("Price", children);
        String nodeValue = XMLUtil.getFirstTextContent(priceNode);
        this.myPricePerInterval = new RatingDecimal(nodeValue);
        Element priceIntervalNode = XMLUtil.getNamedElement("PriceInterval", children);
        nodeValue = XMLUtil.getFirstTextContent(priceIntervalNode);
        this.myPriceInterval = TreeParseUtil.parseInt(nodeValue);
        Element chargingIntervalNode = XMLUtil.getNamedElement("Interval", children);
        nodeValue = XMLUtil.getFirstTextContent(chargingIntervalNode);
        this.myChargingInterval = Integer.parseInt(nodeValue);
    }

    public RateIntervalConfiguration(RatingDecimal pricePerInterval, int priceInterval, int chargingInterval) {
        super(null);
        this.myPricePerInterval = pricePerInterval;
        this.myPriceInterval = priceInterval;
        this.myChargingInterval = chargingInterval;
    }

    public int getPriceInterval() {
        return this.myPriceInterval;
    }

    public void setPriceInterval(int anInterval) {
        this.myPriceInterval = anInterval;
    }

    public void setChargingInterval(int anInterval) {
        this.myChargingInterval = anInterval;
    }

    public int getChargingInterval() {
        return this.myChargingInterval;
    }

    public void setPricePerInterval(RatingDecimal pricePerInterval) {
        this.myPricePerInterval = pricePerInterval;
    }

    public RatingDecimal getPricePerInterval() {
        return this.myPricePerInterval;
    }

    public static RateIntervalConfiguration create(ParseContext ctx) {
        return new RateIntervalConfiguration(ctx);
    }

    @Override
    public void appendXML(Node parent) {
        String price = this.myPricePerInterval.toString();
        Element priceElement = parent.getOwnerDocument().createElement("Price");
        priceElement.setTextContent(price);
        parent.appendChild(priceElement);
        Element intervalElement = parent.getOwnerDocument().createElement("Interval");
        intervalElement.setTextContent(Integer.toString(this.myChargingInterval));
        parent.appendChild(intervalElement);
        Element priceIntervalElement = parent.getOwnerDocument().createElement("PriceInterval");
        priceIntervalElement.setTextContent(Integer.toString(this.myPriceInterval));
        parent.appendChild(priceIntervalElement);
    }
}

