/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.modifiers;

import com.ericsson.ere.selectiontree.modifiers.AbstractModifierProfile;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.gui.util.GuiUtil;
import ericsson.vareditor.variable.DoubleVariable;
import ericsson.vareditor.variable.DropDownVariable;
import ericsson.vareditor.variable.NotAllowedVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MultiplyFeeProfile
extends AbstractModifierProfile {
    private ClassRepository myClassRepository;

    @Override
    public List<Variable> getVariables() {
        ArrayList<Variable> l = new ArrayList<Variable>(3);
        Object[] choices = this.myClassRepository.getNumericFieldNames();
        l.add(new DoubleVariable("Price", 0.0));
        if (choices.length > 0) {
            l.add(new DropDownVariable("Field", (Object)choices[0], choices));
        } else {
            l.add(new NotAllowedVariable("Field", "No numeric fields available to multiply with."));
        }
        return l;
    }

    @Override
    public List<Variable> getVariables(Node iterator) {
        ArrayList<Variable> l = new ArrayList<Variable>(3);
        String thePrice = "0.0";
        String fieldToUse = "";
        if (iterator.hasChildNodes()) {
            NodeList children = iterator.getChildNodes();
            for (int aa = 0; aa < children.getLength(); ++aa) {
                NodeList value;
                int bb;
                if (children.item(aa).getNodeName().toLowerCase().equals("Price".toLowerCase()) && children.item(aa).hasChildNodes() && (bb = 0) < (value = children.item(aa).getChildNodes()).getLength()) {
                    thePrice = value.item(bb).getNodeValue();
                }
                if (!children.item(aa).getNodeName().toLowerCase().equals("Field".toLowerCase()) || !children.item(aa).hasChildNodes() || (bb = 0) >= (value = children.item(aa).getChildNodes()).getLength()) continue;
                fieldToUse = value.item(bb).getNodeValue();
            }
        }
        l.add(new DoubleVariable("Price", thePrice));
        String[] fieldNames = this.myClassRepository.getNumericFieldNames();
        if (fieldNames.length > 0) {
            l.add(new DropDownVariable("Field", (Object)fieldToUse, (Object[])this.myClassRepository.getNumericFieldNames()));
        } else {
            l.add(new NotAllowedVariable("Field", "No numeric fields available to multiply with."));
        }
        return l;
    }

    @Override
    public void printParametersImpl(PrintWriter out, int indentLevel, String indentMarker, List<Variable> variables) {
        int i;
        String price = VarListUtil.getValueStringForName(variables, "Price");
        String field = VarListUtil.getValueStringForName(variables, "Field");
        for (i = 0; i < indentLevel + 1; ++i) {
            out.print(indentMarker);
        }
        out.print("<");
        out.print("Price");
        out.print(">");
        out.print(price);
        out.print("</");
        out.print("Price");
        out.println(">");
        for (i = 0; i < indentLevel + 1; ++i) {
            out.print(indentMarker);
        }
        out.print("<");
        out.print("Field");
        out.print(">");
        out.print(field);
        out.print("</");
        out.print("Field");
        out.println(">");
    }

    @Override
    public String getAdditionalInfo(List<Variable> variables) {
        String name = VarListUtil.getValueStringForName(variables, "Name");
        String price = VarListUtil.getValueStringForName(variables, "Price");
        String field = VarListUtil.getValueStringForName(variables, "Field");
        String info = "<b>" + name + "</b> (Price = " + price + " Field = " + field + ")\n" + this.getComment(variables);
        return GuiUtil.multilineTooltipWrapper(info);
    }

    @Override
    public boolean needsRepository() {
        return true;
    }

    @Override
    public void setClassRepository(ClassRepository repository) {
        this.myClassRepository = repository;
    }

    @Override
    public String getDescription(List<Variable> variables) {
        String name = VarListUtil.getValueStringForName(variables, "Name");
        String price = VarListUtil.getValueStringForName(variables, "Price");
        String field = VarListUtil.getValueStringForName(variables, "Field");
        return name + " price = " + price + ", field = " + field;
    }
}

