/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.modifiers;

import com.ericsson.ere.annotations.jcip.Immutable;
import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.dataset.DataSetField;
import com.ericsson.ere.dataset.DataSetValueNotFoundException;
import com.ericsson.ere.dataset.RatingDataSet;
import com.ericsson.ere.exception.PluginCreationException;
import com.ericsson.ere.math.RatingDecimal;
import com.ericsson.ere.selectiontree.ParseContext;
import com.ericsson.ere.selectiontree.TreeExecutionException;
import com.ericsson.ere.selectiontree.modifiers.ImmutableModifier;
import com.ericsson.ere.trace.PluginTraceHelper;
import com.ericsson.ere.trace.TraceDataSet;
import com.ericsson.ere.trace.TracePoint;
import com.ericsson.ere.trace.TraceableV2;
import ericsson.ere.interfaces.TariffStructureNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Immutable
public class MultiplyFee
extends ImmutableModifier
implements TraceableV2 {
    private final String myFieldToUse;
    private final RatingDecimal myFeePerItem;
    private static final Object PRE_COST = new Object();
    private static final Object POST_COST = new Object();
    private static final Object CURRENT_PRICE_FACTOR = new Object();
    private static final Object MONEY_LEFT = new Object();

    public static MultiplyFee create(ParseContext ctx, TariffStructureNode[] children) {
        return new MultiplyFee(ctx);
    }

    MultiplyFee(ParseContext ctx) {
        super(ctx);
        Node config = ctx.getXMLNode();
        String theField = "";
        RatingDecimal theFee = null;
        NodeList children = config.getChildNodes();
        for (int aa = 0; aa < children.getLength(); ++aa) {
            String nodeName = children.item(aa).getNodeName();
            String nodeValue = children.item(aa).getTextContent();
            if (nodeName.toLowerCase().equals("Field".toLowerCase())) {
                theField = nodeValue;
                if (ctx.getClassRepository().getFieldDefinitionByName(theField) != null) continue;
                throw new PluginCreationException("Referenced field " + theField + " does not exist.");
            }
            if (!nodeName.toLowerCase().equals("Price".toLowerCase())) continue;
            theFee = new RatingDecimal(nodeValue);
        }
        this.myFieldToUse = theField;
        this.myFeePerItem = theFee;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCodeImpl();
        result = 31 * result + (this.myFieldToUse == null ? 0 : this.myFieldToUse.hashCode());
        result = 31 * result + (this.myFeePerItem == null ? 0 : this.myFeePerItem.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !super.equalsImpl(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MultiplyFee other = (MultiplyFee)obj;
        if (!this.myFieldToUse.equals(other.myFieldToUse)) {
            return false;
        }
        return !(this.myFeePerItem == null ? other.myFeePerItem != null : !this.myFeePerItem.equals(other.myFeePerItem));
    }

    @Override
    public void perform(DataSet theData) {
        if (!(theData instanceof RatingDataSet)) {
            throw new TreeExecutionException("The passed data set does not have rating capabilities.");
        }
        RatingDataSet data = (RatingDataSet)theData;
        Object fieldValue = data.getDataAsObject(this.myFieldToUse);
        if (!(fieldValue instanceof Number)) {
            throw new TreeExecutionException("Cannot use a non-numeric value as multipler.");
        }
        RatingDecimal multiplierFieldValue = new RatingDecimal(fieldValue.toString());
        RatingDecimal fee = this.myFeePerItem.multiply(multiplierFieldValue);
        fee = fee.multiply(data.getCurrentPriceFactor());
        if (data.getMoneyLeft().isMinusOne() || data.getMoneyLeft().isMoreThanOrEqual(fee)) {
            data.allocateCost(fee);
        } else {
            data.stopExecution();
        }
    }

    @Override
    public String describeTrace(TracePoint tp) {
        RatingDecimal preCost = (RatingDecimal)tp.getInfo(PRE_COST);
        RatingDecimal postCost = (RatingDecimal)tp.getInfo(POST_COST);
        RatingDecimal cost = postCost.subtract(preCost);
        RatingDecimal priceFactor = (RatingDecimal)tp.getInfo(CURRENT_PRICE_FACTOR);
        RatingDecimal totalPrice = cost.divide(priceFactor);
        RatingDecimal moneyLeft = (RatingDecimal)tp.getInfo(MONEY_LEFT);
        TraceDataSet dataSet = TraceDataSet.createPreDataSet(tp);
        Object fieldValue = null;
        try {
            fieldValue = dataSet.getDataAsObject(this.myFieldToUse);
        }
        catch (DataSetValueNotFoundException e) {
            fieldValue = "[VALUE NOT FOUND]";
        }
        StringBuilder traceBuilder = new StringBuilder();
        traceBuilder.append("Multiply Fee : Price per item=").append(this.myFeePerItem).append(" Total price=").append(totalPrice).append(" Price factor=").append(priceFactor).append("\n");
        traceBuilder.append("         Using field: ").append(this.myFieldToUse).append("(").append(fieldValue).append(")").append("\n");
        traceBuilder.append("         Resulting cost=").append(cost).append(" Money left=").append(moneyLeft).append("\n");
        return traceBuilder.toString();
    }

    @Override
    public void setPreTracePointInfo(TracePoint tp) {
        RatingDataSet preDataset = (RatingDataSet)tp.getPreDataSet();
        RatingDecimal currentPriceFactor = preDataset.getCurrentPriceFactor();
        tp.addInfo(CURRENT_PRICE_FACTOR, currentPriceFactor);
        RatingDecimal cost = preDataset.getCost();
        tp.addInfo(PRE_COST, cost);
        PluginTraceHelper.addFieldValueAsPreDataInTracePoint(new DataSetField(this.myFieldToUse, 0, false), null, tp);
    }

    @Override
    public void setTracePointInfo(TracePoint tp) {
        RatingDataSet postDataset = (RatingDataSet)tp.getPostDataSet();
        RatingDecimal moneyLeft = postDataset.getMoneyLeft();
        tp.addInfo(MONEY_LEFT, moneyLeft);
        RatingDecimal cost = postDataset.getCost();
        tp.addInfo(POST_COST, cost);
    }
}

