/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.modifiers;

import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.executor.TreeExecutorHelper;
import com.ericsson.ere.selectiontree.ParseContext;
import com.ericsson.ere.selectiontree.interfaces.ExecutableNode;
import com.ericsson.ere.selectiontree.interfaces.Performable;
import com.ericsson.ere.trace.TraceNodeImmutableModifier;
import com.ericsson.ere.trace.TraceNodeInterface;
import com.ericsson.ere.trace.Traceable;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.ClassRepositoryUtil;
import ericsson.ere.interfaces.AbstractDAGNode;
import ericsson.ere.interfaces.DAGNode;
import ericsson.ere.interfaces.TariffStructureNode;
import ericsson.ere.interfaces.TariffStructureVisitor;
import ericsson.ere.interfaces.UsedFieldLister;
import ericsson.ere.xml.XMLUtil;
import java.util.HashSet;
import java.util.Set;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public abstract class ImmutableModifier
extends AbstractDAGNode
implements Performable,
ExecutableNode,
TariffStructureNode,
Traceable,
Cloneable,
UsedFieldLister {
    protected final String myTypename;
    protected final String myNodeId;
    protected final String myAlias;
    protected final String myRatingPlan;

    @Override
    public abstract void perform(DataSet var1);

    protected final void performPerformableUsingExecutor(Performable performable, DataSet dataSet) {
        TreeExecutorHelper.performPerformable(performable, dataSet);
    }

    protected ImmutableModifier(ParseContext ctx) {
        Node node;
        if (ctx == null) {
            this.myTypename = null;
            this.myNodeId = null;
            this.myAlias = null;
            this.myRatingPlan = null;
            return;
        }
        ClassRepository rep = ctx.getClassRepository();
        Node iterator = ctx.getXMLNode();
        String name = XMLUtil.getFirstTextContent(iterator);
        this.myTypename = name.intern();
        String id = null;
        NamedNodeMap attr = null;
        if (iterator.hasAttributes()) {
            attr = iterator.getAttributes();
        }
        if (attr != null && (node = attr.getNamedItem("id")) != null) {
            id = node.getNodeValue().trim().replace('/', '\\');
        }
        this.myNodeId = id;
        this.myAlias = rep != null ? rep.getAliasForModifier(name) : null;
        this.myRatingPlan = ctx.getRatingPlanName();
    }

    @Override
    protected int hashCodeImpl() {
        int prime = 31;
        int result = super.hashCodeImpl();
        result = 31 * result + (this.myAlias == null ? 0 : this.myAlias.hashCode());
        result = 31 * result + (this.myNodeId == null ? 0 : this.myNodeId.hashCode());
        result = 31 * result + (this.myRatingPlan == null ? 0 : this.myRatingPlan.hashCode());
        result = 31 * result + (this.myTypename == null ? 0 : this.myTypename.hashCode());
        return result;
    }

    @Override
    protected boolean equalsImpl(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !super.equalsImpl(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImmutableModifier other = (ImmutableModifier)obj;
        if (this.myAlias == null ? other.myAlias != null : !this.myAlias.equals(other.myAlias)) {
            return false;
        }
        if (this.myNodeId == null ? other.myNodeId != null : !this.myNodeId.equals(other.myNodeId)) {
            return false;
        }
        if (this.myRatingPlan == null ? other.myRatingPlan != null : !this.myRatingPlan.equals(other.myRatingPlan)) {
            return false;
        }
        return !(this.myTypename == null ? other.myTypename != null : !this.myTypename.equals(other.myTypename));
    }

    @Override
    public void execute(DataSet theData) {
        this.perform(theData);
        theData.modifierExecuted();
    }

    @Override
    public void endVisit(TariffStructureVisitor v) throws Exception {
        v.leaveModifier(this);
    }

    @Override
    public boolean getAllowsChildren() {
        return false;
    }

    @Override
    public TariffStructureNode createTraceNode(int childIndex, TraceNodeInterface parent) {
        TraceNodeImmutableModifier tnm = new TraceNodeImmutableModifier(this);
        tnm.setParent(parent);
        parent.addChild(tnm);
        tnm.setChildIndex(childIndex);
        return tnm;
    }

    @Override
    public DAGNode getChildAt(int index) throws IndexOutOfBoundsException {
        throw new IndexOutOfBoundsException("Modifier has no children");
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public String getTypename() {
        return this.myTypename;
    }

    @Override
    public String getName() {
        return this.myTypename;
    }

    @Override
    public String getNodeId() {
        String id = this.myNodeId;
        if (id == null || "".equals(id.trim())) {
            id = this.myTypename;
        }
        id = id.replace('/', '\\');
        return id;
    }

    @Override
    public int getNodeType() {
        return 3;
    }

    @Override
    public boolean isLink() {
        return false;
    }

    @Override
    public void startVisit(TariffStructureVisitor v) throws Exception {
        v.enterModifier(this);
    }

    @Override
    public void insertChildAt(int index, DAGNode node) throws IndexOutOfBoundsException, IllegalArgumentException {
        throw new IndexOutOfBoundsException("Condition may not have any children");
    }

    @Override
    public void insertLinkAt(int index, DAGNode node) throws IndexOutOfBoundsException, IllegalArgumentException {
        throw new IndexOutOfBoundsException("Condition may not have any children");
    }

    @Override
    public void replace(DAGNode child, DAGNode replacement) {
        throw new IllegalArgumentException("Child not found: " + child);
    }

    @Override
    protected void removeChild(DAGNode node) throws IllegalArgumentException {
        throw new IllegalArgumentException("Node not removed, structure is read-only");
    }

    @Override
    protected void removeLink(DAGNode node) throws IllegalArgumentException {
        throw new IllegalArgumentException("Node not removed, structure is read-only");
    }

    public String toString() {
        String alias = this.myAlias;
        if (alias != null && !"".equals(alias)) {
            return alias;
        }
        return this.getTypename();
    }

    @Override
    public Set<String> getUsedFields() {
        return new HashSet<String>();
    }

    protected static ClassRepository getClassRepository(DataSet dataSet) {
        return dataSet.getService().getClassRepository(ClassRepositoryUtil.getCurrentFieldContext(dataSet));
    }
}

