/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.modifiers;

import com.ericsson.ere.constraint.ConstraintService;
import com.ericsson.ere.constraint.contract.Constrainable;
import com.ericsson.ere.expression.Operator;
import com.ericsson.ere.expression.Operators;
import com.ericsson.ere.selectiontree.FieldFilter;
import com.ericsson.ere.selectiontree.modifiers.AbstractBinaryDateOperationProfile;
import com.ericsson.ere.selectiontree.modifiers.AbstractMultiFieldOperationProfile;
import com.ericsson.ere.selectiontree.modifiers.DateOffsetProfileContract;
import com.ericsson.ere.selectiontree.modifiers.mfo.ValueFieldCompositeOperand;
import com.ericsson.ere.selectiontree.util.ValueFieldCompositeObject;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import ericsson.vareditor.documents.AllIntegersDocument;
import ericsson.vareditor.variable.TypedDropDownVariable;
import ericsson.vareditor.variable.ValueFieldVariable;
import ericsson.vareditor.variable.Variable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.text.Document;

@Constrainable(contractClass=DateOffsetProfileContract.class)
public class DateOffsetProfile
extends AbstractBinaryDateOperationProfile {
    private static ArrayList<String> OPERAND_PARAM_TYPES;
    public static final String LBL_DATE = "Date";
    public static final String LBL_DATE_INDEX = "Date index";
    public static final String LBL_OPERATION = "Operation";
    public static final String LBL_DAYS = "Days";
    public static final String LBL_DAYS_INDEX = "Days index";
    private static final Operator[] OPERATORS;
    private static final String DATE_TIME_INTEROPERABILITY_FEATURE = "Date_Time_Interoperability_Support";
    private boolean mySupportDateTimeInteroperability;

    public DateOffsetProfile() {
        super(LBL_DATE, LBL_DATE_INDEX, LBL_OPERATION, LBL_DAYS, LBL_DAYS_INDEX);
    }

    @Override
    protected List<Variable> createFirstOperandVariables(ValueFieldCompositeOperand operand) {
        return this.createOperandVariables(operand, LBL_DATE, LBL_DATE_INDEX, true);
    }

    private void checkFeaturesViaClassRepository(ClassRepository repository) {
        List<String> enabledFeatures = ConstraintService.constrainFeatures(this, repository, this.getSupportedFeatures());
        this.mySupportDateTimeInteroperability = enabledFeatures.contains(DATE_TIME_INTEROPERABILITY_FEATURE);
    }

    List<String> getSupportedFeatures() {
        return Arrays.asList(DATE_TIME_INTEROPERABILITY_FEATURE);
    }

    @Override
    public void setClassRepository(ClassRepository repository) {
        super.setClassRepository(repository);
        this.checkFeaturesViaClassRepository(repository);
    }

    @Override
    protected Variable createOperationVariable(Operator oper) {
        if (oper != null) {
            return new TypedDropDownVariable<Operator>(LBL_OPERATION, OPERATORS, oper, new OperatorLabeler());
        }
        return new TypedDropDownVariable<Operator>(LBL_OPERATION, OPERATORS, new OperatorLabeler());
    }

    @Override
    protected List<Variable> createSecondOperandVariables(ValueFieldCompositeOperand operand) {
        return this.createOperandVariables(operand, LBL_DAYS, LBL_DAYS_INDEX, false);
    }

    private List<Variable> createOperandVariables(ValueFieldCompositeOperand operand, String valueLabel, String indexLabel, boolean isDateOperand) {
        String field;
        ValueFieldCompositeObject value;
        ArrayList<Variable> vars = new ArrayList<Variable>();
        ValueFieldCompositeObject index = null;
        if (operand != null) {
            value = operand.getValue();
            index = operand.getIndex();
        } else if (isDateOperand) {
            String dateValue = DataType.DATE.makeParseableString(DataType.DATE.createDefaultInstance());
            value = ValueFieldCompositeObject.createForValue(dateValue, DataType.DATE);
        } else {
            value = ValueFieldCompositeObject.createForValue("0", DataType.INTEGER);
        }
        Map<String, FieldDefinition> fields = this.getOperandFieldsAsMap(isDateOperand);
        Variable var = isDateOperand ? new ValueFieldVariable(valueLabel, value, fields, null, DataType.DATE) : new ValueFieldVariable(valueLabel, value, fields, (Document)new AllIntegersDocument(), null);
        vars.add(var);
        if (index != null && (var = this.createIndexVariableForFieldIfNecessary(field = value.getFieldOrValueAsString(), index, indexLabel, false)) != null) {
            vars.add(var);
        }
        return vars;
    }

    private Map<String, FieldDefinition> getOperandFieldsAsMap(boolean isDateOperand) {
        List<FieldDefinition> fieldList = this.getConstrainedOperandFieldDefinitionsForDestinationField(this.getCurrentDestinationField());
        HashMap<String, FieldDefinition> fieldMap = new HashMap<String, FieldDefinition>();
        for (FieldDefinition field : fieldList) {
            DataType type = field.getTypedDataType();
            if ((type == DataType.DATE || type == DataType.TIME) != isDateOperand) continue;
            fieldMap.put(field.getCanonicalName(), field);
        }
        return fieldMap;
    }

    @Override
    protected ValueFieldCompositeOperand createOperandFromValueObjects(ValueFieldCompositeObject value, ValueFieldCompositeObject index, boolean isFirstOperand) {
        if (isFirstOperand) {
            return super.createOperandFromValueObjects(value, index, isFirstOperand);
        }
        boolean isMapKey = this.containsMapField(value);
        return new DaysOperand(value, index, isMapKey);
    }

    @Override
    protected FieldFilter getOrCreateDestinationFieldFilter() {
        return new DateTimeDestinationFieldFilter(this.mySupportDateTimeInteroperability);
    }

    @Override
    protected FieldFilter getOrCreateOperandFieldFilter(String destination) {
        return new OperandFieldFilter(this.mySupportDateTimeInteroperability);
    }

    static {
        OPERATORS = new Operator[]{Operators.ADD, Operators.SUBTRACT};
        OPERAND_PARAM_TYPES = new ArrayList(DEST_PARAM_TYPES);
        OPERAND_PARAM_TYPES.addAll(Arrays.asList(ClassRepository.INPUT_TYPES));
    }

    private static class DaysOperand
    extends ValueFieldCompositeOperand {
        DaysOperand(ValueFieldCompositeObject value, ValueFieldCompositeObject index, boolean indexIsMapKey) {
            super(value, index, indexIsMapKey);
        }

        @Override
        public String toString() {
            String s = super.toString();
            Boolean single = null;
            ValueFieldCompositeObject value = this.getValue();
            if (value.getMode() == ValueFieldCompositeObject.Mode.Value) {
                String valueString = value.getFieldOrValueAsString();
                try {
                    int days = Integer.parseInt(valueString);
                    single = days == -1 || days == 1;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            String daysString = single == null ? "day(s)" : (single != false ? "day" : "days");
            return s + " " + daysString;
        }
    }

    private static class OperatorLabeler
    implements TypedDropDownVariable.ItemLabeler<Operator> {
        private OperatorLabeler() {
        }

        @Override
        public String getDisplayStringFor(Operator object, int index) {
            if (object.equals(Operators.ADD)) {
                return "Add";
            }
            if (object.equals(Operators.SUBTRACT)) {
                return "Subtract";
            }
            return String.valueOf(object);
        }
    }

    private static class OperandFieldFilter
    extends AbstractMultiFieldOperationProfile.ParameterTypeFieldFilter {
        private boolean myDateTimeFeatureTurnedOn;

        OperandFieldFilter(boolean dateTimeFeatureTurnedOn) {
            super(OPERAND_PARAM_TYPES);
            this.myDateTimeFeatureTurnedOn = dateTimeFeatureTurnedOn;
        }

        @Override
        public boolean isAllowed(FieldDefinition field) {
            DataType dt = field.getTypedDataType();
            boolean allowed = super.isAllowed(field);
            allowed = this.myDateTimeFeatureTurnedOn ? (allowed &= dt == DataType.TIME || dt == DataType.DATE || dt.isNumeric()) : (allowed &= dt == DataType.DATE || dt.isNumeric());
            return allowed;
        }
    }

    private static class DateTimeDestinationFieldFilter
    extends AbstractMultiFieldOperationProfile.DestinationFieldFilter {
        private boolean myDateTimeFeatureTurnedOn;

        public DateTimeDestinationFieldFilter(boolean dateTimeFeatureTurnedOn) {
            this.myDateTimeFeatureTurnedOn = dateTimeFeatureTurnedOn;
        }

        @Override
        public boolean isAllowed(FieldDefinition field) {
            DataType type = field.getTypedDataType();
            boolean allowed = super.isAllowed(field);
            allowed = this.myDateTimeFeatureTurnedOn ? (allowed &= type == DataType.DATE || type == DataType.TIME) : (allowed &= type == DataType.DATE);
            if ("RelativeDate".equals(field.getUtilClass("InputRestriction"))) {
                allowed = false;
            }
            return allowed;
        }
    }
}

