/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.modifiers;

import com.ericsson.ere.annotations.jcip.Immutable;
import com.ericsson.ere.dataset.ClearableValueDataSet;
import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.dataset.DataSetField;
import com.ericsson.ere.exception.PluginCreationException;
import com.ericsson.ere.selectiontree.ParseContext;
import com.ericsson.ere.selectiontree.TreeExecutionException;
import com.ericsson.ere.selectiontree.modifiers.ImmutableModifier;
import com.ericsson.ere.selectiontree.util.FieldIndexKeyContainer;
import com.ericsson.ere.selectiontree.util.FieldOrientedPluginUtil;
import com.ericsson.ere.trace.PluginTraceHelper;
import com.ericsson.ere.trace.TraceDataSet;
import com.ericsson.ere.trace.TracePoint;
import com.ericsson.ere.trace.TraceableV2;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.interfaces.FieldHierarchyNode;
import ericsson.ere.interfaces.TariffStructureNode;
import ericsson.ere.xml.XMLUtil;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Immutable
public final class ClearValue
extends ImmutableModifier
implements TraceableV2 {
    public static final String TAG_FIELD = "Field";
    public static final String TAG_FIELD_INDEX = "Index";
    private final DataSetField myFieldData;
    private final FieldIndexKeyContainer myIndexKeyContainer;

    protected ClearValue(ParseContext ctx, String fieldName) {
        super(ctx);
        FieldDefinition field = this.getFieldOrThrow(ctx.getClassRepository(), fieldName);
        Element config = (Element)ctx.getXMLNode();
        Element indexElement = XMLUtil.getFirstElementNamed(TAG_FIELD_INDEX, config);
        if (field.isArray() && indexElement != null) {
            throw new IllegalArgumentException("Array data is not supported for clearing.");
        }
        if (indexElement != null) {
            if (XMLUtil.getElementChildren(indexElement).isEmpty()) {
                throw new IllegalArgumentException("No value in Index tag for ClearValue.");
            }
            this.myIndexKeyContainer = FieldOrientedPluginUtil.extractIndexKeyObjectFromIndexElement(indexElement, ctx.getClassRepository(), (FieldHierarchyNode)field);
        } else {
            this.myIndexKeyContainer = null;
        }
        this.myFieldData = new DataSetField(field);
        FieldOrientedPluginUtil.checkMissingFields(this, ctx.getClassRepository());
    }

    public static ClearValue create(ParseContext ctx, TariffStructureNode[] children) {
        Node config = ctx.getXMLNode();
        String fieldName = ClearValue.getFieldNameFromXML(config);
        return new ClearValue(ctx, fieldName);
    }

    @Override
    public void perform(DataSet theData) {
        if (this.myIndexKeyContainer == null) {
            if (this.myFieldData.usesTag()) {
                ((ClearableValueDataSet)((Object)theData)).clearData(this.myFieldData.getTag());
            } else {
                ((ClearableValueDataSet)((Object)theData)).clearData(this.myFieldData.getFieldName());
            }
        } else {
            try {
                if (this.myFieldData.usesTag()) {
                    ((ClearableValueDataSet)((Object)theData)).clearDataForKey(this.myFieldData.getTag(), this.myIndexKeyContainer.getKeySet(theData)[0]);
                } else {
                    ((ClearableValueDataSet)((Object)theData)).clearDataForKey(this.myFieldData.getFieldName(), this.myIndexKeyContainer.getKeySet(theData)[0]);
                }
            }
            catch (IllegalArgumentException iAE) {
                throw new TreeExecutionException(iAE);
            }
        }
    }

    @Override
    public String describeTrace(TracePoint tp) {
        TraceDataSet dataset = TraceDataSet.createPreDataSet(tp);
        String formattedFieldName = FieldOrientedPluginUtil.formatFieldNameWithKeyInformation(this.myFieldData.getFieldName(), this.myIndexKeyContainer, dataset);
        return "ClearValue : " + formattedFieldName;
    }

    @Override
    public void setPreTracePointInfo(TracePoint tp) {
        PluginTraceHelper.addFieldValueAsPreDataInTracePoint(this.myFieldData, this.myIndexKeyContainer, tp);
    }

    @Override
    public void setTracePointInfo(TracePoint tp) {
    }

    public boolean useKeyForField() {
        return this.myIndexKeyContainer != null;
    }

    private FieldDefinition getFieldOrThrow(ClassRepository repository, String name) {
        FieldDefinition field = repository.getFieldDefinitionByName(name);
        if (field == null) {
            throw new PluginCreationException("Field not found in class repository: " + name);
        }
        return field;
    }

    private static String getFieldNameFromXML(Node config) {
        String fieldName;
        Element fieldElement = XMLUtil.getNamedElement(TAG_FIELD, config.getChildNodes());
        String string = fieldName = fieldElement == null ? "" : fieldElement.getTextContent();
        if ("".equals(fieldName)) {
            throw new IllegalArgumentException("No field specified for ClearValue.");
        }
        return fieldName;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCodeImpl();
        result = 31 * result + (this.myFieldData == null ? 0 : this.myFieldData.hashCode());
        result = 31 * result + (this.myIndexKeyContainer == null ? 0 : this.myIndexKeyContainer.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !super.equalsImpl(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClearValue other = (ClearValue)obj;
        if (this.myFieldData == null ? other.myFieldData != null : !this.myFieldData.equals(other.myFieldData)) {
            return false;
        }
        return !(this.myIndexKeyContainer == null ? other.myIndexKeyContainer != null : !this.myIndexKeyContainer.equals(other.myIndexKeyContainer));
    }

    @Override
    public Set<String> getUsedFields() {
        Set<String> set = super.getUsedFields();
        set.add(this.myFieldData.getFieldName());
        if (this.myIndexKeyContainer != null) {
            set.addAll(this.myIndexKeyContainer.getUsedFields());
        }
        return set;
    }
}

