/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.modifiers;

import com.ericsson.ere.annotations.jcip.Immutable;
import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.selectiontree.ParseContext;
import com.ericsson.ere.selectiontree.modifiers.ImmutableModifier;
import com.ericsson.ere.trace.TracePoint;
import com.ericsson.ere.trace.TraceableV2;
import ericsson.ere.interfaces.TariffStructureNode;
import ericsson.ere.xml.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Immutable
public final class BreakPointModifier
extends ImmutableModifier
implements TraceableV2 {
    public static final String TAG_BREAK = "Break";
    private final boolean myStopIndicator;

    private BreakPointModifier(ParseContext ctx) {
        super(ctx);
        Node iterator = ctx.getXMLNode();
        NodeList children = iterator.getChildNodes();
        Element stopIndicatorNode = XMLUtil.getNamedElement(TAG_BREAK, children);
        String stopIndicatorStr = XMLUtil.getFirstTextContent(stopIndicatorNode);
        this.myStopIndicator = Boolean.parseBoolean(stopIndicatorStr);
    }

    public static BreakPointModifier create(ParseContext ctx, TariffStructureNode[] children) {
        return new BreakPointModifier(ctx);
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCodeImpl();
        result = 31 * result + (this.myStopIndicator ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !super.equalsImpl(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BreakPointModifier other = (BreakPointModifier)obj;
        return this.myStopIndicator == other.myStopIndicator;
    }

    @Override
    public void perform(DataSet theData) {
        if (this.myStopIndicator) {
            theData.stopExecution();
        }
    }

    @Override
    public String describeTrace(TracePoint tp) {
        if (this.myStopIndicator) {
            return "Stopped tree execution";
        }
        return "Execution will continue";
    }

    @Override
    public void setTracePointInfo(TracePoint tp) {
    }

    @Override
    public void setPreTracePointInfo(TracePoint tp) {
    }
}

