/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.modifiers;

import com.ericsson.ere.annotations.jcip.Immutable;
import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.dataset.DataSetField;
import com.ericsson.ere.dataset.DataSetValueNotFoundException;
import com.ericsson.ere.dataset.DefaultDataDescriber;
import com.ericsson.ere.dataset.Key;
import com.ericsson.ere.datatype.LazyEvaluatedExpressionProvider;
import com.ericsson.ere.datatype.LazyEvaluatedValue;
import com.ericsson.ere.datatype.ValueResolver;
import com.ericsson.ere.exception.PluginCreationException;
import com.ericsson.ere.expression.Expression;
import com.ericsson.ere.expression.ExpressionToken;
import com.ericsson.ere.expression.FieldContainerOperand;
import com.ericsson.ere.expression.FieldValueOperand;
import com.ericsson.ere.expression.parser.DefaultExpressionParserHandler;
import com.ericsson.ere.expression.parser.DefaultExpressionParserOptions;
import com.ericsson.ere.expression.parser.ExpressionParser;
import com.ericsson.ere.selectiontree.ParseContext;
import com.ericsson.ere.selectiontree.ParseContextAdapter;
import com.ericsson.ere.selectiontree.TreeExecutionException;
import com.ericsson.ere.selectiontree.modifiers.DataSetValueReader;
import com.ericsson.ere.selectiontree.modifiers.ImmutableModifier;
import com.ericsson.ere.selectiontree.util.FieldIndexKeyContainer;
import com.ericsson.ere.selectiontree.util.FieldOrientedPluginUtil;
import com.ericsson.ere.trace.PluginTraceHelper;
import com.ericsson.ere.trace.TraceDataSet;
import com.ericsson.ere.trace.TracePoint;
import com.ericsson.ere.trace.TraceableV2;
import com.ericsson.ere.util.FieldDefinitionUtil;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.defs.FieldDefinitionHelper;
import ericsson.ere.interfaces.FieldHierarchyNode;
import ericsson.ere.management.Service;
import ericsson.ere.xml.XMLUtil;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Immutable
public abstract class AbstractSetFieldModifier<T>
extends ImmutableModifier
implements TraceableV2 {
    final DataSetField myDestinationField;
    final FieldIndexKeyContainer myDestinationFieldIndex;
    final Object myValueObject;
    final DataSetField mySourceField;
    final boolean myDestinationFieldIsASet;
    final FieldIndexKeyContainer mySourceFieldIndex;
    private final boolean myShallCopyFromField;
    final BigInteger myMin;
    final BigInteger myMax;
    protected final DataType myDataType;
    private final DataSetValueReader myDataSetValueReader;

    AbstractSetFieldModifier(ParseContext ctx, DataType dataType) {
        super(ctx);
        this.myDataSetValueReader = this.extractValueReader(ctx);
        Node nodeConfig = ctx.getXMLNode();
        ClassRepository repository = ctx.getClassRepository();
        if (XMLUtil.getFirstElementNamed("ValueType", (Element)ctx.getXMLNode()) != null) {
            String[] values = this.handleValueType(nodeConfig);
            this.myDataType = DataType.lookup(values[0]);
            FieldDefinition destinationField = repository.getFieldDefinitionByName(values[1]);
            if (destinationField == null) {
                throw new PluginCreationException("Referenced field " + values[1] + " does not exist.");
            }
            this.myDestinationField = new DataSetField(destinationField);
            this.myDestinationFieldIsASet = destinationField.isSet();
            this.myValueObject = this.parseValueToObject(destinationField, values[2]);
            if (values[2].length() > 0 && this.myValueObject == null) {
                throw new PluginCreationException("Not a valid value string: " + values[2]);
            }
            this.myDestinationFieldIndex = null;
            this.myShallCopyFromField = false;
            this.mySourceField = null;
            this.mySourceFieldIndex = null;
            this.myMin = null;
            this.myMax = null;
        } else {
            NodeList children = nodeConfig.getChildNodes();
            Element fieldNode = XMLUtil.getNamedElement("TreeDefinedField", children);
            if (fieldNode == null) {
                throw new PluginCreationException("Missing tag: TreeDefinedField");
            }
            String fieldName = XMLUtil.getFirstTextContent(fieldNode);
            FieldDefinition destinationField = repository.getFieldDefinitionByName(fieldName);
            if (destinationField == null) {
                throw new PluginCreationException("Referenced field " + fieldName + " does not exist.");
            }
            FieldIndexKeyContainer destinationFieldIndex = FieldOrientedPluginUtil.extractIndexKeyObjectFromIndexElement(AbstractSetFieldModifier.fetchIndexElementFromFieldElement(fieldNode), repository, (FieldHierarchyNode)destinationField);
            this.myDestinationField = new DataSetField(destinationField);
            this.myDestinationFieldIsASet = destinationField.isSet();
            this.myDestinationFieldIndex = destinationFieldIndex;
            String minValueString = FieldDefinitionHelper.getMinValue(destinationField);
            String maxValueString = FieldDefinitionHelper.getMaxValue(destinationField);
            this.myMin = minValueString == null ? null : new BigInteger(minValueString);
            this.myMax = maxValueString == null ? null : new BigInteger(maxValueString);
            this.myDataType = dataType;
            Element valueNode = XMLUtil.getNamedElement("Value", children);
            String copyFromField = "";
            FieldIndexKeyContainer sourceFieldIndex = null;
            Element copyFromFieldNode = XMLUtil.getNamedElement("CopyFrom", children);
            FieldDefinition sourceField = null;
            if (valueNode == null) {
                this.myValueObject = null;
            } else {
                String valueStr = XMLUtil.getFirstTextContent(valueNode);
                this.myValueObject = this.parseValueToObject(destinationField, valueStr);
                if (valueStr.length() > 0 && this.myValueObject == null) {
                    throw new PluginCreationException("Not a valid value string: " + valueStr);
                }
            }
            if (copyFromFieldNode != null) {
                copyFromField = XMLUtil.getFirstTextContent(copyFromFieldNode);
                sourceField = repository.getFieldDefinitionByName(copyFromField);
                sourceFieldIndex = FieldOrientedPluginUtil.extractIndexKeyObjectFromIndexElement(AbstractSetFieldModifier.fetchIndexElementFromFieldElement(copyFromFieldNode), repository, (FieldHierarchyNode)sourceField);
            } else if (valueNode == null) {
                String msg = String.format("Missing source tag (either %s or %s is required).", "CopyFrom", "Value");
                throw new PluginCreationException(msg, nodeConfig);
            }
            if (sourceField != null) {
                this.myShallCopyFromField = true;
                this.mySourceField = this.createSourceDataSetField(sourceField, destinationField);
                this.mySourceFieldIndex = sourceFieldIndex;
            } else {
                this.mySourceField = null;
                this.myShallCopyFromField = false;
                this.mySourceFieldIndex = null;
            }
        }
        FieldOrientedPluginUtil.checkMissingFields(this, repository);
    }

    private DataSetField createSourceDataSetField(FieldDefinition sourceField, FieldDefinition destinationField) {
        DataSetField retVal = this.isContextCompatibleDataTypes(sourceField.getTypedDataType(), destinationField.getTypedDataType()) ? new DataSetField(sourceField) : new DataSetField(sourceField, destinationField.getTypedDataType());
        return retVal;
    }

    private boolean isContextCompatibleDataTypes(DataType sourceDataType, DataType destinationDataType) {
        return sourceDataType == DataType.INTEGER && destinationDataType == DataType.LONG;
    }

    private DataSetValueReader extractValueReader(ParseContext ctx) {
        return ctx instanceof SetFieldParseContext ? ((SetFieldParseContext)ctx).getDataSetValueReader() : null;
    }

    private String[] handleValueType(Node configNode) {
        String theValueType = "";
        String theFieldName = "";
        String theValue = "";
        Element valueType = XMLUtil.getFirstElementNamed("ValueType", (Element)configNode);
        if (valueType == null) {
            throw new PluginCreationException("Missing tag: ValueType");
        }
        theValueType = XMLUtil.getFirstTextContent(valueType);
        Element fieldName = XMLUtil.getFirstElementNamed("FieldName", (Element)configNode);
        if (fieldName == null) {
            throw new PluginCreationException("Missing tag: FieldName");
        }
        theFieldName = XMLUtil.getFirstTextContent(fieldName);
        Element valueElem = XMLUtil.getFirstElementNamed("Value", (Element)configNode);
        if (valueElem == null) {
            throw new PluginCreationException("Missing tag: Value");
        }
        theValue = XMLUtil.getFirstTextContent(valueElem);
        return new String[]{theValueType, theFieldName, theValue};
    }

    protected T parseValueToObject(FieldDefinition destinationField, String value) {
        ValueResolver resolver = FieldDefinitionUtil.createValueResolver(null, destinationField);
        return (T)resolver.parseValueString(value);
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCodeImpl();
        result = 31 * result + (this.myDataSetValueReader == null ? 0 : this.myDataSetValueReader.hashCode());
        result = 31 * result + (this.myDataType == null ? 0 : this.myDataType.hashCode());
        result = 31 * result + (this.myDestinationField == null ? 0 : this.myDestinationField.hashCode());
        result = 31 * result + (this.myDestinationFieldIndex == null ? 0 : this.myDestinationFieldIndex.hashCode());
        result = 31 * result + (this.myMax == null ? 0 : this.myMax.hashCode());
        result = 31 * result + (this.myMin == null ? 0 : this.myMin.hashCode());
        result = 31 * result + (this.myShallCopyFromField ? 1231 : 1237);
        result = 31 * result + (this.mySourceField == null ? 0 : this.mySourceField.hashCode());
        result = 31 * result + (this.mySourceFieldIndex == null ? 0 : this.mySourceFieldIndex.hashCode());
        result = 31 * result + (this.myValueObject == null ? 0 : this.myValueObject.hashCode());
        result = 31 * result + (this.myDestinationFieldIsASet ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !super.equalsImpl(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractSetFieldModifier other = (AbstractSetFieldModifier)obj;
        if (this.myDataSetValueReader == null ? other.myDataSetValueReader != null : !this.myDataSetValueReader.equals(other.myDataSetValueReader)) {
            return false;
        }
        if (this.myDataType == null ? other.myDataType != null : !this.myDataType.equals(other.myDataType)) {
            return false;
        }
        if (this.myDestinationField == null ? other.myDestinationField != null : !this.myDestinationField.equals(other.myDestinationField)) {
            return false;
        }
        if (this.myDestinationFieldIndex == null ? other.myDestinationFieldIndex != null : !this.myDestinationFieldIndex.equals(other.myDestinationFieldIndex)) {
            return false;
        }
        if (this.myMax == null ? other.myMax != null : !this.myMax.equals(other.myMax)) {
            return false;
        }
        if (this.myMin == null ? other.myMin != null : !this.myMin.equals(other.myMin)) {
            return false;
        }
        if (this.myShallCopyFromField != other.myShallCopyFromField) {
            return false;
        }
        if (this.mySourceField == null ? other.mySourceField != null : !this.mySourceField.equals(other.mySourceField)) {
            return false;
        }
        if (this.mySourceFieldIndex == null ? other.mySourceFieldIndex != null : !this.mySourceFieldIndex.equals(other.mySourceFieldIndex)) {
            return false;
        }
        if (this.myValueObject == null) {
            if (other.myValueObject != null) {
                return false;
            }
        } else {
            if (!this.myValueObject.equals(other.myValueObject)) {
                return false;
            }
            if (this.myDestinationFieldIsASet != other.myDestinationFieldIsASet) {
                return false;
            }
        }
        return true;
    }

    public boolean shallCopyFromField() {
        return this.myShallCopyFromField;
    }

    @Override
    public String describeTrace(TracePoint tp) {
        StringBuffer buf = new StringBuffer();
        TraceDataSet preDataSet = TraceDataSet.createPreDataSet(tp);
        String formattedDestinationFieldName = this.describeDestinationField(preDataSet, this.myDestinationField, this.myDestinationFieldIndex);
        buf.append("SetField : ");
        buf.append(formattedDestinationFieldName);
        buf.append(" = ");
        Service service = preDataSet.getService();
        assert (service != null);
        if (this.shallCopyFromField()) {
            String value;
            try {
                T obj = this.fetchSpecialValue(preDataSet);
                FieldDefinition fd = null;
                if (obj != null) {
                    obj = this.prepareValue(obj, preDataSet);
                } else {
                    obj = this.fetchSourceFieldValueFromDataSetLegacy(preDataSet);
                    fd = AbstractSetFieldModifier.getClassRepository(preDataSet).getFieldDefinitionByName(this.mySourceField.getFieldName());
                }
                value = this.makeDisplayableValueString(fd, obj);
            }
            catch (DataSetValueNotFoundException e) {
                value = "[VALUE NOT FOUND]";
            }
            String formattedSourceFieldName = this.describeSourceField(preDataSet, this.mySourceField, this.mySourceFieldIndex);
            buf.append(formattedSourceFieldName).append(" (").append(value).append(")");
        } else {
            Object obj = this.myValueObject;
            if (obj instanceof LazyEvaluatedValue) {
                obj = ((LazyEvaluatedValue)obj).evaluate(preDataSet);
            }
            FieldDefinition fd = AbstractSetFieldModifier.getClassRepository(preDataSet).getFieldDefinitionByName(this.myDestinationField.getFieldName());
            buf.append(this.makeDisplayableValueString(fd, obj));
        }
        return buf.toString();
    }

    protected String describeDestinationField(DataSet dataset, DataSetField field, FieldIndexKeyContainer index) {
        return FieldOrientedPluginUtil.formatFieldNameWithKeyInformation(field.getFieldName(), index, dataset);
    }

    protected String describeSourceField(DataSet dataset, DataSetField field, FieldIndexKeyContainer index) {
        return this.describeDestinationField(dataset, field, index);
    }

    protected String makeDisplayableValueString(FieldDefinition associatedField, Object value) {
        assert (associatedField != null) : "This method should be overridden in the null case.";
        DefaultDataDescriber desc = new DefaultDataDescriber();
        return desc.describeObject(value, associatedField);
    }

    @Override
    public void setPreTracePointInfo(TracePoint tp) {
        PluginTraceHelper.addFieldValueAsPreDataInTracePoint(this.myDestinationField, this.myDestinationFieldIndex, tp);
        if (this.mySourceField != null) {
            PluginTraceHelper.addFieldValueAsPreDataInTracePoint(this.mySourceField, this.mySourceFieldIndex, tp);
        }
        this.addFieldValueAsPreDataInTracePointForLazyEvaluatedKeys(this.myDestinationFieldIndex, tp);
        if (this.myValueObject instanceof LazyEvaluatedExpressionProvider) {
            String expression = ((LazyEvaluatedExpressionProvider)this.myValueObject).getExpressionString();
            this.addFieldValueAsPreDataInTracePointForLazyEvaluatedValueExpression(tp, expression);
        }
    }

    private void addFieldValueAsPreDataInTracePointForLazyEvaluatedKeys(FieldIndexKeyContainer keyContainer, TracePoint tp) {
        if (keyContainer != null) {
            Object[] rawKeys;
            for (Object key : rawKeys = keyContainer.getRawKeys()) {
                if (!(key instanceof LazyEvaluatedExpressionProvider)) continue;
                String expression = ((LazyEvaluatedExpressionProvider)key).getExpressionString();
                this.addFieldValueAsPreDataInTracePointForLazyEvaluatedValueExpression(tp, expression);
            }
        }
    }

    private void addFieldValueAsPreDataInTracePointForLazyEvaluatedValueExpression(TracePoint tp, String expression) {
        DataSet preDataSet = tp.getPreDataSet();
        ClassRepository theRep = null;
        if (preDataSet != null) {
            theRep = AbstractSetFieldModifier.getClassRepository(preDataSet);
        }
        DefaultExpressionParserHandler expressionParserHandler = new DefaultExpressionParserHandler(theRep, null);
        ExpressionParser parser = new ExpressionParser(new DefaultExpressionParserOptions(), expressionParserHandler);
        Expression expr = parser.parse(expression);
        for (ExpressionToken token : expr.getExpressionTokens()) {
            if (!(token instanceof FieldValueOperand)) continue;
            Collection<FieldContainerOperand.FieldContainer> containedFields = ((FieldValueOperand)token).getContainedFields();
            for (FieldContainerOperand.FieldContainer container : containedFields) {
                DataSetField field = container.getField();
                Object index = container.getKeyObject();
                PluginTraceHelper.addFieldValueAsPreDataInTracePoint(field, (FieldIndexKeyContainer)index, tp);
            }
        }
    }

    @Override
    public void setTracePointInfo(TracePoint tp) {
        PluginTraceHelper.addFieldValueAsPostDataInTracePoint(this.myDestinationField, this.myDestinationFieldIndex, tp);
    }

    @Override
    public void perform(DataSet dataSet) {
        T valueToSet;
        T fechedValue = this.fetchSpecialValue(dataSet);
        if (fechedValue != null) {
            valueToSet = this.prepareValue(fechedValue, dataSet);
        } else if (this.myShallCopyFromField) {
            if (this.myDataSetValueReader != null) {
                fechedValue = this.fetchSourceFieldValuefromDataSet(dataSet);
            } else {
                try {
                    fechedValue = this.fetchSourceFieldValueFromDataSetLegacy(dataSet);
                }
                catch (DataSetValueNotFoundException e) {
                    return;
                }
            }
            T preparedValue = this.prepareValue(fechedValue, dataSet);
            valueToSet = this.applyStrategyOnValue(preparedValue, dataSet);
        } else {
            valueToSet = this.prepareValue(this.myValueObject, dataSet);
        }
        Key[] keySet = null;
        if (this.myDestinationFieldIndex != null) {
            if (this.myDataSetValueReader != null) {
                keySet = this.fetchDestinationFieldKeysFromDataSet(dataSet);
            } else {
                try {
                    keySet = this.myDestinationFieldIndex.getKeySet(dataSet);
                }
                catch (DataSetValueNotFoundException e) {
                    return;
                }
            }
        }
        if (this.myDestinationFieldIsASet) {
            this.setFieldInDestinationSet(dataSet, valueToSet);
        } else {
            this.setDestinationFieldValueInDataSet(dataSet, keySet, valueToSet);
        }
    }

    private void setFieldInDestinationSet(DataSet dataSet, T valueToSet) {
        Set<Object> theSet = null;
        try {
            theSet = this.myDestinationField.usesTag() ? dataSet.getDataAsSet(this.myDestinationField.getTag(), this.myDataType) : dataSet.getDataAsSet(this.myDestinationField.getFieldName(), this.myDataType);
        }
        catch (DataSetValueNotFoundException e) {
            theSet = new HashSet<T>();
        }
        theSet.add(valueToSet);
        if (this.myDestinationField.usesTag()) {
            dataSet.setDataAsSet(this.myDestinationField.getTag(), (Set<?>)theSet);
        } else {
            dataSet.setDataAsSet(this.myDestinationField.getFieldName(), theSet);
        }
    }

    private Key[] fetchDestinationFieldKeysFromDataSet(DataSet dataSet) {
        try {
            return this.myDataSetValueReader.getKeysFromDataSet(dataSet, this.myDestinationFieldIndex);
        }
        catch (RuntimeException e) {
            throw new TreeExecutionException(e);
        }
    }

    private T fetchSourceFieldValuefromDataSet(DataSet dataSet) {
        try {
            Key key = null;
            if (this.mySourceFieldIndex != null) {
                Key[] keySet = this.myDataSetValueReader.getKeysFromDataSet(dataSet, this.mySourceFieldIndex);
                key = FieldOrientedPluginUtil.extractFirstKeyFromSet(keySet);
            }
            return (T)this.myDataSetValueReader.getValueFromDataSet(dataSet, this.mySourceField, key);
        }
        catch (RuntimeException e) {
            throw new TreeExecutionException(e);
        }
    }

    private T fetchSourceFieldValueFromDataSetLegacy(DataSet theData) {
        Key key = null;
        if (this.mySourceFieldIndex != null) {
            Key[] keySet = this.mySourceFieldIndex.getKeySet(theData);
            key = FieldOrientedPluginUtil.extractFirstKeyFromSet(keySet);
        }
        return (T)this.mySourceField.getValueFromDataSet(theData, key);
    }

    private void setDestinationFieldValueInDataSet(DataSet theData, Key[] keySet, T value) {
        if (keySet != null) {
            for (Key currentKey : keySet) {
                this.myDestinationField.setValueInDataSet(theData, currentKey, value);
            }
        } else {
            this.myDestinationField.setValueInDataSet(theData, value);
        }
    }

    protected T fetchSpecialValue(DataSet dataSet) {
        return null;
    }

    protected T prepareValue(Object value, DataSet dataSet) {
        if (value instanceof LazyEvaluatedValue) {
            return ((LazyEvaluatedValue)value).evaluate(dataSet);
        }
        return (T)value;
    }

    protected T applyStrategyOnValue(T value, DataSet theData) {
        return value;
    }

    private static Element fetchIndexElementFromFieldElement(Element fieldNode) {
        return XMLUtil.getNamedElement("Index", fieldNode.getChildNodes());
    }

    @Override
    public Set<String> getUsedFields() {
        Set<String> set = super.getUsedFields();
        if (this.mySourceField != null) {
            set.add(this.mySourceField.getFieldName());
            if (this.mySourceFieldIndex != null) {
                set.addAll(this.mySourceFieldIndex.getUsedFields());
            }
        }
        set.add(this.myDestinationField.getFieldName());
        if (this.myDestinationFieldIndex != null) {
            set.addAll(this.myDestinationFieldIndex.getUsedFields());
        }
        return set;
    }

    static class SetFieldParseContext
    extends ParseContextAdapter {
        private final DataSetValueReader myDataSetReader;

        public SetFieldParseContext(ParseContext ctx, DataSetValueReader reader) {
            super(ctx);
            this.myDataSetReader = reader;
        }

        public DataSetValueReader getDataSetValueReader() {
            return this.myDataSetReader;
        }
    }
}

