/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.modifiers;

import com.ericsson.ere.annotations.jcip.Immutable;
import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.dataset.MillisecondAllocatableDataSet;
import com.ericsson.ere.dataset.RatingDataSet;
import com.ericsson.ere.dataset.task.ContinuousMillisecondTimeTask;
import com.ericsson.ere.dataset.task.TreeTask;
import com.ericsson.ere.math.RatingDecimal;
import com.ericsson.ere.selectiontree.DefaultRateException;
import com.ericsson.ere.selectiontree.ParseContext;
import com.ericsson.ere.selectiontree.TreeExecutionException;
import com.ericsson.ere.selectiontree.modifiers.ImmutableModifier;
import com.ericsson.ere.selectiontree.util.FieldIndexKeyContainer;
import com.ericsson.ere.selectiontree.util.FieldOrientedPluginUtil;
import com.ericsson.ere.selectiontree.util.FieldValueContainer;
import com.ericsson.ere.selectiontree.util.ValueFieldCompositeObject;
import com.ericsson.ere.trace.TraceDataSet;
import com.ericsson.ere.trace.TracePoint;
import com.ericsson.ere.trace.TraceableV2;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.management.DateUtil;
import java.util.HashSet;
import java.util.Set;

@Immutable
public abstract class AbstractRateField
extends ImmutableModifier
implements TraceableV2 {
    private static final RatingDecimal ONE = new RatingDecimal(1L, 1L);
    private static final RatingDecimal THOUSAND = new RatingDecimal(1000.0);
    private static final RatingDecimal SECONDS_PER_MINUTE = new RatingDecimal(60.0);
    private static final Object TRACE_PRE_COST = new Object();
    private static final Object TRACE_DURATION = new Object();
    private static final Object TRACE_POST_COST = new Object();
    private static final Object TRACE_PRICE_FACTOR = new Object();
    private final FieldValueContainer myChargingInterval;
    private final FieldValueContainer myPrice;
    private final FieldValueContainer myPriceInterval;

    AbstractRateField(ParseContext ctx, FieldValueContainer price, FieldValueContainer chargingInterval, FieldValueContainer priceInterval) {
        super(ctx);
        this.myChargingInterval = chargingInterval;
        this.myPrice = price;
        this.myPriceInterval = priceInterval;
    }

    @Override
    public void perform(DataSet dataSet) {
        MillisecondAllocatableDataSet data = this.getRatingDataSet(dataSet);
        ContinuousMillisecondTimeTask task = this.getTimeBasedTask(dataSet);
        RatingDecimal pricePerSec = this.getPricePerSecond(dataSet).multiply(data.getCurrentPriceFactor());
        RatingDecimal chargingInterval = this.validateAndTruncateInterval((RatingDecimal)this.myChargingInterval.getValue(dataSet));
        RatingDecimal priceInterval = this.validateAndTruncateInterval(this.getMyPriceInterval(dataSet));
        RatingDecimal secToRate = this.calculateSecondsToRate(task.getRemainingDuration(), chargingInterval);
        RatingDecimal adjustedPricePerSec = pricePerSec.divide(priceInterval);
        RatingDecimal cost = adjustedPricePerSec.multiply(secToRate);
        if (this.isOnlyPartialDeductPossible(data, cost)) {
            RatingDecimal numberOfIntervals = data.getMoneyLeft().divide(adjustedPricePerSec).divide(chargingInterval).round(0, 1);
            secToRate = numberOfIntervals.multiply(chargingInterval);
            cost = adjustedPricePerSec.multiply(secToRate);
        }
        task.allocateTime(secToRate.multiply(THOUSAND).longValue());
        data.allocateCost(cost);
    }

    @Override
    public String describeTrace(TracePoint tp) {
        TraceDataSet traceDataSet = TraceDataSet.createPreDataSet(tp);
        RatingDecimal currentPriceFactor = (RatingDecimal)tp.getInfo(TRACE_PRICE_FACTOR);
        RatingDecimal pricePerSec = this.getPricePerSecond(traceDataSet).multiply(currentPriceFactor);
        RatingDecimal chargingInterval = this.validateAndTruncateInterval((RatingDecimal)this.myChargingInterval.getValue(traceDataSet));
        RatingDecimal priceIntervalFactor = this.validateAndTruncateInterval(this.getMyPriceInterval(traceDataSet));
        Long durationInMilliSec = (Long)tp.getInfo(TRACE_DURATION);
        RatingDecimal preCost = (RatingDecimal)tp.getInfo(TRACE_PRE_COST);
        RatingDecimal postCost = (RatingDecimal)tp.getInfo(TRACE_POST_COST);
        RatingDecimal cost = postCost.subtract(preCost);
        RatingDecimal adjustedPricePerSec = pricePerSec.divide(priceIntervalFactor);
        long numberOfIntervalsToRate = new RatingDecimal(durationInMilliSec, 1000L).divide(chargingInterval).round(0, 0).longValue();
        long durationToRate = this.calculateSecondsToRate(durationInMilliSec, chargingInterval).multiply(THOUSAND).longValue();
        RatingDecimal adjustedPricePerMinute = adjustedPricePerSec.multiply(SECONDS_PER_MINUTE);
        RatingDecimal pricePerInterval = adjustedPricePerSec.multiply(chargingInterval);
        long ratedIntervals = cost.divide(pricePerInterval).longValue();
        String priceDisplayString = this.getFieldValueDisplayString(adjustedPricePerMinute, this.myPrice, traceDataSet);
        String chargingIntervalString = this.getFieldValueDisplayString(chargingInterval, this.myChargingInterval, traceDataSet);
        String pricePerIntervalString = this.printableRatingDecimal(pricePerInterval);
        String durationString = DateUtil.formatMilliseconds(durationToRate);
        String costString = this.printableRatingDecimal(cost);
        String accCostString = this.printableRatingDecimal(postCost);
        StringBuilder buf = new StringBuilder("Rate : Price=").append(priceDisplayString).append("/min (").append(pricePerIntervalString).append("/interval) Interval=").append(chargingIntervalString).append(" sec");
        if (!currentPriceFactor.equals(ONE)) {
            String currentPriceFactorString = this.printableRatingDecimal(currentPriceFactor);
            buf.append(". Current Price Factor=").append(currentPriceFactorString);
        }
        if (this.myPriceInterval != null) {
            String priceIntervalDisplayString = this.getFieldValueDisplayString(priceIntervalFactor, this.myPriceInterval, traceDataSet);
            buf.append(". Price Interval=").append(priceIntervalDisplayString);
        }
        buf.append(".\n      Duration to rate: ").append(durationString).append(" (").append(numberOfIntervalsToRate).append(" interval)");
        if (ratedIntervals < numberOfIntervalsToRate) {
            buf.append(". Only money available for ").append(ratedIntervals).append(" interval(s)");
        }
        buf.append("\n      Rated Cost=").append(costString).append("  Accumulated cost=").append(accCostString);
        return buf.toString();
    }

    @Override
    public void setPreTracePointInfo(TracePoint tp) {
        MillisecondAllocatableDataSet data = this.getRatingDataSet(tp.getPreDataSet());
        ContinuousMillisecondTimeTask task = this.getTimeBasedTask(tp.getPreDataSet());
        tp.addInfo(TRACE_PRE_COST, data.getCost());
        tp.addInfo(TRACE_PRICE_FACTOR, data.getCurrentPriceFactor());
        tp.addInfo(TRACE_DURATION, task.getRemainingDuration());
        this.myChargingInterval.addAsPreDataInTracePoint(tp);
        if (this.myPriceInterval != null) {
            this.myPriceInterval.addAsPreDataInTracePoint(tp);
        }
        this.myPrice.addAsPreDataInTracePoint(tp);
    }

    @Override
    public void setTracePointInfo(TracePoint tp) {
        MillisecondAllocatableDataSet data = this.getRatingDataSet(tp.getPostDataSet());
        tp.addInfo(TRACE_POST_COST, data.getCost());
    }

    @Override
    public Set<String> getUsedFields() {
        HashSet<String> usedFields = new HashSet<String>();
        usedFields.addAll(this.myPrice.getUsedFields());
        usedFields.addAll(this.myChargingInterval.getUsedFields());
        if (this.myPriceInterval != null) {
            usedFields.addAll(this.myPriceInterval.getUsedFields());
        }
        return usedFields;
    }

    private RatingDecimal getMyPriceInterval(DataSet dataSet) {
        RatingDecimal priceInterval = this.myPriceInterval == null ? ONE : (RatingDecimal)this.myPriceInterval.getValue(dataSet);
        return priceInterval;
    }

    private String getFieldValueDisplayString(RatingDecimal value, FieldValueContainer container, DataSet dataSet) {
        StringBuilder displayString = new StringBuilder();
        String valueString = this.printableRatingDecimal(value);
        if (container.containsValue()) {
            displayString.append(valueString);
        } else {
            String fieldDisplayString = container.getFieldDisplayString(dataSet);
            displayString.append(fieldDisplayString).append(" (").append(valueString).append(")");
        }
        return displayString.toString();
    }

    private RatingDecimal getPricePerSecond(DataSet dataSet) {
        RatingDecimal price = (RatingDecimal)this.myPrice.getValue(dataSet);
        if (this.myPriceInterval == null) {
            price = price.divide(SECONDS_PER_MINUTE);
        }
        return price;
    }

    private boolean isOnlyPartialDeductPossible(RatingDataSet data, RatingDecimal cost) {
        boolean hasUnlimitedMoney = data.getMoneyLeft().isMinusOne();
        return !hasUnlimitedMoney && cost.isMoreThanZero() && data.getMoneyLeft().isLessThan(cost);
    }

    private MillisecondAllocatableDataSet getRatingDataSet(DataSet dataSet) throws TreeExecutionException {
        if (!(dataSet instanceof MillisecondAllocatableDataSet)) {
            throw new TreeExecutionException("The passed data set does not have millisecond rating capabilities.");
        }
        return (MillisecondAllocatableDataSet)dataSet;
    }

    private ContinuousMillisecondTimeTask getTimeBasedTask(DataSet dataSet) throws TreeExecutionException {
        TreeTask treeTask = dataSet.getTreeTask();
        if (!(treeTask instanceof ContinuousMillisecondTimeTask)) {
            throw new TreeExecutionException("The tree task found in data set does not have millisecond time support.");
        }
        return (ContinuousMillisecondTimeTask)treeTask;
    }

    private RatingDecimal validateAndTruncateInterval(RatingDecimal interval) {
        RatingDecimal truncatedInterval = interval.round(3, 1);
        if (truncatedInterval.isLessThanOrEqualToZero()) {
            throw new DefaultRateException("Interval value (" + interval + ") to small.");
        }
        return truncatedInterval;
    }

    private RatingDecimal calculateSecondsToRate(long durationInMillis, RatingDecimal interval) {
        RatingDecimal durationInDecimalSec = new RatingDecimal(durationInMillis, 1000L);
        RatingDecimal intervals = durationInDecimalSec.divide(interval).round(0, 0);
        return interval.multiply(intervals);
    }

    private String printableRatingDecimal(RatingDecimal number) {
        return number.round(5, 6).toString();
    }

    static FieldValueContainer createFieldValueContainer(ValueFieldCompositeObject value, ValueFieldCompositeObject index, ClassRepository repo) {
        FieldValueContainer container;
        if (value.getMode() == ValueFieldCompositeObject.Mode.Value) {
            container = new FieldValueContainer((RatingDecimal)value.getValueAsObject());
        } else {
            FieldDefinition field = repo.getFieldDefinitionByName(value.getFieldOrValueAsString());
            FieldIndexKeyContainer keyIndex = FieldOrientedPluginUtil.extractIndexKeyObjectFromIndexElement(index, repo, field);
            container = new FieldValueContainer(field, keyIndex, DataType.RATINGDECIMAL);
        }
        return container;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCodeImpl();
        result = 31 * result + (this.myChargingInterval == null ? 0 : this.myChargingInterval.hashCode());
        result = 31 * result + (this.myPrice == null ? 0 : this.myPrice.hashCode());
        result = 31 * result + (this.myPriceInterval == null ? 0 : this.myPriceInterval.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !super.equalsImpl(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractRateField other = (AbstractRateField)obj;
        if (this.myChargingInterval == null ? other.myChargingInterval != null : !this.myChargingInterval.equals(other.myChargingInterval)) {
            return false;
        }
        if (this.myPrice == null ? other.myPrice != null : !this.myPrice.equals(other.myPrice)) {
            return false;
        }
        return !(this.myPriceInterval == null ? other.myPriceInterval != null : !this.myPriceInterval.equals(other.myPriceInterval));
    }
}

