/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.modifiers;

import com.ericsson.ere.constraint.contract.AbstractConstrainableProfileContract;
import com.ericsson.ere.constraint.contract.ConstraintSpecification;
import com.ericsson.ere.constraint.entity.ConstraintContext;
import com.ericsson.ere.constraint.entity.ConstraintContextItem;
import com.ericsson.ere.constraint.entity.ConstraintContextItemType;
import com.ericsson.ere.constraint.entity.ConstraintTarget;
import com.ericsson.ere.constraint.entity.ConstraintTargetType;
import com.ericsson.ere.selectiontree.modifiers.AbstractMultiFieldOperationProfile;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.defs.FieldDefinitionHelper;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class AbstractMultiFieldOperationProfileContract
extends AbstractConstrainableProfileContract {
    private Class<? extends AbstractMultiFieldOperationProfile> myProfileClass;
    private String myProfileName;

    protected AbstractMultiFieldOperationProfileContract(ClassRepository repository, Class<? extends AbstractMultiFieldOperationProfile> profileClass, String name) {
        super(repository);
        this.myProfileClass = profileClass;
        this.myProfileName = name;
    }

    private AbstractMultiFieldOperationProfile createProfileInstance() {
        try {
            AbstractMultiFieldOperationProfile profile = this.myProfileClass.newInstance();
            profile.setName(this.myProfileName);
            profile.setClassRepository(this.classRepository());
            return profile;
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to create instance of " + this.myProfileClass, ex);
        }
    }

    @Override
    protected Collection<ConstraintTarget> getConstraintTargetsImpl(ConstraintTargetType type, ConstraintContext context) {
        assert (type == ConstraintTargetType.FIELD || type == ConstraintTargetType.FEATURE) : "Unexpected target type!";
        HashSet<String> names = new HashSet<String>();
        AbstractMultiFieldOperationProfile profile = this.createProfileInstance();
        if (type == ConstraintTargetType.FEATURE) {
            this.addFeatureSpecificConstraintTargets(names, profile);
        } else if (context.equals(ConstraintContext.EMPTY_CONTEXT)) {
            List<FieldDefinition> fields = profile.getCandidateDestinationFields();
            names.addAll(FieldDefinitionHelper.extractFieldNameList(fields));
        } else {
            ConstraintContextItem destField = context.itemForType(ConstraintContextItemType.FIELD);
            assert (destField != null);
            List<String> fields = destField.isAny() ? FieldDefinitionHelper.extractFieldNameList(profile.getCandidateOperandFields(null)) : FieldDefinitionHelper.extractFieldNameList(profile.getCandidateOperandFields(destField.getValue()));
            names.addAll(fields);
        }
        return this.namesToTargets(names, type);
    }

    protected void addFeatureSpecificConstraintTargets(Collection<String> names, AbstractMultiFieldOperationProfile profile) {
    }

    @Override
    public Set<ConstraintSpecification> supportedConstraintSpecifications() {
        HashSet<ConstraintSpecification> specs = new HashSet<ConstraintSpecification>();
        specs.add(ConstraintSpecification.of(ConstraintTargetType.FIELD, new ConstraintContextItemType[0]));
        specs.add(ConstraintSpecification.of(ConstraintTargetType.FIELD, ConstraintContextItemType.FIELD));
        return specs;
    }
}

