/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.modifiers;

import com.ericsson.ere.expression.Expression;
import com.ericsson.ere.expression.ExpressionToken;
import com.ericsson.ere.expression.Operator;
import com.ericsson.ere.selectiontree.modifiers.AbstractMultiFieldOperationProfile;
import com.ericsson.ere.selectiontree.modifiers.mfo.ValueFieldCompositeOperand;
import com.ericsson.ere.selectiontree.util.FieldOrientedPluginProfileUtil;
import com.ericsson.ere.selectiontree.util.ValueFieldCompositeObject;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.defs.FieldDefinitionHelper;
import ericsson.ere.exception.NotImplementedException;
import ericsson.ere.gui.util.IndexVariableFactory;
import ericsson.ere.gui.util.VariableFactory;
import ericsson.vareditor.variable.TypedDropDownVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class AbstractBinaryDateOperationProfile
extends AbstractMultiFieldOperationProfile {
    private String myFirstOperandLabel;
    private String myFirstIndexLabel;
    private String myOperationLabel;
    private String mySecondOperandLabel;
    private String mySecondIndexLabel;

    protected AbstractBinaryDateOperationProfile(String firstOperandLabel, String firstIndexLabel, String operationLabel, String secondOperandLabel, String secondIndexLabel) {
        super("Index");
        this.myFirstOperandLabel = firstOperandLabel;
        this.myFirstIndexLabel = firstIndexLabel;
        this.myOperationLabel = operationLabel;
        this.mySecondOperandLabel = secondOperandLabel;
        this.mySecondIndexLabel = secondIndexLabel;
    }

    protected abstract Variable createOperationVariable(Operator var1);

    protected abstract List<Variable> createFirstOperandVariables(ValueFieldCompositeOperand var1);

    protected abstract List<Variable> createSecondOperandVariables(ValueFieldCompositeOperand var1);

    protected Operator operatorFromString(String valueString) {
        throw new NotImplementedException();
    }

    @Override
    public boolean parameterChanged(String reference, Variable value, List<Variable> vars) {
        boolean updated = super.parameterChanged(reference, value, vars);
        boolean doExpressionUpdate = false;
        if (this.myFirstOperandLabel.equals(reference)) {
            doExpressionUpdate = true;
            updated |= this.updateIndexVariableForFieldVariable(vars, value, this.myFirstIndexLabel, false);
        } else if (this.mySecondOperandLabel.equals(reference)) {
            doExpressionUpdate = true;
            updated |= this.updateIndexVariableForFieldVariable(vars, value, this.mySecondIndexLabel, false);
        } else if (this.myFirstIndexLabel.equals(reference) || this.mySecondIndexLabel.equals(reference)) {
            doExpressionUpdate = true;
        } else if (this.myOperationLabel.equals(reference)) {
            doExpressionUpdate = true;
        }
        if (doExpressionUpdate) {
            this.updateResultingExpression(vars, this.getCurrentExpression(vars));
        }
        return updated;
    }

    @Override
    protected List<? extends Variable> createExpressionVariables(Expression expression) {
        ValueFieldCompositeOperand operand1 = null;
        ValueFieldCompositeOperand operand2 = null;
        Operator operation = null;
        if (expression != null) {
            List<ExpressionToken> tokens = expression.getExpressionTokens();
            assert (tokens.size() == 3);
            operand1 = (ValueFieldCompositeOperand)tokens.get(0);
            operation = (Operator)tokens.get(1);
            operand2 = (ValueFieldCompositeOperand)tokens.get(2);
        }
        ArrayList<Variable> vars = new ArrayList<Variable>();
        vars.addAll(this.createFirstOperandVariables(operand1));
        Variable opvar = this.createOperationVariable(operation);
        if (opvar != null) {
            vars.add(opvar);
        }
        vars.addAll(this.createSecondOperandVariables(operand2));
        return vars;
    }

    @Override
    protected Expression getCurrentExpression(List<Variable> variables) {
        return this.createExpressionFromVariables(variables);
    }

    private Expression createExpressionFromVariables(List<Variable> vars) {
        Variable var1 = VarListUtil.getVariableForName(vars, this.myFirstOperandLabel);
        if (var1 == null) {
            return null;
        }
        Variable var1_idx = VarListUtil.getVariableForKey(vars, this.myFirstIndexLabel);
        Variable var2 = VarListUtil.getVariableForName(vars, this.mySecondOperandLabel);
        Variable var2_idx = VarListUtil.getVariableForKey(vars, this.mySecondIndexLabel);
        Variable oper = VarListUtil.getVariableForName(vars, this.myOperationLabel);
        ValueFieldCompositeObject valueOp1 = this.extractCompositeObjectFromVariable(var1);
        ValueFieldCompositeObject indexOp1 = this.extractCompositeObjectFromVariable(var1_idx);
        ValueFieldCompositeObject valueOp2 = this.extractCompositeObjectFromVariable(var2);
        ValueFieldCompositeObject indexOp2 = this.extractCompositeObjectFromVariable(var2_idx);
        Operator operation = this.getOperatorFromVariable(oper);
        ValueFieldCompositeOperand op1 = this.createOperandFromValueObjects(valueOp1, indexOp1, true);
        ValueFieldCompositeOperand op2 = this.createOperandFromValueObjects(valueOp2, indexOp2, false);
        Expression e = new Expression(Arrays.asList(op1, operation, op2), Expression.ExpressionNotation.INFIX);
        return e;
    }

    protected ValueFieldCompositeOperand createOperandFromValueObjects(ValueFieldCompositeObject value, ValueFieldCompositeObject index, boolean isFirstOperand) {
        return new ValueFieldCompositeOperand(value, index, this.containsMapField(value));
    }

    protected boolean containsMapField(ValueFieldCompositeObject value) {
        return super.containsFieldOfMapType(value);
    }

    private Operator getOperatorFromVariable(Variable var) {
        Operator op = var == null ? this.operatorFromString(null) : (var instanceof TypedDropDownVariable ? (Operator)((TypedDropDownVariable)var).getSelectedItem() : this.operatorFromString(var.getValueString()));
        return op;
    }

    @Override
    protected VariableFactory.IndexType getIndexTypeForField(FieldDefinition field, boolean ignored) {
        return FieldOrientedPluginProfileUtil.getIndexTypeForFieldSingleIndex(field);
    }

    @Override
    protected Variable createDestinationFieldVariable(List<String> destinationFields, String destField) {
        List<FieldDefinition> fields = FieldDefinitionHelper.extractFieldDefinitionList(this.myClassRepository, destinationFields);
        return FieldOrientedPluginProfileUtil.createFilterableFieldListVariable("Destination field", null, fields, destField);
    }

    @Override
    protected Variable createIndexVariableForFieldIfNecessary(String fieldName, ValueFieldCompositeObject keyObject, String indexLabel, boolean isDestination) {
        FieldDefinition field = this.myClassRepository.getFieldDefinitionByName(fieldName);
        Variable var = null;
        if (field != null) {
            VariableFactory.IndexType indexType = this.getIndexTypeForField(field, isDestination);
            boolean isNumericRangeIndex = indexType == VariableFactory.IndexType.Numeric_Range;
            IndexVariableFactory indexVariableFactory = IndexVariableFactory.buildFactory().withHierarchicalFieldSupport(true).withFilterableFieldVariable(true).withMultipleInputAllowed(isNumericRangeIndex).andRepository(this.myClassRepository);
            var = indexVariableFactory.createIndexVariableForField(indexLabel, indexLabel, field, keyObject);
        }
        return var;
    }
}

