/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.mdu.model;

import com.ericsson.ere.selectiontree.interfaces.ConfigurationParameter;
import com.ericsson.ere.selectiontree.mdu.MDUException;
import com.ericsson.ere.selectiontree.mdu.MDUTreeElement;
import com.ericsson.ere.selectiontree.mdu.filter.ExtendedSelectionTreeElementFilter;
import com.ericsson.ere.selectiontree.mdu.filter.SelectionTreeElementFilter;
import com.ericsson.ere.selectiontree.mdu.model.ConfigurationParameterPipe;
import com.ericsson.ere.selectiontree.mdu.model.MultiDataUpdateModel;
import com.ericsson.ere.selectiontree.mdu.model.MultiDataUpdateModelUtil;
import com.ericsson.ere.selectiontree.mdu.model.SelectionTreeElementSelector;
import com.ericsson.ere.selectiontree.mdu.model.SelectionTreeElementType;
import com.ericsson.ere.selectiontree.mdu.model.SelectionTreeElementTypeImpl;
import com.ericsson.ere.util.CollectionUtils;
import com.ericsson.ere.util.Transformer;
import ericsson.ere.interfaces.TariffStructureNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.w3c.dom.Node;

public class MultiDataUpdateModelImpl
implements MultiDataUpdateModel {
    private final Map<String, SelectionTreeElementType> myElementByNameMap;
    private final Map<SelectionTreeElementType, List<TariffStructureNode>> myNodesByElementTypeMap;
    private final MDUTreeElement myRoot;
    private final Stack<UndoEntry> myUndoEntryStack;
    private UndoCacheState myUndoCacheState;

    private MultiDataUpdateModelImpl(TariffStructureNode root, Map<SelectionTreeElementType, List<TariffStructureNode>> elementMap) {
        this.myNodesByElementTypeMap = elementMap;
        this.myElementByNameMap = CollectionUtils.createMap(elementMap.keySet(), new Transformer<SelectionTreeElementType, String>(){

            @Override
            public String transform(SelectionTreeElementType input) {
                return input.getTypeName();
            }
        });
        this.myRoot = (MDUTreeElement)((Object)root);
        this.myUndoEntryStack = new Stack();
        this.myUndoCacheState = UndoCacheState.COLLECTING;
    }

    public static MultiDataUpdateModelImpl build(TariffStructureNode root, SelectionTreeElementSelector selector, ConfigurationParameterPipe pipe) {
        if (root == null || selector == null || pipe == null) {
            throw new IllegalArgumentException("All arguments must be non-null.");
        }
        if (!(root instanceof MDUTreeElement)) {
            throw new IllegalArgumentException("The structure root must implement " + MDUTreeElement.class.getName());
        }
        List<TariffStructureNode> elements = MultiDataUpdateModelUtil.collectMatchingElements(root, selector);
        Map<String, List<TariffStructureNode>> stringMap = CollectionUtils.bucket(elements, new ElementTypeNameExtractor());
        Map<SelectionTreeElementType, List<TariffStructureNode>> elementMap = MultiDataUpdateModelImpl.createElementTypeMap(pipe, stringMap);
        return new MultiDataUpdateModelImpl(root, elementMap);
    }

    private static Map<SelectionTreeElementType, List<TariffStructureNode>> createElementTypeMap(ConfigurationParameterPipe pipe, Map<String, List<TariffStructureNode>> stringMap) {
        HashMap<SelectionTreeElementType, List<TariffStructureNode>> elementMap = new HashMap<SelectionTreeElementType, List<TariffStructureNode>>();
        for (Map.Entry<String, List<TariffStructureNode>> entry : stringMap.entrySet()) {
            TariffStructureNode elem = entry.getValue().get(0);
            Collection<ConfigurationParameter> params = ((MDUTreeElement)((Object)elem)).getParameters();
            if ((params = pipe.transform(params)).isEmpty()) continue;
            elementMap.put(new SelectionTreeElementTypeImpl(entry.getKey(), params), entry.getValue());
        }
        return elementMap;
    }

    @Override
    public SelectionTreeElementType getElementTypeByName(String name) {
        SelectionTreeElementType type = this.myElementByNameMap.get(name);
        if (type == null) {
            throw new IllegalArgumentException("Unknown element type: " + name);
        }
        return type;
    }

    @Override
    public Collection<SelectionTreeElementType> getElementTypes() {
        return Collections.unmodifiableCollection(this.myNodesByElementTypeMap.keySet());
    }

    @Override
    public Collection<Object> getParameterValues(ConfigurationParameter p, SelectionTreeElementFilter filter) {
        SelectionTreeElementType et = ((SelectionTreeElementTypeImpl.ElementTypeConfigurationParameter)p).getElementType();
        List<TariffStructureNode> all = this.myNodesByElementTypeMap.get(et);
        Collection<TariffStructureNode> list = this.filterElements(all, filter);
        return this.getValues(p, list);
    }

    private Collection<TariffStructureNode> filterElements(Collection<TariffStructureNode> elements, SelectionTreeElementFilter filter) {
        if (filter instanceof ExtendedSelectionTreeElementFilter) {
            return ((ExtendedSelectionTreeElementFilter)filter).filter(elements);
        }
        return CollectionUtils.filter(elements, filter);
    }

    @Override
    public List<TariffStructureNode> getElementsOfType(SelectionTreeElementType type) {
        return Collections.unmodifiableList(this.myNodesByElementTypeMap.get(type));
    }

    @Override
    public void setParameterValue(ConfigurationParameter p, SelectionTreeElementFilter filter, Object newValue) {
        SelectionTreeElementType et = ((SelectionTreeElementTypeImpl.ElementTypeConfigurationParameter)p).getElementType();
        ArrayList<TariffStructureNode> list = new ArrayList<TariffStructureNode>((Collection)this.myNodesByElementTypeMap.get(et));
        CollectionUtils.filterInPlace(list, filter);
        if (!list.isEmpty()) {
            this.setValues(p, list, newValue);
        }
    }

    @Override
    public void applyChanges() {
        for (Map.Entry<SelectionTreeElementType, List<TariffStructureNode>> entry : this.myNodesByElementTypeMap.entrySet()) {
            for (TariffStructureNode tn : entry.getValue()) {
                ((MDUTreeElement)((Object)tn)).applyChanges();
            }
        }
        this.myUndoCacheState = UndoCacheState.REVERTABLE;
    }

    @Override
    public void revertChanges() {
        if (this.myUndoCacheState != UndoCacheState.REVERTABLE) {
            throw new IllegalStateException("Changes have not been applied.");
        }
        if (!this.myUndoEntryStack.isEmpty()) {
            while (!this.myUndoEntryStack.isEmpty()) {
                UndoEntry entry = this.myUndoEntryStack.pop();
                entry.element.setParameterValue(entry.parameter, entry.value);
            }
            this.applyChanges();
        }
        this.myUndoCacheState = UndoCacheState.COLLECTING;
    }

    @Override
    public Node getConfiguration() {
        return this.myRoot.getConfiguration();
    }

    private Collection<Object> getValues(ConfigurationParameter param, Collection<TariffStructureNode> tns) {
        Collection<Object> values = CollectionUtils.transformDetached(tns, new PropertyValueExtractor(param));
        return values;
    }

    private void setValues(ConfigurationParameter param, Collection<TariffStructureNode> tns, Object newValue) {
        if (param.isReadOnly()) {
            throw new MDUException("Cannot set a value for a read-only configuration parameter.");
        }
        for (TariffStructureNode tn : tns) {
            String pname = param.getName();
            MDUTreeElement mte = (MDUTreeElement)((Object)tn);
            Object oldValue = mte.getParameterValue(pname);
            if (this.myUndoCacheState != UndoCacheState.COLLECTING) {
                this.myUndoEntryStack.clear();
                this.myUndoCacheState = UndoCacheState.COLLECTING;
            }
            this.myUndoEntryStack.push(new UndoEntry(mte, pname, oldValue));
            mte.setParameterValue(pname, newValue);
        }
    }

    private static class ElementTypeNameExtractor
    implements Transformer<TariffStructureNode, String> {
        private ElementTypeNameExtractor() {
        }

        @Override
        public String transform(TariffStructureNode input) {
            return ((MDUTreeElement)((Object)input)).getTypeName();
        }
    }

    private class PropertyValueExtractor
    implements Transformer<TariffStructureNode, Object> {
        private ConfigurationParameter myParameter;

        PropertyValueExtractor(ConfigurationParameter param) {
            this.myParameter = param;
        }

        @Override
        public Object transform(TariffStructureNode input) {
            return ((MDUTreeElement)((Object)input)).getParameterValue(this.myParameter.getName());
        }
    }

    private static class UndoEntry {
        MDUTreeElement element;
        String parameter;
        Object value;

        UndoEntry(MDUTreeElement elem, String param, Object value) {
            this.element = elem;
            this.parameter = param;
            this.value = value;
        }
    }

    private static enum UndoCacheState {
        COLLECTING,
        REVERTABLE;

    }
}

