/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.mdu;

import com.ericsson.ere.selectiontree.ElementConfigurationHelper;
import com.ericsson.ere.selectiontree.ParseContext;
import com.ericsson.ere.selectiontree.ParseContextAdapter;
import com.ericsson.ere.selectiontree.TariffStructureNodeExtension;
import com.ericsson.ere.selectiontree.TariffStructureNodeMetaDataExtension;
import com.ericsson.ere.selectiontree.interfaces.ConfigurationParameter;
import com.ericsson.ere.selectiontree.interfaces.PluginConfiguration;
import com.ericsson.ere.selectiontree.mdu.MDUException;
import com.ericsson.ere.selectiontree.mdu.MDUTargetElement;
import com.ericsson.ere.selectiontree.mdu.MDUTreeElement;
import com.ericsson.ere.selectiontree.util.PluginConfigurationHelper;
import com.ericsson.ere.util.CollectionUtils;
import com.ericsson.ere.util.Transformer;
import ericsson.ere.interfaces.TariffStructureNode;
import ericsson.ere.util.StringUtil;
import ericsson.ere.xml.XMLUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class MDUTreeElementImpl
extends TariffStructureNodeMetaDataExtension<MDUTreeElement>
implements MDUTreeElement {
    public static final String ATTR_PRODUCT_TAG = "productTag";
    private NodeModifiableParseContext myContext;
    private PluginConfiguration myConfigInstance;
    private Map<String, ConfigurationParameter> myParameters;
    private Class<?> myTargetClass;
    private boolean mySkipCreateConfigInstance;
    private Object myParamLock = new Object();
    private static final ElementConfigurationHelper.ConfigExtractor CONFIG_EXTRACTOR = new ElementConfigurationHelper.ConfigExtractor(){

        @Override
        public Node transform(TariffStructureNode input) {
            return ((MDUTreeElement)((Object)input)).getConfiguration();
        }
    };

    private MDUTreeElementImpl(TariffStructureNode target, ParseContext context) {
        super(MDUTreeElement.class, target, Collections.emptyMap());
        this.myContext = new NodeModifiableParseContext(context);
        this.myTargetClass = target.isLink() ? null : ((MDUTargetElement)((Object)target)).getTargetClass();
    }

    public static TariffStructureNode createMDUTreeElement(TariffStructureNode element, ParseContext context) {
        MDUTreeElementImpl handler = new MDUTreeElementImpl(element, context);
        return TariffStructureNodeExtension.createExtension(element, handler, MDUTreeElement.class);
    }

    @Override
    public boolean hasConfigurationClass() {
        this.ensureConfigurationInstanceCreated();
        return this.myConfigInstance != null;
    }

    @Override
    public void applyChanges() {
        if (this.myConfigInstance == null) {
            return;
        }
        Element newConfig = this.getNewXML();
        this.replaceConfigWith(newConfig);
    }

    private void replaceConfigWith(Node n) {
        Node node = n;
        TariffStructureNode tn = (TariffStructureNode)this.getThis();
        if (!ElementConfigurationHelper.isParentLess(tn)) {
            node = ElementConfigurationHelper.insertNodeInDocument(tn, node, CONFIG_EXTRACTOR);
        }
        this.myContext.config = node;
        this.myConfigInstance = null;
    }

    private Element getNewXML() {
        Element current = (Element)this.getConfiguration();
        Element newConf = current.getOwnerDocument().createElement(current.getNodeName());
        this.myConfigInstance.appendXML(newConf);
        Node firstElementChild = this.getFirstElementChild(newConf);
        this.transferAttributes(current, newConf);
        this.transferTypeName(current, newConf, firstElementChild);
        this.transferOptionalComment(current, newConf, firstElementChild);
        return newConf;
    }

    private void transferTypeName(Element source, Element dest, Node insertBefore) {
        Document owner = dest.getOwnerDocument();
        String text = XMLUtil.getFirstTextContent(source);
        if (!StringUtil.isEmptyString(text)) {
            dest.insertBefore(owner.createTextNode(text), insertBefore);
        }
    }

    private void transferOptionalComment(Element source, Element dest, Node insertBefore) {
        Document owner = dest.getOwnerDocument();
        List<Element> comments = XMLUtil.getElementNodesNamed("Comment", source.getChildNodes());
        if (!comments.isEmpty()) {
            String comment = XMLUtil.getFirstTextContent(comments.get(0));
            Element commentCopy = owner.createElement("Comment");
            commentCopy.appendChild(owner.createTextNode(comment));
            dest.insertBefore(commentCopy, insertBefore);
        }
    }

    private Node getFirstElementChild(Node node) {
        List<Node> elementChildren = XMLUtil.getElementChildren(node);
        Node firstElementChild = elementChildren.isEmpty() ? null : elementChildren.get(0);
        return firstElementChild;
    }

    private void transferAttributes(Element source, Element dest) {
        NamedNodeMap attrs = source.getAttributes();
        if (attrs != null) {
            int len = attrs.getLength();
            for (int i = 0; i < len; ++i) {
                Attr attr = (Attr)attrs.item(i);
                dest.setAttribute(attr.getName(), attr.getValue());
            }
        }
    }

    @Override
    public Collection<ConfigurationParameter> getParameters() {
        this.ensureConfigurationInstanceCreated();
        return this.myConfigInstance != null ? this.myConfigInstance.getParameters() : Collections.emptyList();
    }

    @Override
    public Object getParameterValue(String name) {
        ConfigurationParameter param = this.configurationParameterByName(name);
        return this.myConfigInstance.getParameterValue(param.getName());
    }

    @Override
    public void setParameterValue(String name, Object value) {
        ConfigurationParameter param = this.configurationParameterByName(name);
        this.myConfigInstance.setParameterValue(param.getName(), value);
    }

    @Override
    public Node getConfiguration() {
        return this.myContext.getXMLNode();
    }

    @Override
    public Object getElementData(Object key) {
        if (key == CONFIG_NODE_KEY) {
            return this.getConfiguration();
        }
        return super.getElementData(key);
    }

    @Override
    public void setElementData(Object key, Object value) {
        if (key == CONFIG_NODE_KEY) {
            throw new IllegalArgumentException("Setting the configuration node is not supported.");
        }
        super.setElementData(key, value);
    }

    @Override
    public String getProductTag() {
        Element config = (Element)this.getConfiguration();
        String elementTag = config.hasAttribute(ATTR_PRODUCT_TAG) ? config.getAttribute(ATTR_PRODUCT_TAG) : null;
        return elementTag;
    }

    @Override
    public String getTypeName() {
        String str = null;
        this.ensureConfigurationInstanceCreated();
        if (this.myConfigInstance != null) {
            str = this.myConfigInstance.getTypeName();
        }
        TariffStructureNode target = this.getTarget();
        if (str == null && target instanceof MDUTargetElement) {
            str = ((MDUTargetElement)((Object)target)).getElementTypeName();
        }
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConfigurationParameter configurationParameterByName(String name) {
        ConfigurationParameter param;
        this.ensureParametersCached();
        if (this.myConfigInstance == null) {
            throw new IllegalArgumentException("Unknown parameter: " + name);
        }
        Object object = this.myParamLock;
        synchronized (object) {
            param = this.myParameters.get(name);
            if (param == null) {
                throw new IllegalArgumentException("Unknown parameter: " + name);
            }
        }
        return param;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureParametersCached() {
        this.ensureConfigurationInstanceCreated();
        if (this.myParameters == null && this.myConfigInstance != null) {
            Object object = this.myParamLock;
            synchronized (object) {
                this.myParameters = CollectionUtils.createMap(this.myConfigInstance.getParameters(), new Transformer<ConfigurationParameter, String>(){

                    @Override
                    public String transform(ConfigurationParameter input) {
                        return input.getName();
                    }
                });
            }
        }
    }

    private void ensureConfigurationInstanceCreated() {
        if (this.myConfigInstance == null && !this.mySkipCreateConfigInstance && this.myTargetClass != null) {
            this.myConfigInstance = this.createConfigurationInstance();
            if (this.myConfigInstance == null) {
                this.mySkipCreateConfigInstance = true;
            }
        }
    }

    private PluginConfiguration createConfigurationInstance() {
        try {
            return PluginConfigurationHelper.createConfigurationInstance(this.myTargetClass, (ParseContext)this.myContext);
        }
        catch (IllegalStateException ex) {
            return null;
        }
        catch (InvocationTargetException ex) {
            throw new MDUException("Failed to create configuration instance.", ex);
        }
    }

    private static class NodeModifiableParseContext
    extends ParseContextAdapter {
        Node config;

        NodeModifiableParseContext(ParseContext pc) {
            super(pc);
            this.config = pc.getXMLNode();
        }

        @Override
        public Node getXMLNode() {
            return this.config;
        }
    }
}

