/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.mdu;

import com.ericsson.ere.selectiontree.ParseContext;
import com.ericsson.ere.selectiontree.SelectionTreeNodeFactoryImpl;
import com.ericsson.ere.selectiontree.WrappingSelectionTreeNodeFactory;
import com.ericsson.ere.selectiontree.conditions.ConditionLink;
import com.ericsson.ere.selectiontree.mdu.MDUCompoundCondition;
import com.ericsson.ere.selectiontree.mdu.MDUCondition;
import com.ericsson.ere.selectiontree.mdu.MDUModifier;
import com.ericsson.ere.selectiontree.mdu.MDUNodeStatement;
import com.ericsson.ere.selectiontree.mdu.MDUTariffStructure;
import com.ericsson.ere.selectiontree.mdu.MDUTreeElementImpl;
import com.ericsson.ere.selectiontree.modifiers.ModifierLink;
import com.ericsson.ere.selectiontree.statements.StatementLink;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.interfaces.TariffStructureNode;
import org.w3c.dom.Node;

public class MDUTreeElementFactory
extends WrappingSelectionTreeNodeFactory {
    private ClassRepository myRepository;
    private String myRatingPlan;

    public MDUTreeElementFactory(ClassRepository rep, String ratingPlan) {
        super(new InnerFactory(rep, ratingPlan));
        this.myRepository = rep;
        this.myRatingPlan = ratingPlan;
    }

    @Override
    protected TariffStructureNode createWrapper(TariffStructureNode tn, Node config) {
        return MDUTreeElementImpl.createMDUTreeElement(tn, new CustomParseContext(config));
    }

    @Override
    public TariffStructureNode finish(TariffStructureNode structure) {
        return structure;
    }

    private static class InnerFactory
    extends SelectionTreeNodeFactoryImpl {
        InnerFactory(ClassRepository rep, String ratingPlan) {
            super(rep, ratingPlan);
        }

        @Override
        public TariffStructureNode createCondition(Node iterator, TariffStructureNode[] children) throws InstantiationException, IllegalAccessException, ClassNotFoundException, Exception {
            if (this.isLink(iterator)) {
                return (TariffStructureNode)((Object)new ConditionLink().init(iterator));
            }
            if (children == null || children.length == 0) {
                return new MDUCondition(this.pc(iterator));
            }
            return new MDUCompoundCondition(this.pc(iterator), children);
        }

        @Override
        public TariffStructureNode createModifier(Node iterator, TariffStructureNode[] children) throws InstantiationException, IllegalAccessException, ClassNotFoundException, Exception {
            if (this.isLink(iterator)) {
                return (TariffStructureNode)((Object)new ModifierLink().init(iterator));
            }
            return new MDUModifier(this.pc(iterator));
        }

        @Override
        public TariffStructureNode createNode(Node iterator, TariffStructureNode[] children) throws InstantiationException, IllegalAccessException, ClassNotFoundException, Exception {
            if (this.isLink(iterator)) {
                return (TariffStructureNode)((Object)new StatementLink().init(iterator));
            }
            return new MDUNodeStatement(this.pc(iterator), children);
        }

        @Override
        public TariffStructureNode createTariffStructure(Node iterator, TariffStructureNode[] children) throws InstantiationException, IllegalAccessException, ClassNotFoundException, Exception {
            return new MDUTariffStructure(this.pc(iterator), children);
        }

        @Override
        public TariffStructureNode finish(TariffStructureNode structure) {
            return structure;
        }

        ParseContext pc(Node config) {
            return super.createParseContext(config);
        }
    }

    private class CustomParseContext
    implements ParseContext {
        private Node myConfig;

        CustomParseContext(Node config) {
            this.myConfig = config;
        }

        @Override
        public ClassRepository getClassRepository() {
            return MDUTreeElementFactory.this.myRepository;
        }

        @Override
        public String getRatingPlanName() {
            return MDUTreeElementFactory.this.myRatingPlan;
        }

        @Override
        public Node getXMLNode() {
            return this.myConfig;
        }
    }
}

