/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.time;

import com.ericsson.ere.annotations.jcip.Immutable;
import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.dataset.DataSetField;
import com.ericsson.ere.dataset.DataSetValueNotFoundException;
import com.ericsson.ere.dataset.DefaultDataDescriber;
import com.ericsson.ere.datatype.ERETime;
import com.ericsson.ere.datatype.ERETimeUtil;
import com.ericsson.ere.datatype.LazyEvaluatedValue;
import com.ericsson.ere.selectiontree.ParseContext;
import com.ericsson.ere.selectiontree.conditions.ImmutableFieldMappableCondition;
import com.ericsson.ere.selectiontree.interfaces.FieldKeyIndexUser;
import com.ericsson.ere.selectiontree.util.OperatorUtil;
import com.ericsson.ere.trace.PluginTraceHelper;
import com.ericsson.ere.trace.TraceDataSet;
import com.ericsson.ere.trace.TracePoint;
import com.ericsson.ere.trace.TraceableV2;
import com.ericsson.ere.util.FieldDefinitionUtil;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.interfaces.TariffStructureNode;
import ericsson.ere.xml.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@Immutable
public final class TimeCondition
extends ImmutableFieldMappableCondition
implements FieldKeyIndexUser,
TraceableV2 {
    public static final String TAG_TIME_OPERATOR = "Operator";
    public static final String TAG_TIME_VALUE = "TimeValue";
    protected static final String TESTED_VALUE = "Tested_Value";
    private static final Object COMPARISON_TIME = new Object();
    private final OperatorUtil.Operator myOperator;
    private final ERETime myInputTimeToTest;

    private TimeCondition(ParseContext ctx) {
        super(ctx);
        NodeList childNodes = ctx.getXMLNode().getChildNodes();
        Element operatorNode = XMLUtil.getNamedElement(TAG_TIME_OPERATOR, childNodes);
        String escapedOperator = XMLUtil.getFirstTextContent(operatorNode);
        String operatorString = OperatorUtil.tokenToOperator(escapedOperator);
        this.myOperator = OperatorUtil.getOperatorAsEnum(operatorString);
        Element fieldValueNode = XMLUtil.getNamedElement(TAG_TIME_VALUE, childNodes);
        String fieldValue = XMLUtil.getFirstTextContent(fieldValueNode);
        ClassRepository rep = ctx.getClassRepository();
        FieldDefinition field = rep.getFieldDefinitionByName(this.key);
        DataType resolver = field != null ? FieldDefinitionUtil.createValueResolver(rep, field) : DataType.TIME;
        this.myInputTimeToTest = (ERETime)resolver.parseValueString(fieldValue);
    }

    public static TimeCondition create(ParseContext ctx, TariffStructureNode[] notUsed) {
        return new TimeCondition(ctx);
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCodeImpl();
        result = 31 * result + (this.myInputTimeToTest == null ? 0 : this.myInputTimeToTest.hashCode());
        result = 31 * result + (this.myOperator == null ? 0 : this.myOperator.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !super.equalsImpl(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimeCondition other = (TimeCondition)obj;
        if (this.myInputTimeToTest == null ? other.myInputTimeToTest != null : !this.myInputTimeToTest.equals(other.myInputTimeToTest)) {
            return false;
        }
        return !(this.myOperator == null ? other.myOperator != null : !this.myOperator.equals((Object)other.myOperator));
    }

    @Override
    public boolean test(DataSet theData) {
        boolean result = false;
        try {
            ERETime timeToTest = this.getTimeValue(theData);
            ERETime timeToCompareTo = this.getComparisonTime(theData);
            result = this.myOperator.test(timeToTest.compareTo(timeToCompareTo), 0L);
        }
        catch (DataSetValueNotFoundException dataSetValueNotFoundException) {
            // empty catch block
        }
        return result;
    }

    private ERETime getComparisonTime(DataSet theData) {
        ERETime dateToCompareTo = this.myInputTimeToTest;
        if (dateToCompareTo instanceof LazyEvaluatedValue) {
            dateToCompareTo = (ERETime)((LazyEvaluatedValue)((Object)dateToCompareTo)).evaluate(theData);
        }
        return dateToCompareTo;
    }

    private ERETime getTimeValue(DataSet theData) {
        return ERETimeUtil.convertToERETime(this.extractFieldValueFromDataSet(theData, this.myField));
    }

    @Override
    public String describeTrace(TracePoint tp) {
        TraceDataSet preDataset = TraceDataSet.createPreDataSet(tp);
        FieldDefinition fd = TimeCondition.getClassRepository(preDataset).getFieldDefinitionByName(this.key);
        String timeValue = null;
        try {
            ERETime dataSetFieldValue = this.getTimeValue(preDataset);
            if (dataSetFieldValue != null) {
                timeValue = this.describeValue(dataSetFieldValue, preDataset);
            }
        }
        catch (RuntimeException dataSetFieldValue) {
            // empty catch block
        }
        ERETime comparisonDate = (ERETime)tp.getInfo(COMPARISON_TIME);
        String inputDateFormatted = comparisonDate != null ? this.makeDisplayableString(comparisonDate, fd) : "[VALUE NOT FOUND]";
        String op = OperatorUtil.operatorString[this.myOperator.ordinal()];
        return this.createTraceDescriptionText("Time", this.describeFieldName(preDataset), timeValue, op, inputDateFormatted);
    }

    private String makeDisplayableString(ERETime value, FieldDefinition fd) {
        DefaultDataDescriber desc = new DefaultDataDescriber();
        return fd != null ? desc.describeObject((Object)value, fd) : desc.describeObject((Object)value, DataType.TIME);
    }

    @Override
    public void setPreTracePointInfo(TracePoint tp) {
        PluginTraceHelper.addFieldValueAsPreDataInTracePoint(this.myField, this.myKeyIndex, tp);
        tp.addInfo(COMPARISON_TIME, this.getComparisonTime(tp.getPreDataSet()));
    }

    @Override
    public void setTracePointInfo(TracePoint tp) {
    }

    @Override
    protected DataSetField createDataSetField(ParseContext ctx) {
        return this.createDataSetField(ctx, DataType.TIME);
    }
}

